/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XMLConverter {
    static Logger logger = Logger.getLogger((String)XMLConverter.class.getName());
    protected DOMParser parser = null;
    private static boolean outputEscaping = true;

    public XMLConverter() {
        try {
            this.parser = new DOMParser();
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.parser.setErrorHandler((ErrorHandler)new ParseErrorHandler());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    public void setEntityResolver(EntityResolver er) {
        this.parser.setEntityResolver(er);
    }

    public static Element nodeToElement(Node node) {
        if (node == null) {
            return null;
        }
        short nodeType = node.getNodeType();
        if (nodeType == 9) {
            Document docNode = (Document)node;
            return docNode.getDocumentElement();
        }
        if (nodeType == 1) {
            return (Element)node;
        }
        String message = "Expecting Document or Element node type but got " + node.getNodeName() + "\nReturning null";
        System.err.println(message);
        logger.warn((Object)message);
        return null;
    }

    public Document getDOM(String in) {
        try {
            StringReader reader = new StringReader(in);
            InputSource xml_source = new InputSource(reader);
            this.parser.parse(xml_source);
            Document doc = this.parser.getDocument();
            return doc;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public Document getDOM(File in) {
        try {
            FileReader reader = new FileReader(in);
            InputSource xml_source = new InputSource(reader);
            this.parser.parse(xml_source);
            Document doc = this.parser.getDocument();
            return doc;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Document getDOM(File in, String encoding) {
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(in), encoding);
            InputSource xml_source = new InputSource(isr);
            this.parser.parse(xml_source);
            Document doc = this.parser.getDocument();
            return doc;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public static Document newDOM() {
        DocumentImpl doc = new DocumentImpl();
        return doc;
    }

    public static Document newDOM(String qualifiedName, String publicID, String systemID) {
        DocumentImpl docImpl = new DocumentImpl();
        DocumentTypeImpl myDocType = new DocumentTypeImpl((CoreDocumentImpl)docImpl, qualifiedName, publicID, systemID);
        try {
            docImpl.appendChild((Node)myDocType);
        }
        catch (Exception e) {
            System.out.println("Could not append docType because: " + e);
        }
        return docImpl;
    }

    public static String getString(Node xmlNode) {
        outputEscaping = true;
        StringBuffer xmlRepresentation = new StringBuffer();
        XMLConverter.getString(xmlNode, xmlRepresentation, 0, false);
        return xmlRepresentation.toString();
    }

    public static String getPrettyString(Node xmlNode) {
        outputEscaping = true;
        StringBuffer xmlRepresentation = new StringBuffer();
        XMLConverter.getString(xmlNode, xmlRepresentation, 0, true);
        return xmlRepresentation.toString();
    }

    private static void getString(Node xmlNode, StringBuffer xmlRepresentation, int depth, boolean pretty) {
        if (xmlNode == null) {
            xmlRepresentation.append("<null>");
            return;
        }
        short nodeType = xmlNode.getNodeType();
        String nodeName = xmlNode.getNodeName();
        if (nodeType == 9) {
            Document xmlDocNode = (Document)xmlNode;
            if (xmlDocNode.getDoctype() != null) {
                DocumentType dt = xmlDocNode.getDoctype();
                String name = dt.getName();
                String pid = dt.getPublicId();
                String sid = dt.getSystemId();
                String doctype_str = "<!DOCTYPE " + dt.getName() + " PUBLIC \"" + pid + "\" \"" + sid + "\">\n";
                xmlRepresentation.append(doctype_str);
            }
            XMLConverter.getString(xmlDocNode.getDocumentElement(), xmlRepresentation, depth, pretty);
            return;
        }
        if (nodeType == 1) {
            int i;
            if (pretty) {
                xmlRepresentation.append("\n");
                for (int i2 = 0; i2 < depth; ++i2) {
                    xmlRepresentation.append("  ");
                }
            }
            xmlRepresentation.append("<");
            xmlRepresentation.append(nodeName);
            NamedNodeMap nodeAttributes = xmlNode.getAttributes();
            for (int i3 = 0; i3 < nodeAttributes.getLength(); ++i3) {
                Node attribute = nodeAttributes.item(i3);
                xmlRepresentation.append(" ");
                xmlRepresentation.append(attribute.getNodeName());
                xmlRepresentation.append("=\"");
                xmlRepresentation.append(attribute.getNodeValue());
                xmlRepresentation.append("\"");
            }
            if (!xmlNode.hasChildNodes()) {
                xmlRepresentation.append(" />");
                return;
            }
            xmlRepresentation.append(">");
            NodeList children = xmlNode.getChildNodes();
            boolean do_pretty = pretty;
            for (i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() == 3) {
                    do_pretty = false;
                }
                XMLConverter.getString(children.item(i), xmlRepresentation, depth + 1, do_pretty);
            }
            if (pretty && xmlRepresentation.charAt(xmlRepresentation.length() - 1) == '\n') {
                for (i = 0; i < depth; ++i) {
                    xmlRepresentation.append("  ");
                }
            }
            xmlRepresentation.append("</");
            xmlRepresentation.append(nodeName);
            xmlRepresentation.append(">");
            if (pretty) {
                xmlRepresentation.append("\n");
            }
        } else if (nodeType == 3) {
            String text = xmlNode.getNodeValue();
            if (outputEscaping) {
                text = text.replaceAll("&", "&amp;");
                text = text.replaceAll("<", "&lt;");
                text = text.replaceAll(">", "&gt;");
                text = text.replaceAll("\"", "&quot;");
                text = text.replaceAll("'", "&apos;");
            }
            text = text.replaceAll("\u0003", "");
            xmlRepresentation.append(text);
        } else if (nodeType == 7) {
            if (nodeName.equals("javax.xml.transform.disable-output-escaping")) {
                outputEscaping = false;
            } else if (nodeName.equals("javax.xml.transform.enable-output-escaping")) {
                outputEscaping = true;
            } else {
                logger.warn((Object)("Unhandled processing instruction " + nodeName));
            }
        } else if (nodeType == 8) {
            String text = xmlNode.getNodeValue();
            xmlRepresentation.append("<!-- ");
            xmlRepresentation.append(text);
            xmlRepresentation.append(" -->");
        } else {
            logger.warn((Object)("Unknown node type: " + nodeType + " " + XMLConverter.getNodeTypeString(nodeType)));
        }
    }

    protected static String getNodeTypeString(short node_type) {
        String type = "";
        switch (node_type) {
            case 2: {
                type = "ATTRIBUTE_NODE";
                break;
            }
            case 4: {
                type = "CDATA_SECTION_NODE";
                break;
            }
            case 8: {
                type = "COMMENT_NODE";
                break;
            }
            case 11: {
                type = "DOCUMENT_FRAGMENT_NODE";
                break;
            }
            case 9: {
                type = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                type = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 1: {
                type = "ELEMENT_NODE";
                break;
            }
            case 6: {
                type = "ENTITY_NODE";
                break;
            }
            case 5: {
                type = "ENTITY_REFERENCE_NODE";
                break;
            }
            case 12: {
                type = "NOTATION_NODE";
                break;
            }
            case 7: {
                type = "PROCESSING_INSTRUCTION_NODE";
                break;
            }
            case 3: {
                type = "TEXT_NODE";
                break;
            }
            default: {
                type = "UNKNOWN";
            }
        }
        return type;
    }

    public String getParseErrorMessage() {
        ParseErrorHandler errorHandler = (ParseErrorHandler)this.parser.getErrorHandler();
        return errorHandler.getErrorMessage();
    }

    public static class ParseErrorHandler
    implements ErrorHandler {
        protected String errorMessage = null;

        public void error(SAXParseException exception) {
            this.handleError("Error:\n", exception);
        }

        public void fatalError(SAXParseException exception) {
            this.handleError("Fatal Error:\n", exception);
        }

        public void warning(SAXParseException exception) {
            this.handleError("Warning:\n", exception);
        }

        public String toString(SAXParseException e) {
            String msg = e.getMessage();
            msg = msg + "\nOn line(column): " + e.getLineNumber() + "(" + e.getColumnNumber() + ")";
            msg = msg + (e.getPublicId() != null ? "\npublic ID: " + e.getPublicId() : "\nNo public ID");
            msg = msg + (e.getSystemId() != null ? "\nsystem ID: " + e.getSystemId() : "\nNo system ID");
            return msg;
        }

        public String getErrorMessage() {
            String errMsg = this.errorMessage;
            if (this.errorMessage != null) {
                this.errorMessage = null;
            }
            return errMsg;
        }

        protected void handleError(String errorType, SAXParseException exception) {
            this.errorMessage = errorType + this.toString(exception);
            System.err.println("\n****Error parsing xml:\n" + this.errorMessage + "\n****\n");
            logger.error((Object)this.errorMessage);
        }
    }
}

