/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.greenstone.gsdl3.util.OID;

public class OIDTest
extends TestCase {
    public static final String TEST_ALL_TEST_TYPE = "UNIT";
    private static final String empty = "";
    private static final String oid1 = "HASH123";
    private static final String oid2 = "HASH123.1";
    private static final String oid3 = "HASH123.1.2";
    private static final String oidfc = "HASH123.fc";
    private static final String oidlc = "HASH123.lc";
    private static final String oidpr = "HASH123.pr";
    private static final String oidns = "HASH123.ns";
    private static final String oidps = "HASH123.ps";

    public OIDTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(OIDTest.class);
    }

    public void testGetTop() {
        OIDTest.assertEquals((String)oid1, (String)OID.getTop(oid1));
        OIDTest.assertEquals((String)oid1, (String)OID.getTop(oid2));
        OIDTest.assertEquals((String)empty, (String)OID.getTop(empty));
    }

    public void testIsTop() {
        OIDTest.assertTrue((!OID.isTop(empty) ? 1 : 0) != 0);
        OIDTest.assertTrue((boolean)OID.isTop(oid1));
        OIDTest.assertTrue((!OID.isTop(oid2) ? 1 : 0) != 0);
    }

    public void testGetParent() {
        OIDTest.assertEquals((String)oid1, (String)OID.getParent(oid1));
        OIDTest.assertEquals((String)oid1, (String)OID.getParent(oid2));
        OIDTest.assertEquals((String)empty, (String)OID.getParent(empty));
    }

    public void testTranslateParent() {
        String short_id = "\".1";
        OIDTest.assertEquals((String)oid2, (String)OID.translateParent(short_id, oid1));
        OIDTest.assertEquals((String)oid2, (String)OID.translateParent(oid2, oid1));
    }

    public void testShrinkParent() {
        String short_oid2 = "\".1";
        String short_oid3 = "\".2";
        OIDTest.assertEquals((String)oid1, (String)OID.shrinkParent(oid1));
        OIDTest.assertEquals((String)short_oid2, (String)OID.shrinkParent(oid2));
        OIDTest.assertEquals((String)short_oid3, (String)OID.shrinkParent(oid3));
    }

    public void testNeedsTranslating() {
        OIDTest.assertTrue((!OID.needsTranslating(oid1) ? 1 : 0) != 0);
        OIDTest.assertTrue((!OID.needsTranslating(oid2) ? 1 : 0) != 0);
        OIDTest.assertTrue((boolean)OID.needsTranslating(oidfc));
        OIDTest.assertTrue((boolean)OID.needsTranslating(oidlc));
        OIDTest.assertTrue((boolean)OID.needsTranslating(oidpr));
        OIDTest.assertTrue((boolean)OID.needsTranslating(oidns));
        OIDTest.assertTrue((boolean)OID.needsTranslating(oidps));
    }

    public void testStripSuffix() {
        OIDTest.assertEquals((String)oid1, (String)OID.stripSuffix(oidfc));
        OIDTest.assertEquals((String)oid1, (String)OID.stripSuffix(oidlc));
        OIDTest.assertEquals((String)oid1, (String)OID.stripSuffix(oidpr));
        OIDTest.assertEquals((String)oid1, (String)OID.stripSuffix(oidns));
        OIDTest.assertEquals((String)oid1, (String)OID.stripSuffix(oidps));
    }

    public void testIsChildOf() {
        OIDTest.assertTrue((boolean)OID.isChildOf(oid1, oid2));
        OIDTest.assertTrue((boolean)OID.isChildOf(oid1, oid3));
        OIDTest.assertTrue((boolean)OID.isChildOf(oid2, oid3));
        OIDTest.assertTrue((!OID.isChildOf(oid3, oid1) ? 1 : 0) != 0);
        OIDTest.assertTrue((!OID.isChildOf(oid1, oid1) ? 1 : 0) != 0);
    }
}

