/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.MyNodeList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GSXML {
    static Logger logger = Logger.getLogger((String)GSXML.class.getName());
    public static final String MESSAGE_ELEM = "message";
    public static final String REQUEST_ELEM = "request";
    public static final String RESPONSE_ELEM = "response";
    public static final String COLLECTION_ELEM = "collection";
    public static final String SERVICE_ELEM = "service";
    public static final String CLUSTER_ELEM = "serviceCluster";
    public static final String SITE_ELEM = "site";
    public static final String PARAM_ELEM = "param";
    public static final String PARAM_OPTION_ELEM = "option";
    public static final String CONTENT_ELEM = "content";
    public static final String RESOURCE_ELEM = "resource";
    public static final String DOCUMENT_ELEM = "document";
    public static final String METADATA_ELEM = "metadata";
    public static final String SERVICE_CLASS_ELEM = "serviceRack";
    public static final String CLASSIFIER_ELEM = "classifier";
    public static final String APPLET_ELEM = "applet";
    public static final String APPLET_DATA_ELEM = "appletData";
    public static final String CONFIGURE_ELEM = "configure";
    public static final String STATUS_ELEM = "status";
    public static final String ERROR_ELEM = "error";
    public static final String DEFAULT_ELEM = "default";
    public static final String STYLESHEET_ELEM = "format";
    public static final String FORMAT_ELEM = "format";
    public static final String TERM_ELEM = "term";
    public static final String SYSTEM_ELEM = "system";
    public static final String COLLECTION_CONFIG_ELEM = "collectionConfig";
    public static final String COLLECTION_BUILD_ELEM = "buildConfig";
    public static final String COLLECTION_INIT_ELEM = "collectionInit";
    public static final String RECOGNISE_ELEM = "recognise";
    public static final String DOC_TYPE_ELEM = "docType";
    public static final String SEARCH_ELEM = "search";
    public static final String INDEX_ELEM = "index";
    public static final String INDEX_STEM_ELEM = "indexStem";
    public static final String INDEX_OPTION_ELEM = "indexOption";
    public static final String BROWSE_ELEM = "browse";
    public static final String DISPLAY_ELEM = "display";
    public static final String LEVEL_ELEM = "level";
    public static final String DBINFO_ELEM = "dbInfo";
    public static final String DBNAME_ATT = "dbname";
    public static final String DBPATH_ATT = "dbpath";
    public static final String SQLSTATE_ATT = "sqlstate";
    public static final String DATABASE_TYPE_ELEM = "databaseType";
    public static final String SHORTNAME_ATT = "shortname";
    public static final String NOTIFY_ELEM = "notify";
    public static final String NOTIFY_HOST_ATT = "host";
    public static final String PAGE_ELEM = "page";
    public static final String CONFIGURATION_ELEM = "config";
    public static final String PAGE_REQUEST_ELEM = "pageRequest";
    public static final String PAGE_RESPONSE_ELEM = "pageResponse";
    public static final String PAGE_EXTRA_ELEM = "pageExtra";
    public static final String ACTION_ELEM = "action";
    public static final String SUBACTION_ELEM = "subaction";
    public static final String LIST_MODIFIER = "List";
    public static final String NAME_ATT = "name";
    public static final String TO_ATT = "to";
    public static final String USER_ID_ATT = "uid";
    public static final String FROM_ATT = "from";
    public static final String LANG_ATT = "lang";
    public static final String TYPE_ATT = "type";
    public static final String VALUE_ATT = "value";
    public static final String DEFAULT_ATT = "default";
    public static final String INFO_ATT = "info";
    public static final String ACTION_ATT = "action";
    public static final String SUBACTION_ATT = "subaction";
    public static final String OUTPUT_ATT = "output";
    public static final String ADDRESS_ATT = "address";
    public static final String LOCAL_SITE_ATT = "localSite";
    public static final String LOCAL_SITE_NAME_ATT = "localSiteName";
    public static final String STATUS_ERROR_CODE_ATT = "code";
    public static final String STATUS_PROCESS_ID_ATT = "pid";
    public static final String PARAM_SHORTNAME_ATT = "shortname";
    public static final String PARAM_IGNORE_POS_ATT = "ignore";
    public static final String CLASSIFIER_CONTENT_ATT = "content";
    public static final String ERROR_TYPE_ATT = "type";
    public static final String COLLECT_TYPE_ATT = "ct";
    public static final String DOC_TYPE_ATT = "docType";
    public static final String DOC_NODE_ELEM = "documentNode";
    public static final String NODE_CONTENT_ELEM = "nodeContent";
    public static final String NODE_STRUCTURE_ELEM = "nodeStructure";
    public static final String NODE_ID_ATT = "nodeID";
    public static final String NODE_NAME_ATT = "nodeName";
    public static final String NODE_TYPE_ATT = "nodeType";
    public static final String NODE_RANK_ATT = "rank";
    public static final String NODE_TYPE_ROOT = "root";
    public static final String NODE_TYPE_INTERNAL = "internal";
    public static final String NODE_TYPE_LEAF = "leaf";
    public static final String DOC_TYPE_SIMPLE = "simple";
    public static final String DOC_TYPE_PAGED = "paged";
    public static final String DOC_TYPE_HIERARCHY = "hierarchy";
    public static final String SESSION_EXPIRATION = "session_expiration";
    public static final String USER_SESSION_CACHE_ATT = "user_session_cache";
    public static final String CLASS_NODE_ELEM = "classifierNode";
    public static final String CLASS_NODE_ORIENTATION_ATT = "orientation";
    public static final String PARAM_TYPE_INTEGER = "integer";
    public static final String PARAM_TYPE_BOOLEAN = "boolean";
    public static final String PARAM_TYPE_ENUM_START = "enum";
    public static final String PARAM_TYPE_ENUM_SINGLE = "enum_single";
    public static final String PARAM_TYPE_ENUM_MULTI = "enum_multi";
    public static final String PARAM_TYPE_STRING = "string";
    public static final String PARAM_TYPE_TEXT = "text";
    public static final String PARAM_TYPE_MULTI = "multi";
    public static final String PARAM_TYPE_FILE = "file";
    public static final String PARAM_TYPE_INVISIBLE = "invisible";
    public static final String DISPLAY_TEXT_ELEM = "displayItem";
    public static final String DISPLAY_TEXT_NAME = "name";
    public static final String DISPLAY_TEXT_SUBMIT = "submit";
    public static final String DISPLAY_TEXT_DESCRIPTION = "description";
    public static final String REQUEST_TYPE_DESCRIBE = "describe";
    public static final String REQUEST_TYPE_PROCESS = "process";
    public static final String REQUEST_TYPE_STATUS = "status";
    public static final String REQUEST_TYPE_SYSTEM = "system";
    public static final String REQUEST_TYPE_PAGE = "page";
    public static final String REQUEST_TYPE_FORMAT = "format";
    public static final String REQUEST_TYPE_MESSAGING = "messaging";
    public static final String SERVICE_TYPE_QUERY = "query";
    public static final String SERVICE_TYPE_RETRIEVE = "retrieve";
    public static final String SERVICE_TYPE_BROWSE = "browse";
    public static final String SERVICE_TYPE_APPLET = "applet";
    public static final String SERVICE_TYPE_PROCESS = "process";
    public static final String SERVICE_TYPE_ENRICH = "enrich";
    public static final String SERVICE_TYPE_OAI = "oai";
    public static final String FLAX_PAGE = "flaxPage";
    public static final String FLAX_PAGE_GENERATION = "FlaxPageGeneration";
    public static final String SYSTEM_TYPE_CONFIGURE = "configure";
    public static final String SYSTEM_TYPE_ACTIVATE = "activate";
    public static final String SYSTEM_TYPE_DEACTIVATE = "deactivate";
    public static final String SYSTEM_SUBSET_ATT = "subset";
    public static final String SYSTEM_MODULE_TYPE_ATT = "moduleType";
    public static final String SYSTEM_MODULE_NAME_ATT = "moduleName";
    public static final String COMM_TYPE_SOAP_JAVA = "soap";
    public static final String ERROR_TYPE_SYNTAX = "syntax";
    public static final String ERROR_TYPE_SYSTEM = "system";
    public static final String ERROR_TYPE_INVALID_ID = "invalid_id";
    public static final String ERROR_TYPE_OTHER = "other";
    public static final String SUBSET_PARAM = "subset";
    public static final String PLUGIN_ELEM = "plugin";
    public static final String IMPORT_ELEM = "import";
    public static final String AUTHEN_NODE_ELEM = "authenticationNode";
    public static final String USER_NODE_ELEM = "userNode";
    public static int SORT_TYPE_STRING = 0;
    public static int SORT_TYPE_INT = 1;
    public static int SORT_TYPE_FLOAT = 2;

    public static String[] getAttributeValuesFromList(Element list, String att_name) {
        NodeList children = list.getChildNodes();
        int num_nodes = children.getLength();
        String[] ids = new String[num_nodes];
        for (int i = 0; i < num_nodes; ++i) {
            String id;
            Element e = (Element)children.item(i);
            ids[i] = id = e.getAttribute(att_name);
        }
        return ids;
    }

    public static HashMap extractParams(Element xml, boolean deep) {
        if (!xml.getNodeName().equals("paramList")) {
            logger.error((Object)("paramList element should have been passed to extractParams, instead it was " + xml.getNodeName()));
            return null;
        }
        NodeList params = null;
        params = deep ? xml.getElementsByTagName(PARAM_ELEM) : xml.getChildNodes();
        HashMap<String, Object> param_map = new HashMap<String, Object>();
        for (int i = 0; i < params.getLength(); ++i) {
            if (!params.item(i).getNodeName().equals(PARAM_ELEM)) continue;
            Element param = (Element)params.item(i);
            String name = param.getAttribute("name");
            String value = GSXML.getValue(param);
            int pos = name.indexOf(46);
            if (pos == -1) {
                param_map.put(name, value);
                continue;
            }
            String namespace = name.substring(0, pos);
            name = name.substring(pos + 1);
            HashMap<String, String> map = (HashMap<String, String>)param_map.get(namespace);
            if (map == null) {
                map = new HashMap<String, String>();
                param_map.put(namespace, map);
            }
            map.put(name, value);
        }
        return param_map;
    }

    public static String getValue(Element e) {
        String val = e.getAttribute(VALUE_ATT);
        val = val == null || val.equals("") ? GSXML.getNodeText(e) : GSXML.unXmlSafe(val);
        return val;
    }

    public static Node getNodeTextNode(Element param) {
        Node n;
        param.normalize();
        for (n = param.getFirstChild(); n != null && n.getNodeType() != 3; n = n.getNextSibling()) {
        }
        return n;
    }

    public static String getNodeText(Element param) {
        Node text_node = GSXML.getNodeTextNode(param);
        if (text_node == null) {
            return "";
        }
        return text_node.getNodeValue();
    }

    public static void setNodeText(Element elem, String text) {
        Node old_text_node = GSXML.getNodeTextNode(elem);
        if (old_text_node != null) {
            elem.removeChild(old_text_node);
        }
        Text t = elem.getOwnerDocument().createTextNode(text);
        elem.appendChild(t);
    }

    public static boolean addDocText(Document owner, Element doc, String text) {
        Element content = owner.createElement(NODE_CONTENT_ELEM);
        Text t = owner.createTextNode(text);
        content.appendChild(t);
        doc.appendChild(content);
        return true;
    }

    public static boolean addError(Document owner, Element doc, String text) {
        return GSXML.addError(owner, doc, text, ERROR_TYPE_OTHER);
    }

    public static boolean addError(Document owner, Element doc, String text, String error_type) {
        Element content = owner.createElement(ERROR_ELEM);
        content.setAttribute("type", error_type);
        Text t = owner.createTextNode(text);
        content.appendChild(t);
        doc.appendChild(content);
        return true;
    }

    public static boolean addError(Document owner, Element doc, Throwable error) {
        return GSXML.addError(owner, doc, error, ERROR_TYPE_OTHER);
    }

    public static boolean addError(Document owner, Element doc, Throwable error, String error_type) {
        error.printStackTrace();
        return GSXML.addError(owner, doc, error.toString(), error_type);
    }

    public static Element createMetadataParamList(Document owner, Vector meta_values) {
        Element meta_param_list = owner.createElement("paramList");
        for (String next : meta_values) {
            Element meta_param = owner.createElement(PARAM_ELEM);
            meta_param_list.appendChild(meta_param);
            meta_param.setAttribute("name", METADATA_ELEM);
            meta_param.setAttribute(VALUE_ATT, next);
        }
        return meta_param_list;
    }

    public static boolean addMetadata(Document owner, Element list, String meta_name, String meta_value) {
        if (meta_value == null || meta_value.equals("")) {
            return false;
        }
        Element data = owner.createElement(METADATA_ELEM);
        data.setAttribute("name", meta_name);
        Text t = owner.createTextNode(meta_value);
        data.appendChild(t);
        list.appendChild(data);
        return true;
    }

    public static boolean mergeMetadataLists(Node to, Node from) {
        Node to_meta = GSXML.getChildByTagName(to, "metadataList");
        Node from_meta = GSXML.getChildByTagName(from, "metadataList");
        if (from_meta == null) {
            return true;
        }
        Document to_owner = to.getOwnerDocument();
        Node new_from = to_owner.importNode(from_meta, true);
        if (to_meta == null) {
            to.appendChild(new_from);
            return true;
        }
        for (Node child = new_from.getFirstChild(); child != null; child = child.getNextSibling()) {
            to_meta.appendChild(child);
        }
        return true;
    }

    public static boolean mergeElements(Element to, Element from) {
        Document owner = to.getOwnerDocument();
        for (Node child = from.getFirstChild(); child != null; child = child.getNextSibling()) {
            to.appendChild(owner.importNode(child, true));
        }
        return true;
    }

    public static Element getFirstElementChild(Node n) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static Node getChildByTagName(Node n, String name) {
        if (n != null) {
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!child.getNodeName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    public static Node getChildByTagNameIndexed(Node n, String name, int index) {
        if (index == -1) {
            return GSXML.getChildByTagName(n, name);
        }
        int count = 0;
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            if (count == index) {
                return child;
            }
            ++count;
        }
        return null;
    }

    public static Node getNodeByPath(Node n, String path) {
        String link = GSPath.getFirstLink(path);
        path = GSPath.removeFirstLink(path);
        while (!link.equals("")) {
            if ((n = GSXML.getChildByTagName(n, link)) == null) {
                return null;
            }
            link = GSPath.getFirstLink(path);
            path = GSPath.removeFirstLink(path);
        }
        return n;
    }

    public static Node getNodeByPathIndexed(Node n, String path) {
        String link = GSPath.getFirstLink(path);
        int index = GSPath.getIndex(link);
        if (index != -1) {
            link = GSPath.removeIndex(link);
        }
        path = GSPath.removeFirstLink(path);
        while (!link.equals("")) {
            if ((n = GSXML.getChildByTagNameIndexed(n, link, index)) == null) {
                return null;
            }
            link = GSPath.getFirstLink(path);
            index = GSPath.getIndex(link);
            if (index != -1) {
                link = GSPath.removeIndex(link);
            }
            path = GSPath.removeFirstLink(path);
        }
        return n;
    }

    public static HashMap getChildrenMap(Node n) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            map.put(name, child);
        }
        return map;
    }

    public static NodeList getChildrenByTagName(Node n, String name) {
        MyNodeList node_list = new MyNodeList();
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            node_list.addNode(child);
        }
        return node_list;
    }

    public static Element duplicateWithNewName(Document owner, Element element, String element_name, boolean with_attributes) {
        return GSXML.duplicateWithNewNameNS(owner, element, element_name, null, with_attributes);
    }

    public static Element duplicateWithNewNameNS(Document owner, Element element, String element_name, String namespace_uri, boolean with_attributes) {
        int i;
        Element duplicate = namespace_uri == null ? owner.createElement(element_name) : owner.createElementNS(namespace_uri, element_name);
        if (with_attributes) {
            NamedNodeMap attributes = element.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                duplicate.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        NodeList children = element.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            duplicate.appendChild(owner.importNode(child, true));
        }
        return duplicate;
    }

    public static void copyAllChildren(Element to, Element from) {
        Document to_doc = to.getOwnerDocument();
        for (Node child = from.getFirstChild(); child != null; child = child.getNextSibling()) {
            to.appendChild(to_doc.importNode(child, true));
        }
    }

    public static Element createBasicRequest(Document owner, String request_type, String to, String lang, String uid) {
        Element request = owner.createElement(REQUEST_ELEM);
        request.setAttribute("type", request_type);
        request.setAttribute(LANG_ATT, lang);
        request.setAttribute(TO_ATT, to);
        request.setAttribute(USER_ID_ATT, uid);
        return request;
    }

    public static Element createTextElement(Document owner, String elem_name, String text) {
        Element e = owner.createElement(elem_name);
        Text t = owner.createTextNode(text);
        e.appendChild(t);
        return e;
    }

    public static Element createDisplayTextElement(Document owner, String text_name, String text) {
        Element e = owner.createElement(DISPLAY_TEXT_ELEM);
        e.setAttribute("name", text_name);
        Text t = owner.createTextNode(text);
        e.appendChild(t);
        return e;
    }

    public static Element createParameter(Document owner, String name, String value) {
        Element param = owner.createElement(PARAM_ELEM);
        param.setAttribute("name", name);
        param.setAttribute(VALUE_ATT, value);
        return param;
    }

    public static void addParametersToList(Document owner, Element param_list, HashMap params) {
        Set items = params.entrySet();
        for (Map.Entry m : items) {
            param_list.appendChild(GSXML.createParameter(owner, (String)m.getKey(), (String)m.getValue()));
        }
    }

    public static Element createParameterDescription(Document owner, String id, String display_name, String type, String default_value, String[] option_ids, String[] option_names) {
        Element p = owner.createElement(PARAM_ELEM);
        p.setAttribute("name", id);
        p.setAttribute("type", type);
        p.appendChild(GSXML.createDisplayTextElement(owner, "name", display_name));
        if (default_value != null) {
            p.setAttribute("default", default_value);
        }
        if (option_ids != null && option_names != null) {
            for (int i = 0; i < option_ids.length; ++i) {
                Element e = owner.createElement(PARAM_OPTION_ELEM);
                e.setAttribute("name", option_ids[i]);
                e.appendChild(GSXML.createDisplayTextElement(owner, "name", option_names[i]));
                p.appendChild(e);
            }
        }
        return p;
    }

    public static Element createParameterDescription2(Document owner, String id, String display_name, String type, String default_value, ArrayList option_ids, ArrayList option_names) {
        Element p = owner.createElement(PARAM_ELEM);
        p.setAttribute("name", id);
        p.setAttribute("type", type);
        p.appendChild(GSXML.createDisplayTextElement(owner, "name", display_name));
        if (default_value != null) {
            p.setAttribute("default", default_value);
        }
        if (option_ids != null && option_names != null) {
            for (int i = 0; i < option_ids.size(); ++i) {
                Element e = owner.createElement(PARAM_OPTION_ELEM);
                e.setAttribute("name", (String)option_ids.get(i));
                e.appendChild(GSXML.createDisplayTextElement(owner, "name", (String)option_names.get(i)));
                p.appendChild(e);
            }
        }
        return p;
    }

    public static Element getNamedElement(Element parent, String node_name, String attribute_name, String attribute_value) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(node_name) || !((Element)child).getAttribute(attribute_name).equals(attribute_value)) continue;
            return (Element)child;
        }
        return null;
    }

    public static NodeList getNamedElements(Element ancestor, String node_name, String attribute_name, String attribute_value) {
        MyNodeList node_list = new MyNodeList();
        NodeList children = ancestor.getElementsByTagName(node_name);
        if (children != null && children.getLength() > 0) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals(node_name) || !((Element)child).getAttribute(attribute_name).equals(attribute_value)) continue;
                node_list.addNode(child);
            }
        }
        return node_list;
    }

    public static Element insertIntoOrderedList(Element parent_node, String node_name, Element start_from_elem, Element new_elem, String sort_att, boolean descending) {
        if (new_elem == null) {
            return null;
        }
        Element cloned_elem = (Element)parent_node.getOwnerDocument().importNode(new_elem, true);
        if (start_from_elem == null) {
            parent_node.appendChild(cloned_elem);
            return cloned_elem;
        }
        Node current_node = start_from_elem;
        String insert_att = cloned_elem.getAttribute(sort_att);
        String list_att = start_from_elem.getAttribute(sort_att);
        while ((!descending && list_att.compareTo(insert_att) < 0 || descending && list_att.compareTo(insert_att) > 0) && (current_node = current_node.getNextSibling()) != null) {
            if (!current_node.getNodeName().equals(node_name)) continue;
            list_att = ((Element)current_node).getAttribute(sort_att);
        }
        parent_node.insertBefore(cloned_elem, current_node);
        return cloned_elem;
    }

    public static String getDisplayText(Element display, String name, String lang, String lang_default) {
        String def = null;
        String first = null;
        NodeList elems = display.getElementsByTagName(DISPLAY_TEXT_ELEM);
        if (elems.getLength() == 0) {
            return "";
        }
        for (int i = 0; i < elems.getLength(); ++i) {
            Element e = (Element)elems.item(i);
            String n = e.getAttribute("name");
            if (!name.equals(n)) continue;
            String l = e.getAttribute(LANG_ATT);
            if (lang.equals(l)) {
                return GSXML.getNodeText(e);
            }
            if (lang_default.equals(l)) {
                def = GSXML.getNodeText(e);
                continue;
            }
            if (first != null) continue;
            first = GSXML.getNodeText(e);
        }
        if (def != null) {
            return def;
        }
        if (first != null) {
            return first;
        }
        return "";
    }

    public static String xmlSafe(String original) {
        StringBuffer filtered = new StringBuffer(original.length());
        for (int i = 0; i < original.length(); ++i) {
            char c = original.charAt(i);
            if (c == '>') {
                filtered.append("&gt;");
                continue;
            }
            if (c == '<') {
                filtered.append("&lt;");
                continue;
            }
            if (c == '\"') {
                filtered.append("&quot;");
                continue;
            }
            if (c == '&') {
                filtered.append("&amp;");
                continue;
            }
            if (c == '\'') {
                filtered.append("&apos;");
                continue;
            }
            filtered.append(c);
        }
        return filtered.toString();
    }

    public static String unXmlSafe(String original) {
        StringBuffer filtered = new StringBuffer(original.length());
        for (int i = 0; i < original.length(); ++i) {
            char c = original.charAt(i);
            if (c == '&') {
                int pos = original.indexOf(";", i);
                String entity = original.substring(i + 1, pos);
                if (entity.equals("gt")) {
                    filtered.append(">");
                } else if (entity.equals("lt")) {
                    filtered.append("<");
                } else if (entity.equals("apos")) {
                    filtered.append("'");
                } else if (entity.equals("amp")) {
                    filtered.append("&");
                } else if (entity.equals("quot")) {
                    filtered.append("\"");
                } else {
                    filtered.append("&" + entity + ";");
                }
                i = pos;
                continue;
            }
            filtered.append(c);
        }
        return filtered.toString();
    }

    public static void printXMLNode(Node e) {
        GSXML.printXMLNode(e, 0);
    }

    public static String xmlNodeToString(Node e) {
        StringBuffer sb = new StringBuffer("");
        GSXML.xmlNodeToString(sb, e, 0);
        return sb.toString();
    }

    private static void xmlNodeToString(StringBuffer sb, Node e, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append(' ');
        }
        if (e.getNodeType() == 3) {
            sb.append(PARAM_TYPE_TEXT);
            return;
        }
        sb.append('<');
        sb.append(e.getNodeName());
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            sb.append(' ');
            sb.append(attr.getNodeName());
            sb.append("=\"");
            sb.append(attr.getNodeValue());
            sb.append('\"');
        }
        NodeList children = e.getChildNodes();
        if (children == null || children.getLength() == 0) {
            sb.append("/>\n");
        } else {
            int i;
            sb.append(">\n");
            int len = children.getLength();
            for (i = 0; i < len; ++i) {
                GSXML.xmlNodeToString(sb, children.item(i), depth + 1);
            }
            for (i = 0; i < depth; ++i) {
                sb.append(' ');
            }
            sb.append("</" + e.getNodeName() + ">\n");
        }
    }

    public static void printXMLNode(Node e, int depth) {
        for (int i = 0; i < depth; ++i) {
            System.out.print(' ');
        }
        if (e.getNodeType() == 3) {
            System.out.println(PARAM_TYPE_TEXT);
            return;
        }
        System.out.print('<');
        System.out.print(e.getNodeName());
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            System.out.print(' ');
            System.out.print(attr.getNodeName());
            System.out.print("=\"");
            System.out.print(attr.getNodeValue());
            System.out.print('\"');
        }
        NodeList children = e.getChildNodes();
        if (children == null || children.getLength() == 0) {
            System.out.println("/>");
        } else {
            int i;
            System.out.println('>');
            int len = children.getLength();
            for (i = 0; i < len; ++i) {
                GSXML.printXMLNode(children.item(i), depth + 1);
            }
            for (i = 0; i < depth; ++i) {
                System.out.print(' ');
            }
            System.out.println("</" + e.getNodeName() + ">");
        }
    }
}

