/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.DBInfo;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.OAIXML;
import org.greenstone.gsdl3.util.SimpleCollectionDatabase;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OAIPMH
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)OAIPMH.class.getName());
    protected SimpleCollectionDatabase coll_db = null;
    protected String site_name = "";
    protected String coll_name = "";
    protected Element coll_config_xml = null;

    public void cleanUp() {
        super.cleanUp();
        this.coll_db.closeDatabase();
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            logger.info((Object)"Configuring ServiceRack.java returns false.");
            return false;
        }
        this.site_name = this.router.getSiteName();
        this.coll_name = this.cluster_name;
        this.coll_config_xml = OAIXML.getCollectionConfigXML(this.site_name, this.coll_name);
        logger.info((Object)"Configuring OAIPMH...");
        this.config_info = info;
        Element index_stem_elem = (Element)GSXML.getChildByTagName(info, "indexStem");
        String index_stem = null;
        if (index_stem_elem != null) {
            index_stem = index_stem_elem.getAttribute("name");
        }
        if (index_stem == null || index_stem.equals("")) {
            index_stem = this.cluster_name;
        }
        Element database_type_elem = (Element)GSXML.getChildByTagName(info, "databaseType");
        String database_type = null;
        if (database_type_elem != null) {
            database_type = database_type_elem.getAttribute("name");
        }
        if (database_type == null || database_type.equals("")) {
            database_type = "gdbm";
        }
        this.coll_db = new SimpleCollectionDatabase(database_type);
        if (this.coll_db == null) {
            logger.error((Object)("Couldn't create the collection database of type " + database_type));
            return false;
        }
        String coll_db_file = GSFile.collectionDatabaseFile(this.site_home, this.cluster_name, index_stem, database_type);
        if (!this.coll_db.openDatabase(coll_db_file, 0)) {
            logger.error((Object)"Could not open collection database!");
            return false;
        }
        Element identify = this.doc.createElement("service");
        identify.setAttribute("name", "Identify");
        identify.setAttribute("type", "oai");
        this.short_service_info.appendChild(identify);
        Element list_records = this.doc.createElement("service");
        list_records.setAttribute("name", "ListRecords");
        list_records.setAttribute("type", "oai");
        this.short_service_info.appendChild(list_records);
        Element list_identifiers = this.doc.createElement("service");
        list_identifiers.setAttribute("name", "ListIdentifiers");
        list_identifiers.setAttribute("type", "oai");
        this.short_service_info.appendChild(list_identifiers);
        Element list_sets = this.doc.createElement("service");
        list_sets.setAttribute("name", "ListSets");
        list_sets.setAttribute("type", "oai");
        this.short_service_info.appendChild(list_sets);
        Element list_metadata_formats = this.doc.createElement("service");
        list_metadata_formats.setAttribute("name", "ListMetadataFormats");
        list_metadata_formats.setAttribute("type", "oai");
        this.short_service_info.appendChild(list_metadata_formats);
        Element get_record = this.doc.createElement("service");
        get_record.setAttribute("name", "GetRecord");
        get_record.setAttribute("type", "oai");
        this.short_service_info.appendChild(get_record);
        return true;
    }

    public Element getServiceDescription(String service_id, String lang, String subset) {
        if (service_id.equals("Identify")) {
            Element identify = this.doc.createElement("service");
            identify.setAttribute("name", "Identify");
            identify.setAttribute("type", "oai");
            return identify;
        }
        if (service_id.equals("ListRecords")) {
            Element list_records = this.doc.createElement("service");
            list_records.setAttribute("name", "ListRecords");
            list_records.setAttribute("type", "oai");
            return list_records;
        }
        if (service_id.equals("ListIdentifiers")) {
            Element list_identifiers = this.doc.createElement("service");
            list_identifiers.setAttribute("name", "ListIdentifiers");
            list_identifiers.setAttribute("type", "oai");
            return list_identifiers;
        }
        if (service_id.equals("ListSets")) {
            Element list_sets = this.doc.createElement("service");
            list_sets.setAttribute("name", "ListSets");
            list_sets.setAttribute("type", "oai");
            return list_sets;
        }
        if (service_id.equals("ListMetadataFormats")) {
            Element list_metadata_formats = this.doc.createElement("service");
            list_metadata_formats.setAttribute("name", "ListMetadataFormats");
            list_metadata_formats.setAttribute("type", "oai");
            return list_metadata_formats;
        }
        if (service_id.equals("GetRecord")) {
            Element get_record = this.doc.createElement("service");
            get_record.setAttribute("name", "GetRecord");
            get_record.setAttribute("type", "oai");
            return get_record;
        }
        return null;
    }

    protected Element processIdentify(Element req) {
        return null;
    }

    protected Element processListSets(Element req) {
        return null;
    }

    protected Element processGetRecord(Element req) {
        NodeList params = GSXML.getChildrenByTagName(req, "param");
        HashMap param_map = OAIXML.getParamMap(params);
        String prefix = (String)param_map.get("metadataPrefix");
        if (prefix == null || prefix.equals("")) {
            logger.error((Object)"the value of metadataPrefix att is not present in the request.");
            return OAIXML.getResponse(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        Element metadata_format = this.getMetadataFormatElement(prefix);
        if (metadata_format == null) {
            logger.error((Object)"metadata prefix is not supported.");
            return OAIXML.getResponse(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        String oid = (String)param_map.get("OID");
        DBInfo info = this.coll_db.getInfo(oid);
        if (info == null) {
            logger.error((Object)("OID: " + oid + " is not present in the database."));
            return OAIXML.getResponse(OAIXML.createErrorElement("idDoesNotExist", ""));
        }
        ArrayList keys = new ArrayList(info.getKeys());
        String lastmodified = "";
        if (keys.contains("lastmodified")) {
            lastmodified = info.getInfo("lastmodified");
        }
        lastmodified = OAIXML.getTime(Long.parseLong(lastmodified));
        Element get_record = OAIXML.createElement("GetRecord");
        Element record = OAIXML.createElement("record");
        record.appendChild(this.createHeaderElement(oid, lastmodified));
        record.appendChild(this.createMetadataElement(prefix, info, metadata_format));
        get_record.appendChild(record);
        return OAIXML.getResponse(get_record);
    }

    protected Element processListIdentifiers(Element req) {
        Element metadata_format;
        NodeList params = GSXML.getChildrenByTagName(req, "param");
        if (params.getLength() == 0) {
            logger.error((Object)"must at least have the metadataPrefix parameter, can't be none");
            return OAIXML.getResponse(OAIXML.createErrorElement("badArgument", ""));
        }
        HashMap param_map = OAIXML.getParamMap(params);
        String prefix = "";
        Date from_date = null;
        Date until_date = null;
        if (!param_map.containsKey("metadataPrefix")) {
            logger.error((Object)"A param element containing the metadataPrefix is not present.");
            return OAIXML.getResponse(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        prefix = (String)param_map.get("metadataPrefix");
        if (prefix == null || prefix.equals("")) {
            logger.error((Object)"the value of metadataPrefix att is not present in the request.");
            return OAIXML.getResponse(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        if (param_map.containsKey("from")) {
            String from = (String)param_map.get("from");
            from_date = OAIXML.getDate(from);
        }
        if (param_map.containsKey("until")) {
            String until = (String)param_map.get("until");
            until_date = OAIXML.getDate(until);
        }
        if ((metadata_format = this.getMetadataFormatElement(prefix)) == null) {
            logger.error((Object)"metadata prefix is not supported.");
            return OAIXML.getResponse(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        ArrayList oid_list = this.getChildrenIds("browselist");
        if (oid_list == null) {
            logger.error((Object)"No matched records found in collection: browselist is empty");
            return OAIXML.getResponse(OAIXML.createErrorElement("noRecordsMatch", ""));
        }
        Element list_identifiers = OAIXML.createElement("ListIdentifiers");
        for (int i = 0; i < oid_list.size(); ++i) {
            String oid = (String)oid_list.get(i);
            DBInfo info = this.coll_db.getInfo(oid);
            if (info == null) {
                logger.error((Object)("Database does not contains information about oid: " + oid));
                continue;
            }
            ArrayList keys = new ArrayList(info.getKeys());
            String lastmodified = "";
            if (keys.contains("lastmodified")) {
                lastmodified = info.getInfo("lastmodified");
            }
            lastmodified = OAIXML.getTime(Long.parseLong(lastmodified));
            Date this_date = OAIXML.getDate(lastmodified);
            if (from_date != null && this_date.before(from_date) || until_date != null && this_date.after(until_date)) continue;
            list_identifiers.appendChild(this.createHeaderElement(oid, lastmodified));
        }
        return OAIXML.getResponse(list_identifiers);
    }

    protected Element processListRecords(Element req) {
        Element metadata_format;
        NodeList params = GSXML.getChildrenByTagName(req, "param");
        if (params.getLength() == 0) {
            logger.error((Object)"must at least have the metadataPrefix parameter, can't be none");
            return OAIXML.getResponse(OAIXML.createErrorElement("badArgument", ""));
        }
        HashMap param_map = OAIXML.getParamMap(params);
        String prefix = "";
        Date from_date = null;
        Date until_date = null;
        if (!param_map.containsKey("metadataPrefix")) {
            logger.error((Object)"A param element containing the metadataPrefix is not present.");
            return OAIXML.getResponse(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        prefix = (String)param_map.get("metadataPrefix");
        if (prefix == null || prefix.equals("")) {
            logger.error((Object)"the value of metadataPrefix att is not present in the request.");
            return OAIXML.getResponse(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        if (param_map.containsKey("from")) {
            String from = (String)param_map.get("from");
            from_date = OAIXML.getDate(from);
        }
        if (param_map.containsKey("until")) {
            String until = (String)param_map.get("until");
            until_date = OAIXML.getDate(until);
        }
        if ((metadata_format = this.getMetadataFormatElement(prefix)) == null) {
            logger.error((Object)"metadata prefix is not supported.");
            return OAIXML.getResponse(OAIXML.createErrorElement("cannotDisseminateFormat", ""));
        }
        ArrayList oid_list = this.getChildrenIds("browselist");
        if (oid_list == null) {
            logger.error((Object)"No matched records found in collection: browselist is empty");
            return OAIXML.getResponse(OAIXML.createErrorElement("noRecordsMatch", ""));
        }
        Element list_records = OAIXML.createElement("ListRecords");
        for (int i = 0; i < oid_list.size(); ++i) {
            String oid = (String)oid_list.get(i);
            DBInfo info = this.coll_db.getInfo(oid);
            if (info == null) {
                logger.error((Object)("Database does not contains information about oid: " + oid));
                continue;
            }
            ArrayList keys = new ArrayList(info.getKeys());
            String lastmodified = "";
            if (keys.contains("lastmodified")) {
                lastmodified = info.getInfo("lastmodified");
            }
            lastmodified = OAIXML.getTime(Long.parseLong(lastmodified));
            Date this_date = OAIXML.getDate(lastmodified);
            if (from_date != null && this_date.before(from_date) || until_date != null && this_date.after(until_date)) continue;
            Element record = OAIXML.createElement("record");
            list_records.appendChild(record);
            record.appendChild(this.createHeaderElement(oid, lastmodified));
            record.appendChild(this.createMetadataElement(prefix, info, metadata_format));
        }
        return OAIXML.getResponse(list_records);
    }

    private Element getMetadataFormatElement(String prefix) {
        Element oai = (Element)GSXML.getChildByTagName(this.coll_config_xml, "OAI");
        Element list_meta_format = (Element)GSXML.getChildByTagName(oai, "ListMetadataFormats");
        Element metadata_format = GSXML.getNamedElement(list_meta_format, "metadataFormat", "metadataPrefix", prefix);
        return metadata_format;
    }

    private Element createMetadataElement(String prefix, DBInfo info, Element metadata_format) {
        String prfx_str = "";
        String meta_ns = "";
        if (prefix.equals("oai_dc")) {
            prfx_str = OAIXML.oai_version.equals("2.0") ? prefix + ":" + "dc" : "dc";
            meta_ns = "dc";
        } else {
            meta_ns = prfx_str = prefix.substring(prefix.indexOf("_") + 1);
        }
        Element prfx_str_elem = OAIXML.getMetadataPrefixElement(prfx_str, OAIXML.oai_version);
        String[] metadata_names = this.getMetadataNames(metadata_format);
        HashMap meta_map = this.getInfoByNames(info, metadata_names);
        ArrayList meta_list = new ArrayList(meta_map.entrySet());
        for (int j = 0; j < meta_list.size(); ++j) {
            Map.Entry men = meta_list.get(j);
            String meta_name = (String)men.getKey();
            String meta_value = (String)men.getValue();
            Element e = OAIXML.createElement(meta_name);
            GSXML.setNodeText(e, meta_value);
            prfx_str_elem.appendChild(e);
        }
        Element metadata = OAIXML.createElement("metadata");
        metadata.appendChild(prfx_str_elem);
        return metadata;
    }

    private Element createHeaderElement(String oid, String lastmodified) {
        Element header = OAIXML.createElement("header");
        Element identifier = OAIXML.createElement("identifier");
        GSXML.setNodeText(identifier, this.site_name + ":" + this.coll_name + ":" + oid);
        header.appendChild(identifier);
        Element set_spec = OAIXML.createElement("setSpec");
        GSXML.setNodeText(set_spec, this.site_name + ":" + this.coll_name);
        header.appendChild(set_spec);
        Element datestamp = OAIXML.createElement("datestamp");
        GSXML.setNodeText(datestamp, lastmodified);
        header.appendChild(datestamp);
        return header;
    }

    protected Element processListMetadataFormats(Element req) {
        Element param = GSXML.getNamedElement(req, "param", "name", "OID");
        if (param == null) {
            logger.error((Object)"An element containing the OID attribute not is present.");
            return OAIXML.getResponse(OAIXML.createErrorElement("idDoesNotExist", ""));
        }
        String oid = param.getAttribute("value");
        if (oid == null || oid.equals("")) {
            logger.error((Object)"No OID is present in the request.");
            return OAIXML.getResponse(OAIXML.createErrorElement("idDoesNotExist", ""));
        }
        ArrayList oid_list = this.getChildrenIds("browselist");
        if (oid_list == null || !oid_list.contains(oid)) {
            logger.error((Object)("OID: " + oid + " is not present in the database."));
            Element e = OAIXML.getResponse(OAIXML.createErrorElement("idDoesNotExist", ""));
            return e;
        }
        DBInfo info = null;
        info = this.coll_db.getInfo(oid);
        if (info == null) {
            return OAIXML.getResponse(OAIXML.createErrorElement("OAI service unavailable", ""));
        }
        NodeList meta_list = this.getMetadataFormatList(this.coll_config_xml);
        if (meta_list == null || meta_list.getLength() == 0) {
            logger.error((Object)"No metadata format is present in collectionConfig.xml");
            return OAIXML.getResponse(OAIXML.createErrorElement("noMetadataFormats", ""));
        }
        Element list_metadata_formats = OAIXML.createElement("ListMetadataFormats");
        boolean has_meta_format = false;
        for (int i = 0; i < meta_list.getLength(); ++i) {
            Element metadata_format = (Element)meta_list.item(i);
            String[] metadata_names = this.getMetadataNames(metadata_format);
            if (!this.containsMetadata(info, metadata_names)) continue;
            has_meta_format = true;
            Element meta_fmt = OAIXML.createElement("metadataFormat");
            OAIXML.copyElement(meta_fmt, metadata_format, "metadataPrefix");
            OAIXML.copyElement(meta_fmt, metadata_format, "metadataNamespace");
            OAIXML.copyElement(meta_fmt, metadata_format, "schema");
            list_metadata_formats.appendChild(meta_fmt);
        }
        if (!has_meta_format) {
            logger.error((Object)"Specified metadata names are not contained in the database.");
            return OAIXML.getResponse(OAIXML.createErrorElement("noMetadataFormats", ""));
        }
        return OAIXML.getResponse(list_metadata_formats);
    }

    protected NodeList getMetadataFormatList(Element coll_config_xml) {
        Element oai_elem = (Element)GSXML.getChildByTagName(coll_config_xml, "OAI");
        Element list_meta_formats = (Element)GSXML.getChildByTagName(oai_elem, "ListMetadataFormats");
        return GSXML.getChildrenByTagName(list_meta_formats, "metadataFormat");
    }

    protected String[] getMetadataNames(Element metadata_format) {
        String[] names = null;
        Element mapping_list = (Element)GSXML.getChildByTagName(metadata_format, "mappingList");
        if (mapping_list == null) {
            logger.info((Object)"No metadata mappings are provided in collectionConfig.xml. Use the standard Dublin Core names.");
            names = OAIXML.getGlobalMetadataMapping(metadata_format.getAttribute("metadataPrefix"));
            return names != null ? names : OAIXML.getDublinCoreNames();
        }
        NodeList mappings = GSXML.getChildrenByTagName(mapping_list, "mapping");
        int size = mappings.getLength();
        if (size == 0) {
            logger.info((Object)"No metadata mappings are provided in collectionConfig.xml. \n Return standard DC names.");
            return OAIXML.getDublinCoreNames();
        }
        names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = GSXML.getNodeText((Element)mappings.item(i)).trim();
        }
        return names;
    }

    protected ArrayList getChildrenIds(String node_id) {
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return null;
        }
        String contains = info.getInfo("contains");
        if (contains.equals("")) {
            return null;
        }
        ArrayList<String> children = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(contains, ";");
        while (st.hasMoreTokens()) {
            String child_id = st.nextToken().replaceAll("\"", node_id);
            children.add(child_id);
        }
        return children;
    }

    protected boolean containsMetadata(DBInfo info, String[] metadata_names) {
        if (metadata_names == null) {
            return false;
        }
        logger.info((Object)"checking metadata names in db.");
        for (int i = 0; i < metadata_names.length; ++i) {
            String meta_name;
            int index = metadata_names[i].indexOf(",");
            String string = meta_name = index == -1 ? metadata_names[i] : metadata_names[i].substring(index + 1);
            if (info.getInfo(meta_name).equals("")) continue;
            return true;
        }
        return false;
    }

    public String[] getMetadata(DBInfo info, String names) {
        String[] name_value = new String[2];
        ArrayList keys = new ArrayList(info.getKeys());
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String first_name = "";
            String second_name = "";
            int index = names.indexOf(",");
            if (index != -1) {
                first_name = names.substring(0, index);
                second_name = names.substring(index + 1);
            } else {
                first_name = second_name = names;
            }
            if (!key.equals(second_name)) continue;
            String meta_value = info.getInfo(key);
            name_value[0] = first_name;
            name_value[1] = meta_value;
            return name_value;
        }
        return null;
    }

    protected HashMap getInfoByNames(DBInfo info, String[] metadata_names) {
        HashMap<String, String> map = new HashMap<String, String>();
        boolean empty_map = true;
        for (int i = 0; i < metadata_names.length; ++i) {
            String[] name_value = this.getMetadata(info, metadata_names[i]);
            if (name_value == null) continue;
            map.put(name_value[0], name_value[1]);
            empty_map = false;
        }
        return empty_map ? null : map;
    }
}

