/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.AbstractGS2Search;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractGS2FieldSearch
extends AbstractGS2Search {
    protected static final String FIELD_QUERY_SERVICE = "FieldQuery";
    protected static final String ADVANCED_FIELD_QUERY_SERVICE = "AdvancedFieldQuery";
    protected static final String LEVEL_PARAM = "level";
    protected static final String RANK_PARAM = "sortBy";
    protected static final String RANK_PARAM_RANK = "1";
    protected static final String RANK_PARAM_NONE = "0";
    protected static final String SIMPLE_FIELD_PARAM = "simpleField";
    protected static final String ADVANCED_FIELD_PARAM = "complexField";
    protected static final String FIELD_QUERY_PARAM = "fqv";
    protected static final String FIELD_STEM_PARAM = "fqs";
    protected static final String FIELD_CASE_PARAM = "fqc";
    protected static final String FIELD_ACCENT_PARAM = "fqa";
    protected static final String FIELD_FIELD_PARAM = "fqf";
    protected static final String FIELD_COMBINE_PARAM = "fqk";
    protected static final String FIELD_COMBINE_PARAM_AND = "0";
    protected static final String FIELD_COMBINE_PARAM_OR = "1";
    protected static final String FIELD_COMBINE_PARAM_NOT = "2";
    protected static final String SEARCH_TYPE_ELEM = "searchType";
    protected static final String SEARCH_TYPE_PLAIN = "plain";
    protected static final String SEARCH_TYPE_FORM = "form";
    protected static final String SEARCH_TYPE_FORM_SIMPLE = "simple";
    protected static final String SEARCH_TYPE_FORM_ADVANCED = "advanced";
    protected static final String DEFAULT_LEVEL_ELEM = "defaultLevel";
    protected static final String DEFAULT_DB_LEVEL_ELEM = "defaultDBLevel";
    protected static final String LEVEL_ELEM = "level";
    protected static final String FIELD_ATT = "field";
    protected static final int TEXT_QUERY = 0;
    protected static final int SIMPLE_QUERY = 1;
    protected static final int ADVANCED_QUERY = 2;
    protected String AND_OPERATOR = "&";
    protected String OR_OPERATOR = "|";
    protected String NOT_OPERATOR = "!";
    protected String default_level = null;
    protected String default_db_level = null;
    protected boolean plain_search = false;
    protected boolean simple_form_search = false;
    protected boolean advanced_form_search = false;
    static Logger logger = Logger.getLogger((String)AbstractGS2FieldSearch.class.getName());

    public void cleanUp() {
        super.cleanUp();
    }

    public boolean configure(Element info, Element extra_info) {
        Element def;
        if (!super.configure(info, extra_info)) {
            return false;
        }
        Element search_type_list = (Element)GSXML.getChildByTagName(info, "searchTypeList");
        if (search_type_list == null) {
            this.plain_search = true;
            this.simple_form_search = true;
            this.advanced_form_search = true;
        } else {
            NodeList types = search_type_list.getElementsByTagName(SEARCH_TYPE_ELEM);
            for (int i = 0; i < types.getLength(); ++i) {
                Element t = (Element)types.item(i);
                String type_name = t.getAttribute("name");
                if (type_name.equals(SEARCH_TYPE_PLAIN)) {
                    this.plain_search = true;
                    continue;
                }
                if (!type_name.equals(SEARCH_TYPE_FORM)) continue;
                String type_type = t.getAttribute("type");
                if (type_type.equals("")) {
                    this.simple_form_search = true;
                    this.advanced_form_search = true;
                    continue;
                }
                if (type_type.equals(SEARCH_TYPE_FORM_SIMPLE)) {
                    this.simple_form_search = true;
                    continue;
                }
                if (!type_type.equals(SEARCH_TYPE_FORM_ADVANCED)) continue;
                this.advanced_form_search = true;
            }
        }
        if (!this.plain_search) {
            Element tq_service = GSXML.getNamedElement(this.short_service_info, "service", "name", "TextQuery");
            this.short_service_info.removeChild(tq_service);
        }
        if ((def = (Element)GSXML.getChildByTagName(info, DEFAULT_LEVEL_ELEM)) != null) {
            this.default_level = def.getAttribute("shortname");
        }
        if (this.default_level == null || this.default_level.equals("")) {
            logger.error((Object)"default level not specified!, assuming Doc");
            this.default_level = "Doc";
        }
        if ((def = (Element)GSXML.getChildByTagName(info, DEFAULT_DB_LEVEL_ELEM)) != null) {
            this.default_db_level = def.getAttribute("shortname");
        }
        if (this.default_db_level == null || this.default_db_level.equals("")) {
            logger.error((Object)"default database level (defaultDBLevel) not specified!, assuming Sec");
            this.default_db_level = "Sec";
        }
        if (extra_info != null) {
            Document owner = info.getOwnerDocument();
            NodeList levels = info.getElementsByTagName("level");
            Element config_search = (Element)GSXML.getChildByTagName(extra_info, "search");
            for (int i = 0; i < levels.getLength(); ++i) {
                Element lev = (Element)levels.item(i);
                String name = lev.getAttribute("name");
                Element node_extra = GSXML.getNamedElement(config_search, "level", "name", name);
                if (node_extra == null) {
                    logger.error((Object)("haven't found extra info for level named " + name));
                    continue;
                }
                NodeList display_names = node_extra.getElementsByTagName("displayItem");
                if (display_names == null) continue;
                for (int j = 0; j < display_names.getLength(); ++j) {
                    Element e = (Element)display_names.item(j);
                    lev.appendChild(owner.importNode(e, true));
                }
            }
        }
        Element format_info = (Element)this.format_info_map.get("TextQuery");
        if (this.simple_form_search) {
            Element fq_service = this.doc.createElement("service");
            fq_service.setAttribute("type", "query");
            fq_service.setAttribute("name", FIELD_QUERY_SERVICE);
            this.short_service_info.appendChild(fq_service);
            if (format_info != null) {
                this.format_info_map.put(FIELD_QUERY_SERVICE, format_info);
            }
        }
        if (this.advanced_form_search) {
            Element afq_service = this.doc.createElement("service");
            afq_service.setAttribute("type", "query");
            afq_service.setAttribute("name", ADVANCED_FIELD_QUERY_SERVICE);
            this.short_service_info.appendChild(afq_service);
            if (format_info != null) {
                this.format_info_map.put(ADVANCED_FIELD_QUERY_SERVICE, format_info);
            }
        }
        return true;
    }

    protected Element getServiceDescription(String service_id, String lang, String subset) {
        if (!service_id.equals(FIELD_QUERY_SERVICE) && !service_id.equals(ADVANCED_FIELD_QUERY_SERVICE)) {
            return super.getServiceDescription(service_id, lang, subset);
        }
        Element service = this.doc.createElement("service");
        service.setAttribute("type", "query");
        service.setAttribute("name", service_id);
        if (subset == null || subset.equals("displayItemList")) {
            service.appendChild(GSXML.createDisplayTextElement(this.doc, "name", this.getTextString(service_id + ".name", lang)));
            service.appendChild(GSXML.createDisplayTextElement(this.doc, "submit", this.getTextString(service_id + ".submit", lang)));
            service.appendChild(GSXML.createDisplayTextElement(this.doc, "description", this.getTextString(service_id + ".description", lang)));
        }
        if (subset == null || subset.equals("paramList")) {
            Element param_list = this.doc.createElement("paramList");
            service.appendChild(param_list);
            if (service_id.equals(FIELD_QUERY_SERVICE)) {
                this.addCustomQueryParams(param_list, lang);
                this.createParameter("maxDocs", param_list, lang);
                if (!this.default_index_subcollection.equals("")) {
                    this.createParameter("indexSubcollection", param_list, lang);
                }
                if (!this.default_index_language.equals("")) {
                    this.createParameter("indexLanguage", param_list, lang);
                }
                Element multiparam = null;
                Object param = null;
                multiparam = GSXML.createParameterDescription(this.doc, SIMPLE_FIELD_PARAM, "", "multi", null, null, null);
                multiparam.setAttribute("occurs", "4");
                param_list.appendChild(multiparam);
                this.createParameter(FIELD_QUERY_PARAM, multiparam, lang);
                this.createParameter(FIELD_FIELD_PARAM, multiparam, lang);
            } else {
                this.createParameter("level", param_list, lang);
                this.createParameter(RANK_PARAM, param_list, lang);
                this.createParameter("maxDocs", param_list, lang);
                if (!this.default_index_subcollection.equals("")) {
                    this.createParameter("indexSubcollection", param_list, lang);
                }
                if (!this.default_index_language.equals("")) {
                    this.createParameter("indexLanguage", param_list, lang);
                }
                Element multiparam = null;
                Object param = null;
                multiparam = GSXML.createParameterDescription(this.doc, ADVANCED_FIELD_PARAM, "", "multi", null, null, null);
                multiparam.setAttribute("occurs", "4");
                param_list.appendChild(multiparam);
                this.createParameter(FIELD_COMBINE_PARAM, multiparam, lang);
                this.createParameter(FIELD_QUERY_PARAM, multiparam, lang);
                if (this.does_case) {
                    this.createParameter(FIELD_CASE_PARAM, multiparam, lang);
                }
                if (this.does_stem) {
                    this.createParameter(FIELD_STEM_PARAM, multiparam, lang);
                }
                if (this.does_accent) {
                    this.createParameter(FIELD_ACCENT_PARAM, multiparam, lang);
                }
                this.createParameter(FIELD_FIELD_PARAM, multiparam, lang);
            }
        }
        return service;
    }

    protected void addCustomQueryParams(Element param_list, String lang) {
        this.createParameter("level", param_list, lang);
        super.addCustomQueryParams(param_list, lang);
    }

    protected void createParameter(String name, Element param_list, String lang) {
        Element param = null;
        if (name.equals("level")) {
            ArrayList level_ids = new ArrayList();
            ArrayList level_names = new ArrayList();
            this.getLevelData(level_ids, level_names, lang);
            param = level_ids.size() > 1 ? GSXML.createParameterDescription2(this.doc, "level", this.getTextString("param.level", lang), "enum_single", this.default_level, level_ids, level_names) : GSXML.createParameterDescription(this.doc, "level", "", "invisible", this.default_level, null, null);
        } else if (name.equals(RANK_PARAM)) {
            String[] vals1 = new String[]{"1", "0"};
            String[] vals1_texts = new String[]{this.getTextString("param.sortBy.1", lang), this.getTextString("param.sortBy.0", lang)};
            param = GSXML.createParameterDescription(this.doc, RANK_PARAM, this.getTextString("param.sortBy", lang), "enum_single", "1", vals1, vals1_texts);
        } else if (name.equals(FIELD_QUERY_PARAM)) {
            param = GSXML.createParameterDescription(this.doc, FIELD_QUERY_PARAM, this.getTextString("param.fqv", lang), "string", null, null, null);
        } else if (name.equals(FIELD_CASE_PARAM) || name.equals(FIELD_STEM_PARAM) || name.equals(FIELD_ACCENT_PARAM)) {
            String[] bool_ops = new String[]{"0", "1"};
            String[] bool_texts = new String[]{this.getTextString("param.boolean.off", lang, "AbstractSearch"), this.getTextString("param.boolean.on", lang, "AbstractSearch")};
            param = GSXML.createParameterDescription(this.doc, name, this.getTextString("param." + name, lang), "boolean", "1", bool_ops, bool_texts);
        } else if (name.equals(FIELD_FIELD_PARAM)) {
            ArrayList fields = new ArrayList();
            ArrayList field_names = new ArrayList();
            this.getIndexData(fields, field_names, lang);
            String default_value = fields.size() > 0 ? (String)fields.get(0) : null;
            param = GSXML.createParameterDescription2(this.doc, name, this.getTextString("param." + name, lang), "enum_single", default_value, fields, field_names);
        } else if (name.equals(FIELD_COMBINE_PARAM)) {
            String[] vals = new String[]{"0", "1", FIELD_COMBINE_PARAM_NOT};
            String[] val_texts = new String[]{this.getTextString("param.fqk.0", lang), this.getTextString("param.fqk.1", lang), this.getTextString("param.fqk.2", lang)};
            param = GSXML.createParameterDescription(this.doc, FIELD_COMBINE_PARAM, "", "enum_single", "0", vals, val_texts);
            param.setAttribute("ignore", "0");
        }
        if (param != null) {
            param_list.appendChild(param);
        } else {
            super.createParameter(name, param_list, lang);
        }
    }

    protected void getLevelData(ArrayList level_ids, ArrayList level_names, String lang) {
        Element level_list = (Element)GSXML.getChildByTagName(this.config_info, "levelList");
        NodeList levels = level_list.getElementsByTagName("level");
        for (int i = 0; i < levels.getLength(); ++i) {
            Element level = (Element)levels.item(i);
            String shortname = level.getAttribute("shortname");
            if (shortname.equals("")) continue;
            level_ids.add(shortname);
            String display_name = GSXML.getDisplayText(level, "name", lang, "en");
            if (display_name.equals("")) {
                display_name = level.getAttribute("name");
                display_name = display_name.equals("") ? shortname : this.getTextString("level." + display_name, lang);
            }
            level_names.add(display_name);
        }
    }

    protected Element processTextQuery(Element request) {
        return this.processAnyQuery(request, 0);
    }

    protected Element processFieldQuery(Element request) {
        return this.processAnyQuery(request, 1);
    }

    protected Element processAdvancedFieldQuery(Element request) {
        return this.processAnyQuery(request, 2);
    }

    protected Element processAnyQuery(Element request, int query_type) {
        String maxdocs_str;
        String service_name = null;
        String empty_query_test_param = null;
        switch (query_type) {
            case 0: {
                service_name = "TextQuery";
                empty_query_test_param = "query";
                break;
            }
            case 1: {
                service_name = FIELD_QUERY_SERVICE;
                empty_query_test_param = FIELD_QUERY_PARAM;
                break;
            }
            case 2: {
                service_name = ADVANCED_FIELD_QUERY_SERVICE;
                empty_query_test_param = FIELD_QUERY_PARAM;
                break;
            }
            default: {
                logger.error((Object)"wrong query type!!");
                return null;
            }
        }
        Element result = this.doc.createElement("response");
        result.setAttribute("from", service_name);
        result.setAttribute("type", "process");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"TextQuery request had no paramList.");
            return result;
        }
        HashMap params = GSXML.extractParams(param_list, false);
        String query = (String)params.get(empty_query_test_param);
        if (query == null || query.equals("")) {
            return result;
        }
        String field = (String)params.get("index");
        if (field == null) {
            field = this.default_index;
        }
        if (!this.setUpQueryer(params)) {
            return result;
        }
        switch (query_type) {
            case 0: {
                query = this.addFieldInfo(query, field);
                break;
            }
            case 1: {
                query = this.parseFieldQueryParams(params);
                break;
            }
            case 2: {
                query = this.parseAdvancedFieldQueryParams(params);
            }
        }
        Object query_result = this.runQuery(query);
        Element metadata_list = this.doc.createElement("metadataList");
        result.appendChild(metadata_list);
        long totalDocs = this.numDocsMatched(query_result);
        GSXML.addMetadata(this.doc, metadata_list, "numDocsMatched", "" + totalDocs);
        String[] docs = this.getDocIDs(query_result);
        String[] doc_ranks = this.getDocRanks(query_result);
        int docs_returned = docs.length;
        if (this.does_paging && (maxdocs_str = (String)params.get("maxDocs")) != null) {
            int maxdocs = Integer.parseInt(maxdocs_str);
            docs_returned = maxdocs < (int)totalDocs ? maxdocs : (int)totalDocs;
        }
        GSXML.addMetadata(this.doc, metadata_list, "numDocsReturned", "" + docs_returned);
        GSXML.addMetadata(this.doc, metadata_list, "query", query);
        if (docs.length > 0) {
            Element document_list = this.doc.createElement("documentNodeList");
            result.appendChild(document_list);
            for (int d = 0; d < docs.length; ++d) {
                String doc_id = this.internalNum2OID(docs[d]);
                Element doc_node = this.createDocNode(doc_id, doc_ranks[d]);
                document_list.appendChild(doc_node);
            }
        }
        Element term_list = this.doc.createElement("termList");
        result.appendChild(term_list);
        this.addTermInfo(term_list, params, query_result);
        return result;
    }

    protected abstract boolean setUpQueryer(HashMap var1);

    protected abstract Object runQuery(String var1);

    protected abstract long numDocsMatched(Object var1);

    protected abstract String[] getDocIDs(Object var1);

    protected abstract String[] getDocRanks(Object var1);

    protected abstract boolean addTermInfo(Element var1, HashMap var2, Object var3);

    protected String parseFieldQueryParams(HashMap params) {
        StringBuffer final_query = new StringBuffer(256);
        String text_line = (String)params.get(FIELD_QUERY_PARAM);
        String[] texts = text_line.split(",", -1);
        String field_line = (String)params.get(FIELD_FIELD_PARAM);
        String[] fields = field_line.split(",", -1);
        for (int i = 0; i < texts.length; ++i) {
            String q = texts[i].trim();
            if (q.equals("")) continue;
            final_query.append(" " + this.addFieldInfo(q, fields[i]));
        }
        return final_query.toString();
    }

    protected abstract String addFieldInfo(String var1, String var2);

    protected String parseAdvancedFieldQueryParams(HashMap params) {
        String accent_line;
        String stem_line;
        String case_line;
        StringBuffer final_query = new StringBuffer(256);
        String text_line = (String)params.get(FIELD_QUERY_PARAM);
        String[] texts = text_line.split(",", -1);
        String field_line = (String)params.get(FIELD_FIELD_PARAM);
        String[] fields = field_line.split(",", -1);
        String[] cases = null;
        String[] stems = null;
        String[] accents = null;
        if (this.does_case && (case_line = (String)params.get(FIELD_CASE_PARAM)) != null) {
            cases = case_line.split(",", -1);
        }
        if (this.does_stem && (stem_line = (String)params.get(FIELD_STEM_PARAM)) != null) {
            stems = stem_line.split(",", -1);
        }
        if (this.does_accent && (accent_line = (String)params.get(FIELD_ACCENT_PARAM)) != null) {
            accents = accent_line.split(",", -1);
        }
        String combine_line = (String)params.get(FIELD_COMBINE_PARAM);
        String[] combines = combine_line.split(",", -1);
        String combine = "";
        for (int i = 0; i < texts.length; ++i) {
            if (i == 0) {
                combine = "";
            } else {
                String x = combines[i];
                if (x.equals("0")) {
                    combine = this.AND_OPERATOR;
                } else if (x.equals("1")) {
                    combine = this.OR_OPERATOR;
                } else if (x.equals(FIELD_COMBINE_PARAM_NOT)) {
                    combine = this.NOT_OPERATOR;
                }
            }
            String q = texts[i].trim();
            boolean modified = false;
            if (q.equals("")) continue;
            String c = null;
            String s = null;
            String a = null;
            if (this.does_case) {
                modified = true;
                c = cases[i];
            }
            if (this.does_stem) {
                modified = true;
                s = stems[i];
            }
            if (this.does_accent) {
                modified = true;
                a = accents[i];
            }
            if (modified) {
                q = this.addStemOptions(q, s, c, a);
            }
            this.addQueryElem(final_query, q, fields[i], combine);
        }
        return final_query.toString();
    }

    protected abstract void addQueryElem(StringBuffer var1, String var2, String var3, String var4);

    protected abstract String addStemOptions(String var1, String var2, String var3, String var4);
}

