/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.MacroResolver;
import org.greenstone.gsdl3.util.OID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractBrowse
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)AbstractBrowse.class.getName());
    private static final String CLASSIFIER_SERVICE = "ClassifierBrowse";
    private static final String CLASSIFIER_METADATA_SERVICE = "ClassifierBrowseMetadataRetrieve";
    protected static final String STRUCT_PARAM = "structure";
    protected static final String INFO_PARAM = "info";
    protected static final String STRUCT_ANCESTORS = "ancestors";
    protected static final String STRUCT_PARENT = "parent";
    protected static final String STRUCT_SIBS = "siblings";
    protected static final String STRUCT_CHILDREN = "children";
    protected static final String STRUCT_DESCENDS = "descendants";
    protected static final String STRUCT_ENTIRE = "entire";
    protected static final String INFO_NUM_SIBS = "numSiblings";
    protected static final String INFO_NUM_CHILDREN = "numChildren";
    protected static final String INFO_SIB_POS = "siblingPosition";
    protected Element config_info = null;
    protected MacroResolver macro_resolver = null;
    protected String default_document_type = null;

    protected AbstractBrowse() {
    }

    public boolean configure(Element info, Element extra_info) {
        String value;
        Element doc_type_opt;
        String path;
        Element display_format;
        Element class_list;
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring AbstractBrowse...");
        this.config_info = info;
        if (this.macro_resolver != null) {
            this.macro_resolver.setSiteDetails(this.site_http_address, this.cluster_name, this.library_name);
            Element replacement_elem = (Element)GSXML.getChildByTagName(extra_info, "replaceList");
            if (replacement_elem != null) {
                this.macro_resolver.addMacros(replacement_elem);
            }
        }
        if ((class_list = (Element)GSXML.getChildByTagName(info, "classifierList")) == null) {
            return false;
        }
        this.extractExtraClassifierInfo(info, extra_info);
        Element cb_service = this.doc.createElement("service");
        cb_service.setAttribute("type", "browse");
        cb_service.setAttribute("name", CLASSIFIER_SERVICE);
        this.short_service_info.appendChild(cb_service);
        Element cbmr_service = this.doc.createElement("service");
        cbmr_service.setAttribute("type", "retrieve");
        cbmr_service.setAttribute("name", CLASSIFIER_METADATA_SERVICE);
        this.short_service_info.appendChild(cbmr_service);
        Element cb_format_info = this.doc.createElement("format");
        boolean format_found = false;
        Element def_format = (Element)GSXML.getChildByTagName(info, "format");
        if (def_format != null) {
            cb_format_info.appendChild(GSXML.duplicateWithNewName(this.doc, def_format, "default", true));
            format_found = true;
        }
        NodeList classifiers = class_list.getElementsByTagName("classifier");
        for (int i = 0; i < classifiers.getLength(); ++i) {
            Element cl = (Element)classifiers.item(i);
            Element new_cl = (Element)this.doc.importNode(cl, false);
            Element format_cl = (Element)new_cl.cloneNode(false);
            Element format = (Element)GSXML.getChildByTagName(cl, "format");
            if (format == null) continue;
            NodeList elems = format.getChildNodes();
            for (int j = 0; j < elems.getLength(); ++j) {
                format_cl.appendChild(this.doc.importNode(elems.item(j), true));
            }
            cb_format_info.appendChild(format_cl);
            format_found = true;
        }
        if (format_found) {
            this.format_info_map.put(CLASSIFIER_SERVICE, cb_format_info);
        }
        if ((display_format = (Element)GSXML.getNodeByPath(extra_info, path = GSPath.appendLink("display", "format"))) != null && (doc_type_opt = GSXML.getNamedElement(display_format, "gsf:option", "name", "documentType")) != null && !(value = doc_type_opt.getAttribute("value")).equals("")) {
            this.default_document_type = value;
        }
        return true;
    }

    protected Element getServiceDescription(String service_id, String lang, String subset) {
        if (service_id.equals(CLASSIFIER_SERVICE)) {
            Element class_list = (Element)GSXML.getChildByTagName(this.config_info, "classifierList");
            if (class_list == null) {
                return null;
            }
            Element cb_service = this.doc.createElement("service");
            cb_service.setAttribute("type", "browse");
            cb_service.setAttribute("name", CLASSIFIER_SERVICE);
            cb_service.appendChild(GSXML.createDisplayTextElement(this.doc, "name", this.getTextString("ClassifierBrowse.name", lang)));
            cb_service.appendChild(GSXML.createDisplayTextElement(this.doc, "description", this.getTextString("ClassifierBrowse.description", lang)));
            Element cl_list = this.doc.createElement("classifierList");
            cb_service.appendChild(cl_list);
            NodeList classifiers = class_list.getElementsByTagName("classifier");
            for (int i = 0; i < classifiers.getLength(); ++i) {
                Element cl = (Element)classifiers.item(i);
                Element new_cl = (Element)this.doc.importNode(cl, false);
                String class_id = cl.getAttribute("name");
                String content = this.getMetadata(class_id, "Title");
                cl_list.appendChild(new_cl);
                String text = GSXML.getDisplayText(cl, "name", lang, "en");
                if (text == null || text.equals("")) {
                    text = this.getMetadataNameText(content + ".buttonname", lang);
                }
                if (text == null) {
                    text = content;
                }
                Element cl_name = GSXML.createDisplayTextElement(this.doc, "name", text);
                new_cl.appendChild(cl_name);
                String meta_name = this.getMetadataNameText(content, lang);
                if (meta_name == null) {
                    meta_name = content;
                }
                String[] array = new String[]{meta_name};
                String description = this.getTextString("ClassifierBrowse.classifier_help", lang, array);
                Element cl_desc = GSXML.createDisplayTextElement(this.doc, "description", description);
                new_cl.appendChild(cl_desc);
            }
            return cb_service;
        }
        if (service_id.equals(CLASSIFIER_METADATA_SERVICE)) {
            Element cbmr_service = this.doc.createElement("service");
            cbmr_service.setAttribute("type", "retrieve");
            cbmr_service.setAttribute("name", CLASSIFIER_METADATA_SERVICE);
            return cbmr_service;
        }
        return null;
    }

    protected boolean extractExtraClassifierInfo(Element info, Element extra_info) {
        if (extra_info == null) {
            return false;
        }
        Document owner = info.getOwnerDocument();
        NodeList classifiers = info.getElementsByTagName("classifier");
        Element config_browse = (Element)GSXML.getChildByTagName(extra_info, "browse");
        for (int i = 0; i < classifiers.getLength(); ++i) {
            Element format;
            Element cl = (Element)classifiers.item(i);
            String name = cl.getAttribute("name");
            int position = Integer.parseInt(name.substring(2));
            Element node_extra = null;
            NodeList cls = config_browse.getElementsByTagName("classifier");
            if (position > 0 && position <= cls.getLength()) {
                node_extra = (Element)cls.item(position - 1);
            }
            if (node_extra == null) {
                logger.error((Object)("GS2REtrieve: haven't found extra info for classifier named " + name));
                continue;
            }
            NodeList display_names = node_extra.getElementsByTagName("displayItem");
            if (display_names != null) {
                Element display = owner.createElement("display");
                for (int j = 0; j < display_names.getLength(); ++j) {
                    Element e = (Element)display_names.item(j);
                    cl.appendChild(owner.importNode(e, true));
                }
            }
            if ((format = (Element)GSXML.getChildByTagName(node_extra, "format")) == null) {
                format = (Element)GSXML.getChildByTagName(extra_info, "format");
            }
            if (format == null) continue;
            cl.appendChild(owner.importNode(format, true));
        }
        Element default_format = (Element)GSXML.getChildByTagName(config_browse, "format");
        if (default_format != null) {
            info.appendChild(owner.importNode(default_format, true));
        }
        return true;
    }

    protected Element processClassifierBrowse(Element request) {
        Element result = this.doc.createElement("response");
        result.setAttribute("from", CLASSIFIER_SERVICE);
        result.setAttribute("type", "process");
        String lang = request.getAttribute("lang");
        Element query_node_list = (Element)GSXML.getChildByTagName(request, "classifierNodeList");
        if (query_node_list == null) {
            logger.error((Object)" ClassifierBrowse request specified no doc nodes.\n");
            return result;
        }
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)" ClassifierBrowse request had no paramList.");
            return result;
        }
        boolean want_structure = false;
        boolean want_info = false;
        ArrayList<String> info_types = new ArrayList<String>();
        boolean want_ancestors = false;
        boolean want_parent = false;
        boolean want_siblings = false;
        boolean want_children = false;
        boolean want_descendants = false;
        boolean want_entire_structure = false;
        NodeList params = param_list.getElementsByTagName("param");
        for (int i = 0; i < params.getLength(); ++i) {
            Element param = (Element)params.item(i);
            String p_name = param.getAttribute("name");
            String p_value = GSXML.getValue(param);
            if (p_name.equals(STRUCT_PARAM)) {
                want_structure = true;
                if (p_value.equals(STRUCT_ANCESTORS)) {
                    want_ancestors = true;
                    continue;
                }
                if (p_value.equals(STRUCT_PARENT)) {
                    want_parent = true;
                    continue;
                }
                if (p_value.equals(STRUCT_SIBS)) {
                    want_siblings = true;
                    continue;
                }
                if (p_value.equals(STRUCT_CHILDREN)) {
                    want_children = true;
                    continue;
                }
                if (p_value.equals(STRUCT_DESCENDS)) {
                    want_descendants = true;
                    continue;
                }
                if (p_value.equals(STRUCT_ENTIRE)) {
                    want_entire_structure = true;
                    continue;
                }
                logger.error((Object)("AbstractDocumentRetrieve Warning: Unknown value \"" + p_value + "\"."));
                continue;
            }
            if (!p_name.equals(INFO_PARAM)) continue;
            want_info = true;
            info_types.add(p_value);
        }
        if (want_ancestors) {
            want_parent = false;
        }
        if (want_descendants) {
            want_children = false;
        }
        Element node_list = this.doc.createElement("classifierNodeList");
        result.appendChild(node_list);
        String[] node_ids = GSXML.getAttributeValuesFromList(query_node_list, "nodeID");
        for (int i = 0; i < node_ids.length; ++i) {
            String parent_id;
            String parent_id2;
            Element base_node;
            Element node = this.doc.createElement("classifierNode");
            node_list.appendChild(node);
            String node_id = node_ids[i];
            node.setAttribute("nodeID", node_id);
            if (this.idNeedsTranslating(node_id)) {
                if ((node_id = this.translateId(node_id)) == null) continue;
                node.setAttribute("nodeID", node_id);
            }
            if (want_info) {
                Element node_info_elem = this.doc.createElement("nodeStructureInfo");
                node.appendChild(node_info_elem);
                for (int j = 0; j < info_types.size(); ++j) {
                    String info_type = (String)info_types.get(j);
                    String info_value = this.getStructureInfo(node_id, info_type);
                    if (info_value == null) continue;
                    Element info_elem = this.doc.createElement(INFO_PARAM);
                    info_elem.setAttribute("name", info_type);
                    info_elem.setAttribute("value", info_value);
                    node_info_elem.appendChild(info_elem);
                }
            }
            if (!want_structure) continue;
            Element structure_elem = this.doc.createElement("nodeStructure");
            node.appendChild(structure_elem);
            if (want_entire_structure) {
                String root_id = this.getRootId(node_id);
                Element root_node = this.createClassifierNode(root_id);
                this.addDescendants(root_node, root_id, true);
                structure_elem.appendChild(root_node);
                continue;
            }
            Element top_node = base_node = this.createClassifierNode(node_id);
            if (want_ancestors) {
                String current_id = node_id;
                while ((parent_id2 = this.getParentId(current_id)) != null) {
                    Element parent_node = this.createClassifierNode(parent_id2);
                    parent_node.appendChild(top_node);
                    current_id = parent_id2;
                    top_node = parent_node;
                }
            } else if (want_parent && (parent_id = this.getParentId(node_id)) != null) {
                Element parent_node = this.createClassifierNode(parent_id);
                parent_node.appendChild(base_node);
                top_node = parent_node;
            }
            structure_elem.appendChild(top_node);
            if (want_siblings) {
                Element parent_node = (Element)base_node.getParentNode();
                parent_id2 = this.getParentId(node_id);
                base_node = this.addSiblings(parent_node, parent_id2, node_id);
            }
            if (want_children) {
                this.addDescendants(base_node, node_id, false);
                continue;
            }
            if (!want_descendants) continue;
            this.addDescendants(base_node, node_id, true);
        }
        return result;
    }

    protected Element processClassifierBrowseMetadataRetrieve(Element request) {
        Element result = this.doc.createElement("response");
        String lang = request.getAttribute("lang");
        result.setAttribute("from", CLASSIFIER_METADATA_SERVICE);
        result.setAttribute("type", "process");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"AbstractBrowse, ClassifierBrowseMetadataRetrieve Error: missing paramList.\n");
            return result;
        }
        ArrayList<String> metadata_names_list = new ArrayList<String>();
        boolean all_metadata = false;
        for (Element param = GSXML.getFirstElementChild(param_list); param != null; param = (Element)param.getNextSibling()) {
            if (!param.getAttribute("name").equals("metadata")) continue;
            String metadata = GSXML.getValue(param);
            if (metadata.equals("all")) {
                all_metadata = true;
                break;
            }
            metadata_names_list.add(metadata);
        }
        Element node_list = this.doc.createElement("classifierNodeList");
        result.appendChild(node_list);
        Element request_node_list = (Element)GSXML.getChildByTagName(request, "classifierNodeList");
        if (request_node_list == null) {
            logger.error((Object)" ClassifierBrowseMetadataRetrieve request had no classifierNodeList");
            return result;
        }
        NodeList request_nodes = request_node_list.getChildNodes();
        for (int i = 0; i < request_nodes.getLength(); ++i) {
            Element request_node = (Element)request_nodes.item(i);
            String node_id = request_node.getAttribute("nodeID");
            Element new_node = (Element)this.doc.importNode(request_node, false);
            node_list.appendChild(new_node);
            if (this.idNeedsTranslating(node_id)) {
                node_id = this.translateId(node_id);
            }
            if (node_id == null) continue;
            Element metadata_list = this.getMetadataList(node_id, all_metadata, metadata_names_list);
            new_node.appendChild(metadata_list);
        }
        return result;
    }

    protected Element createClassifierNode(String node_id) {
        Element node = this.doc.createElement("classifierNode");
        node.setAttribute("nodeID", node_id);
        return node;
    }

    protected Element createDocNode(String node_id) {
        Element node = this.doc.createElement("documentNode");
        node.setAttribute("nodeID", node_id);
        String doc_type = null;
        doc_type = this.default_document_type != null ? this.default_document_type : this.getDocType(node_id);
        node.setAttribute("docType", doc_type);
        String node_type = this.getNodeType(node_id, doc_type);
        node.setAttribute("nodeType", node_type);
        return node;
    }

    protected String getNodeType(String node_id, String doc_type) {
        if (doc_type.equals("simple")) {
            return "leaf";
        }
        if (this.getParentId(node_id) == null) {
            return "root";
        }
        if (doc_type.equals("paged")) {
            return "leaf";
        }
        if (this.getChildrenIds(node_id) == null) {
            return "leaf";
        }
        return "internal";
    }

    protected void addDescendants(Element node, String node_id, boolean recursive) {
        ArrayList child_ids = this.getChildrenIds(node_id);
        if (child_ids == null) {
            return;
        }
        for (int i = 0; i < child_ids.size(); ++i) {
            String child_id = (String)child_ids.get(i);
            Element child_elem = this.isDocumentId(child_id) ? this.createDocNode(child_id) : this.createClassifierNode(child_id);
            node.appendChild(child_elem);
            if (!recursive) continue;
            this.addDescendants(child_elem, child_id, recursive);
        }
    }

    protected Element addSiblings(Element parent_node, String parent_id, String current_id) {
        Element current_node = GSXML.getFirstElementChild(parent_node);
        if (current_node == null) {
            logger.error((Object)" there should be a first child.");
            return null;
        }
        parent_node.removeChild(current_node);
        this.addDescendants(parent_node, parent_id, false);
        Element new_current = GSXML.getNamedElement(parent_node, current_node.getNodeName(), "nodeID", current_id);
        return new_current;
    }

    protected boolean idNeedsTranslating(String node_id) {
        return OID.needsTranslating(node_id);
    }

    protected ArrayList getSiblingIds(String node_id) {
        String parent_id = this.getParentId(node_id);
        if (parent_id == null) {
            return null;
        }
        return this.getChildrenIds(parent_id);
    }

    protected abstract String translateId(String var1);

    protected abstract String getDocType(String var1);

    protected abstract String getRootId(String var1);

    protected abstract ArrayList getChildrenIds(String var1);

    protected abstract String getParentId(String var1);

    protected abstract boolean isDocumentId(String var1);

    protected abstract Element getMetadataList(String var1, boolean var2, ArrayList var3);

    protected abstract String getMetadata(String var1, String var2);

    protected abstract String getStructureInfo(String var1, String var2);
}

