/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.core;

import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.collection.Collection;
import org.greenstone.gsdl3.collection.ServiceCluster;
import org.greenstone.gsdl3.comms.Communicator;
import org.greenstone.gsdl3.comms.SOAPCommunicator;
import org.greenstone.gsdl3.core.ModuleInterface;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.GlobalProperties;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageRouter
implements ModuleInterface {
    static Logger logger = Logger.getLogger((String)MessageRouter.class.getName());
    protected String site_name = null;
    protected String site_home = null;
    protected String site_http_address = null;
    protected String library_name = null;
    protected HashMap module_map = null;
    protected Document doc = null;
    public Element config_info = null;
    protected Element collection_list = null;
    protected Element private_collection_list = null;
    protected Element oai_collection_list = null;
    protected Element cluster_list = null;
    protected Element service_list = null;
    protected Element site_list = null;
    protected XMLConverter converter = new XMLConverter();

    public MessageRouter() {
        MessageRouter messageRouter = this;
        this.doc = messageRouter.converter.newDOM();
    }

    public void cleanUp() {
        this.cleanUpModuleMapEntire();
    }

    public void setSiteName(String site_name) {
        this.site_name = site_name;
    }

    public String getSiteName() {
        return this.site_name;
    }

    public void setLibraryName(String library_name) {
        this.library_name = library_name;
    }

    public String getLibraryName() {
        return this.library_name;
    }

    public boolean configure() {
        logger.info((Object)"configuring the Message Router");
        if (this.site_name == null) {
            logger.error((Object)" You must set site_name before calling configure");
            return false;
        }
        this.site_home = GSFile.siteHome(GlobalProperties.getGSDL3Home(), this.site_name);
        this.site_http_address = GlobalProperties.getGSDL3WebAddress() + "/sites/" + this.site_name;
        String host = GlobalProperties.getProperty("proxy.host");
        String port = GlobalProperties.getProperty("proxy.port");
        final String user = GlobalProperties.getProperty("proxy.user");
        final String passwd = GlobalProperties.getProperty("proxy.password");
        if (host != null && !host.equals("") && port != null && !port.equals("")) {
            System.setProperty("http.proxyType", "4");
            System.setProperty("http.proxyHost", host);
            System.setProperty("http.proxyPort", port);
            System.setProperty("http.proxySet", "true");
            if (user != null && !user.equals("") && passwd != null && !passwd.equals("")) {
                try {
                    Authenticator.setDefault(new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(user, new String(passwd).toCharArray());
                        }
                    });
                }
                catch (Exception e) {
                    logger.error((Object)"MessageRouter Error: couldn't set up an authenticator the proxy");
                }
            }
        }
        this.module_map = new HashMap();
        return this.configureLocalSite();
    }

    public String process(String xml_in) {
        Document doc = this.converter.getDOM(xml_in);
        Node result = this.process(doc);
        return XMLConverter.getString(result);
    }

    public Node process(Node message_node) {
        Element message = XMLConverter.nodeToElement(message_node);
        if (!message.getTagName().equals("message")) {
            logger.error((Object)(" Invalid message. GSDL message should start with <message>, instead it starts with:" + message.getTagName() + "."));
            return null;
        }
        NodeList requests = message.getElementsByTagName("request");
        Element mainResult = this.doc.createElement("message");
        if (requests.getLength() == 0) {
            logger.error((Object)"empty request");
            return mainResult;
        }
        Document message_doc = message.getOwnerDocument();
        int num_requests = requests.getLength();
        for (int i = 0; i < num_requests; ++i) {
            Node result = null;
            Element req = (Element)requests.item(i);
            if (req == null) {
                logger.error((Object)("request " + i + " is null"));
                continue;
            }
            String path = req.getAttribute("to");
            if (path.equals("")) {
                String type_att = req.getAttribute("type");
                result = type_att.equals("messaging") ? this.modifyMessages(req, message, mainResult) : this.processMessage(req);
                mainResult.appendChild(this.doc.importNode(result, true));
                continue;
            }
            String[] modules = path.split(",");
            for (int j = 0; j < modules.length; ++j) {
                Element mess = this.doc.createElement("message");
                Element copied_request = (Element)this.doc.importNode(req, true);
                mess.appendChild(copied_request);
                String this_mod = modules[j];
                String obj = GSPath.getFirstLink(this_mod);
                if (this.module_map.containsKey(obj)) {
                    copied_request.setAttribute("to", this_mod);
                    result = ((ModuleInterface)this.module_map.get(obj)).process(mess);
                    if (result != null) {
                        Node res = GSXML.getChildByTagName(result, "response");
                        if (res == null) continue;
                        mainResult.appendChild(this.doc.importNode(res, true));
                        continue;
                    }
                    Element response = this.doc.createElement("response");
                    response.setAttribute("from", this_mod);
                    mainResult.appendChild(response);
                    logger.error((Object)"MessageRouter Error: request had null result!");
                    continue;
                }
                logger.error((Object)("MessageRouter Error: request has illegal module name in:\n" + XMLConverter.getString(req)));
            }
        }
        logger.debug((Object)"MR returned response");
        logger.debug((Object)XMLConverter.getString(mainResult));
        return mainResult;
    }

    public Element getCollectionList() {
        return this.collection_list;
    }

    public HashMap getModuleMap() {
        return this.module_map;
    }

    protected void cleanUpModuleMapEntire() {
        if (this.module_map != null) {
            Iterator i = this.module_map.values().iterator();
            while (i.hasNext()) {
                ((ModuleInterface)i.next()).cleanUp();
                i.remove();
            }
        }
    }

    protected void cleanUpModuleMapSubset(Element list, String remote_site) {
        logger.error((Object)XMLConverter.getString(list));
        NodeList elements = list.getChildNodes();
        for (int i = elements.getLength() - 1; i >= 0; --i) {
            Element item = (Element)elements.item(i);
            String name = item.getAttribute("name");
            String potential_site_name = GSPath.getFirstLink(name);
            if (remote_site != null) {
                if (!remote_site.equals(potential_site_name)) continue;
                list.removeChild(item);
                continue;
            }
            if (!name.equals(potential_site_name)) continue;
            list.removeChild(item);
            ModuleInterface m = (ModuleInterface)this.module_map.remove(name);
            m.cleanUp();
            m = null;
        }
        logger.error((Object)XMLConverter.getString(list));
    }

    protected void cleanUpAllExternalSiteInfo() {
        NodeList site_nodes = this.site_list.getChildNodes();
        for (int i = site_nodes.getLength() - 1; i >= 0; --i) {
            Element item = (Element)site_nodes.item(i);
            String name = item.getAttribute("name");
            this.deactivateModule("site", name);
        }
    }

    protected boolean configureLocalSite() {
        this.cleanUpModuleMapEntire();
        File configFile = new File(GSFile.siteConfigFile(this.site_home));
        if (!configFile.exists()) {
            logger.error((Object)(" site config file: " + configFile.getPath() + " not found!"));
            return false;
        }
        Document config_doc = this.converter.getDOM(configFile);
        if (config_doc == null) {
            logger.error((Object)(" couldn't parse site config file: " + configFile.getPath()));
            return false;
        }
        this.config_info = config_doc.getDocumentElement();
        this.service_list = this.doc.createElement("serviceList");
        Element service_rack_list_elem = (Element)GSXML.getChildByTagName(this.config_info, "serviceRackList");
        this.configureServices(service_rack_list_elem);
        this.cluster_list = this.doc.createElement("serviceClusterList");
        Element cluster_list_elem = (Element)GSXML.getChildByTagName(this.config_info, "serviceClusterList");
        this.configureClusters(cluster_list_elem);
        this.collection_list = this.doc.createElement("collectionList");
        this.private_collection_list = this.doc.createElement("collectionList");
        this.oai_collection_list = this.doc.createElement("collectionList");
        this.configureCollections();
        this.site_list = this.doc.createElement("siteList");
        Element site_list_elem = (Element)GSXML.getChildByTagName(this.config_info, "siteList");
        this.configureExternalSites(site_list_elem);
        return true;
    }

    protected boolean configureServices(Element service_rack_list) {
        logger.info((Object)"loading service modules...");
        if (service_rack_list == null) {
            logger.info((Object)"... none to be loaded");
            return true;
        }
        NodeList service_racks = service_rack_list.getElementsByTagName("serviceRack");
        if (service_racks.getLength() == 0) {
            logger.info((Object)"... none to be loaded");
            return true;
        }
        Element service_message = this.doc.createElement("message");
        Element service_request = GSXML.createBasicRequest(this.doc, "describe", "", "", "");
        service_message.appendChild(service_request);
        for (int i = 0; i < service_racks.getLength(); ++i) {
            Element n = (Element)service_racks.item(i);
            String service_name = n.getAttribute("name");
            logger.info((Object)("..." + service_name));
            Class<?> service_class = null;
            try {
                service_class = Class.forName("org.greenstone.gsdl3.service." + service_name);
            }
            catch (ClassNotFoundException e) {
                try {
                    service_class = Class.forName(service_name);
                }
                catch (ClassNotFoundException ae) {
                    logger.info((Object)ae.getMessage());
                }
            }
            try {
                ServiceRack s = (ServiceRack)service_class.newInstance();
                s.setSiteHome(this.site_home);
                s.setSiteAddress(this.site_http_address);
                s.setLibraryName(this.library_name);
                s.setMessageRouter(this);
                if (!s.configure(n, null)) {
                    logger.error((Object)("couldn't configure ServiceRack " + service_name));
                    continue;
                }
                Element service_response = (Element)s.process(service_message);
                NodeList services = service_response.getElementsByTagName("service");
                if (services.getLength() == 0) {
                    logger.error((Object)("MessageRouter configure error: serviceRack " + service_name + " has no services!"));
                    continue;
                }
                for (int j = 0; j < services.getLength(); ++j) {
                    String service = ((Element)services.item(j)).getAttribute("name");
                    this.module_map.put(service, s);
                    this.service_list.appendChild(this.doc.importNode(services.item(j), true));
                }
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("MessageRouter configure exception:  in ServiceRack class specification:  " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return true;
    }

    protected boolean configureClusters(Element config_cluster_list) {
        logger.info((Object)"loading service clusters ...");
        if (config_cluster_list == null) {
            logger.info((Object)"... none to be loaded");
            return true;
        }
        NodeList service_clusters = config_cluster_list.getElementsByTagName("serviceCluster");
        if (service_clusters.getLength() == 0) {
            logger.info((Object)"... none to be loaded");
            return true;
        }
        for (int i = 0; i < service_clusters.getLength(); ++i) {
            Element cluster = (Element)service_clusters.item(i);
            String name = cluster.getAttribute("name");
            logger.info((Object)("..." + name));
            ServiceCluster sc = new ServiceCluster();
            sc.setSiteHome(this.site_home);
            sc.setSiteAddress(this.site_http_address);
            sc.setClusterName(name);
            sc.setMessageRouter(this);
            if (!sc.configure(cluster)) {
                logger.error((Object)("couldn't configure ServiceCluster " + name));
                continue;
            }
            this.module_map.put(name, sc);
            Element e = this.doc.createElement("serviceCluster");
            e.setAttribute("name", name);
            this.cluster_list.appendChild(e);
        }
        return true;
    }

    protected boolean configureCollections() {
        File collectDir = new File(GSFile.collectDir(this.site_home));
        if (collectDir.exists()) {
            logger.info((Object)("Reading thru directory " + collectDir.getPath() + " to find collections."));
            File[] contents = collectDir.listFiles();
            for (int i = 0; i < contents.length; ++i) {
                String colName;
                if (!contents[i].isDirectory() || (colName = contents[i].getName()).startsWith("CVS") || colName.startsWith(".svn")) continue;
                this.activateCollectionByName(colName);
            }
        }
        return true;
    }

    protected boolean activateCollectionByName(String col_name) {
        String coll_class_name;
        Element init_elem;
        Document init_doc;
        logger.info((Object)("Activating collection: " + col_name + "."));
        Collection c = null;
        File init_file = new File(GSFile.collectionInitFile(this.site_home, col_name));
        if (init_file.exists() && (init_doc = this.converter.getDOM(init_file)) != null && (init_elem = init_doc.getDocumentElement()) != null && !(coll_class_name = init_elem.getAttribute("class")).equals("")) {
            try {
                c = (Collection)Class.forName("org.greenstone.gsdl3.collection." + coll_class_name).newInstance();
            }
            catch (Exception e) {
                logger.info((Object)(" couldn't create a new collection, type " + coll_class_name + ", defaulting to class Collection"));
            }
        }
        if (c == null) {
            c = new Collection();
        }
        c.setCollectionName(col_name);
        c.setSiteHome(this.site_home);
        c.setSiteAddress(this.site_http_address);
        c.setMessageRouter(this);
        if (c.configure()) {
            logger.info((Object)("have just configured collection " + col_name));
            this.module_map.put(col_name, c);
            Element e = this.doc.createElement("collection");
            e.setAttribute("name", col_name);
            if (c.isPublic()) {
                this.collection_list.appendChild(e);
                if (c.hasOAI()) {
                    Element ane = this.doc.createElement("collection");
                    ane.setAttribute("name", this.site_name + ":" + col_name);
                    ane.setAttribute("lastmodified", "" + c.getLastmodified());
                    this.oai_collection_list.appendChild(ane);
                }
            } else {
                this.private_collection_list.appendChild(e);
            }
            return true;
        }
        logger.error((Object)("Couldn't configure collection: " + col_name + "."));
        return false;
    }

    protected boolean configureExternalSites(Element config_site_list) {
        logger.info((Object)"loading external sites...");
        if (config_site_list == null) {
            logger.info((Object)"...none found");
            return true;
        }
        NodeList sites = config_site_list.getElementsByTagName("site");
        if (sites.getLength() == 0) {
            logger.info((Object)"...none found");
            return true;
        }
        String local_site_name = config_site_list.getAttribute("localSiteName");
        if (local_site_name.equals("")) {
            local_site_name = this.site_name;
        }
        for (int i = 0; i < sites.getLength(); ++i) {
            Element s = (Element)sites.item(i);
            this.activateSite(s, local_site_name);
        }
        return true;
    }

    protected boolean activateSiteByName(String site_name) {
        Element this_site_elem;
        logger.info((Object)("Activating site: " + site_name + "."));
        File configFile = new File(GSFile.siteConfigFile(this.site_home));
        if (!configFile.exists()) {
            logger.error((Object)(" site config file: " + configFile.getPath() + " not found!"));
            return false;
        }
        Document config_doc = this.converter.getDOM(configFile);
        if (config_doc == null) {
            logger.error((Object)(" couldn't parse site config file: " + configFile.getPath()));
            return false;
        }
        Element config_elem = config_doc.getDocumentElement();
        Element config_site_list = (Element)GSXML.getChildByTagName(config_elem, "siteList");
        if (config_site_list == null) {
            logger.error((Object)"activateSite, no sites found");
            return false;
        }
        String local_site_name = config_site_list.getAttribute("localSiteName");
        if (local_site_name.equals("")) {
            local_site_name = site_name;
        }
        if ((this_site_elem = GSXML.getNamedElement(config_site_list, "site", "name", site_name)) == null) {
            logger.error((Object)("activateSite, site " + site_name + " not found"));
            return false;
        }
        return this.activateSite(this_site_elem, local_site_name);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean activateSite(Element site_elem, String local_site_name) {
        SOAPCommunicator comm = null;
        String type = site_elem.getAttribute("type");
        String name = site_elem.getAttribute("name");
        if (!type.equals("soap")) {
            System.err.print(" cant talk to server of type:" + type + ", so not making a connection to " + name);
            return false;
        }
        logger.info((Object)("activating SOAP site " + name));
        comm = new SOAPCommunicator();
        if (((Communicator)comm).configure(site_elem)) {
            comm.setLocalSiteName(local_site_name);
            this.module_map.put(name, comm);
            this.site_list.appendChild(this.doc.importNode(site_elem, true));
            if (this.getRemoteSiteInfo(comm, name)) return true;
            logger.error((Object)" couldn't get info from site");
            return true;
        }
        logger.error((Object)" couldn't configure site");
        return false;
    }

    protected boolean getRemoteSiteInfo(Communicator comm, String site_name) {
        NodeList clusters;
        NodeList services;
        logger.info((Object)(" getting info from site:" + site_name));
        Element info_request = this.doc.createElement("message");
        Element req = GSXML.createBasicRequest(this.doc, "describe", "", "", "");
        info_request.appendChild(req);
        Node info_response_node = comm.process(info_request);
        Element info_response = XMLConverter.nodeToElement(info_response_node);
        if (info_response == null) {
            return false;
        }
        NodeList colls = info_response.getElementsByTagName("collection");
        if (colls.getLength() > 0) {
            for (int i = 0; i < colls.getLength(); ++i) {
                Element e = (Element)colls.item(i);
                String col_name = e.getAttribute("name");
                e.setAttribute("name", GSPath.prependLink(col_name, site_name));
                this.collection_list.appendChild(this.doc.importNode(e, true));
            }
        }
        if ((services = info_response.getElementsByTagName("service")).getLength() > 0) {
            for (int i = 0; i < services.getLength(); ++i) {
                Element e = (Element)services.item(i);
                String serv_name = e.getAttribute("name");
                e.setAttribute("name", GSPath.prependLink(serv_name, site_name));
                this.service_list.appendChild(this.doc.importNode(e, true));
            }
        }
        if ((clusters = info_response.getElementsByTagName("serviceCluster")).getLength() > 0) {
            for (int i = 0; i < clusters.getLength(); ++i) {
                Element e = (Element)clusters.item(i);
                String clus_name = e.getAttribute("name");
                e.setAttribute("name", GSPath.prependLink(clus_name, site_name));
                this.cluster_list.appendChild(this.doc.importNode(e, true));
            }
        }
        return true;
    }

    protected boolean activateServiceClusterByName(String cluster_name) {
        return false;
    }

    protected boolean activateServiceRackByName(String module_name) {
        return false;
    }

    protected boolean deactivateModule(String type, String name) {
        logger.info((Object)("deactivating " + type + "  module: " + name));
        if (this.module_map.containsKey(name)) {
            logger.info((Object)"found the module");
            ModuleInterface m = (ModuleInterface)this.module_map.remove(name);
            if (type.equals("collection")) {
                if (((Collection)m).isPublic()) {
                    Element this_col = GSXML.getNamedElement(this.collection_list, "collection", "name", name);
                    if (this_col != null) {
                        this.collection_list.removeChild(this_col);
                    }
                    if (((Collection)m).hasOAI() && (this_col = GSXML.getNamedElement(this.oai_collection_list, "collection", "name", name)) != null) {
                        this.oai_collection_list.removeChild(this_col);
                    }
                } else {
                    Element this_col = GSXML.getNamedElement(this.private_collection_list, "collection", "name", name);
                    if (this_col != null) {
                        this.private_collection_list.removeChild(this_col);
                    }
                }
            } else if (type.equals("service")) {
                Element this_service = GSXML.getNamedElement(this.service_list, "service", "name", name);
                if (this_service != null) {
                    this.service_list.removeChild(this_service);
                }
            } else if (type.equals("serviceCluster")) {
                Element this_cluster = GSXML.getNamedElement(this.cluster_list, "serviceCluster", "name", name);
                if (this_cluster != null) {
                    this.cluster_list.removeChild(this_cluster);
                }
            } else if (type.equals("site")) {
                Element this_site = GSXML.getNamedElement(this.site_list, "site", "name", name);
                if (this_site != null) {
                    this.site_list.removeChild(this_site);
                    this.cleanUpModuleMapSubset(this.collection_list, name);
                    this.cleanUpModuleMapSubset(this.cluster_list, name);
                    this.cleanUpModuleMapSubset(this.service_list, name);
                }
            } else {
                logger.error((Object)("invalid module type: " + type + ", can't remove info about this module"));
            }
            m.cleanUp();
            m = null;
            return true;
        }
        logger.error((Object)(name + " module not found"));
        return false;
    }

    protected Element processMessage(Element req) {
        String type = req.getAttribute("type");
        Element response = this.doc.createElement("response");
        response.setAttribute("from", "");
        if (type.equals("describe")) {
            response.setAttribute("type", "describe");
            Element param_list = (Element)GSXML.getChildByTagName(req, "paramList");
            if (param_list == null) {
                response.appendChild(this.collection_list);
                response.appendChild(this.cluster_list);
                response.appendChild(this.site_list);
                response.appendChild(this.service_list);
                return response;
            }
            NodeList params = param_list.getElementsByTagName("param");
            for (int i = 0; i < params.getLength(); ++i) {
                Element param = (Element)params.item(i);
                if (!param.getAttribute("name").equals("subset")) continue;
                String info = param.getAttribute("value");
                if (info.equals("collectionList")) {
                    response.appendChild(this.collection_list);
                    continue;
                }
                if (info.equals("serviceClusterList")) {
                    response.appendChild(this.cluster_list);
                    continue;
                }
                if (info.equals("serviceList")) {
                    response.appendChild(this.service_list);
                    continue;
                }
                if (!info.equals("siteList")) continue;
                response.appendChild(this.site_list);
            }
            return response;
        }
        if (type.equals("oaiSetList")) {
            logger.info((Object)"oaiSetList request received");
            response.setAttribute("type", "oaiSetList");
            response.appendChild(this.oai_collection_list);
            return response;
        }
        if (type.equals("system")) {
            NodeList commands = req.getElementsByTagName("system");
            Element site_config_elem = null;
            boolean success = false;
            for (int i = 0; i < commands.getLength(); ++i) {
                Element s;
                Element elem = (Element)commands.item(i);
                String action = elem.getAttribute("type");
                if (action.equals("configure")) {
                    String subset = elem.getAttribute("subset");
                    if (subset.equals("")) {
                        this.configureLocalSite();
                        Element s2 = GSXML.createTextElement(this.doc, "status", "MessageRouter reconfigured successfully");
                        response.appendChild(s2);
                        continue;
                    }
                    if (subset.equals("collectionList")) {
                        this.cleanUpModuleMapSubset(this.collection_list, null);
                        this.cleanUpModuleMapSubset(this.private_collection_list, null);
                        success = this.configureCollections();
                    } else {
                        if (site_config_elem == null) {
                            File configFile = new File(GSFile.siteConfigFile(this.site_home));
                            if (!configFile.exists()) {
                                logger.error((Object)(" site config file: " + configFile.getPath() + " not found!"));
                                continue;
                            }
                            Document site_config_doc = this.converter.getDOM(configFile);
                            if (site_config_doc == null) {
                                logger.error((Object)(" couldn't parse site config file: " + configFile.getPath()));
                                continue;
                            }
                            site_config_elem = site_config_doc.getDocumentElement();
                        }
                        if (subset.equals("serviceList")) {
                            Element service_rack_list = (Element)GSXML.getChildByTagName(site_config_elem, "serviceRackList");
                            this.cleanUpModuleMapSubset(this.service_list, null);
                            success = this.configureServices(service_rack_list);
                        } else if (subset.equals("serviceClusterList")) {
                            Element cluster_list = (Element)GSXML.getChildByTagName(site_config_elem, "serviceClusterList");
                            this.cleanUpModuleMapSubset(this.cluster_list, null);
                            success = this.configureClusters(cluster_list);
                        } else if (subset.equals("siteList")) {
                            Element site_list = (Element)GSXML.getChildByTagName(site_config_elem, "siteList");
                            this.cleanUpAllExternalSiteInfo();
                            success = this.configureExternalSites(site_list);
                        }
                    }
                    String message = null;
                    message = success ? subset + "reconfigured successfully" : "Error in reconfiguring " + subset;
                    s = GSXML.createTextElement(this.doc, "status", message);
                    response.appendChild(s);
                    continue;
                }
                String module_name = elem.getAttribute("moduleName");
                String module_type = elem.getAttribute("moduleType");
                if (action.equals("deactivate")) {
                    success = this.deactivateModule(module_type, module_name);
                    if (success) {
                        s = GSXML.createTextElement(this.doc, "status", module_type + ": " + module_name + " deactivated");
                        response.appendChild(s);
                        continue;
                    }
                    s = GSXML.createTextElement(this.doc, "status", module_type + ": " + module_name + " could not be deactivated");
                    response.appendChild(s);
                    continue;
                }
                if (!action.equals("activate")) continue;
                this.deactivateModule(module_type, module_name);
                if (module_type.equals("collection")) {
                    success = this.activateCollectionByName(module_name);
                } else if (module_type.equals("site")) {
                    success = this.activateSiteByName(module_name);
                } else if (module_type.equals("serviceCluster")) {
                    success = this.activateServiceClusterByName(module_name);
                }
                if (success) {
                    s = GSXML.createTextElement(this.doc, "status", module_type + ": " + module_name + " activated");
                    response.appendChild(s);
                    continue;
                }
                s = GSXML.createTextElement(this.doc, "status", module_type + ": " + module_name + " could not be activated");
                response.appendChild(s);
            }
            return response;
        }
        logger.error((Object)" cant process request:");
        logger.error((Object)XMLConverter.getString(req));
        return null;
    }

    protected Element modifyMessages(Element request, Element message, Element result) {
        Element response = this.doc.createElement("response");
        response.setAttribute("from", "");
        response.setAttribute("type", "messaging");
        NodeList commands = request.getElementsByTagName("command");
        if (commands == null) {
            logger.error((Object)("no commands, " + XMLConverter.getPrettyString(request)));
            return response;
        }
        for (int i = 0; i < commands.getLength(); ++i) {
            Element action = (Element)commands.item(i);
            String type = action.getAttribute("type");
            if (type.equals("copyNode")) {
                Node new_parent;
                Node orig_node;
                String from_path = action.getAttribute("from");
                String to_path = action.getAttribute("to");
                Element from_node = null;
                String from_node_root = GSPath.getFirstLink(from_path);
                if (from_node_root.startsWith("request")) {
                    from_node = message;
                } else if (from_node_root.startsWith("response")) {
                    from_node = result;
                }
                if (from_node == null) continue;
                Element to_node = null;
                String to_node_root = GSPath.getFirstLink(to_path);
                if (to_node_root.startsWith("request")) {
                    to_node = message;
                } else if (to_node_root.startsWith("response")) {
                    to_node = result;
                }
                if (to_node == null || (orig_node = GSXML.getNodeByPathIndexed(from_node, from_path)) == null || (new_parent = GSXML.getNodeByPathIndexed(to_node, to_path)) == null) continue;
                new_parent.appendChild(to_node.getOwnerDocument().importNode(orig_node, true));
                continue;
            }
            if (!type.equals("copyChildren")) continue;
        }
        return response;
    }
}

