/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.action;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.action.Action;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryAction
extends Action {
    static Logger logger = Logger.getLogger((String)QueryAction.class.getName());

    public Node process(Node message_node) {
        Element message = XMLConverter.nodeToElement(message_node);
        Element request = (Element)GSXML.getChildByTagName(message, "request");
        Element result = this.doc.createElement("message");
        Element response = this.basicQuery(request);
        result.appendChild(this.doc.importNode(response, true));
        return result;
    }

    protected Element basicQuery(Element request) {
        Element page_response = this.doc.createElement("response");
        Element cgi_param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(cgi_param_list, false);
        String request_type = (String)params.get("rt");
        String service_name = (String)params.get("s");
        String collection = (String)params.get("c");
        if (collection == null || collection.equals("")) {
            collection = null;
        }
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        String to = service_name;
        if (collection != null) {
            to = GSPath.prependLink(to, collection);
        }
        if (request_type.indexOf("d") != -1) {
            Element mr_info_message = this.doc.createElement("message");
            Element mr_info_request = GSXML.createBasicRequest(this.doc, "describe", to, lang, uid);
            mr_info_message.appendChild(mr_info_request);
            Element mr_info_response = (Element)this.mr.process(mr_info_message);
            Element service_response = (Element)GSXML.getChildByTagName(mr_info_response, "response");
            Element service_description = (Element)this.doc.importNode(GSXML.getChildByTagName(service_response, "service"), true);
            page_response.appendChild(service_description);
        }
        if (request_type.indexOf("r") == -1) {
            return page_response;
        }
        HashMap service_params = (HashMap)params.get("s1");
        if (service_params == null) {
            return page_response;
        }
        Element mr_query_message = this.doc.createElement("message");
        Element mr_query_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
        mr_query_message.appendChild(mr_query_request);
        Element query_param_list = this.doc.createElement("paramList");
        GSXML.addParametersToList(this.doc, query_param_list, service_params);
        mr_query_request.appendChild(query_param_list);
        Element format_request = GSXML.createBasicRequest(this.doc, "format", to, lang, uid);
        mr_query_message.appendChild(format_request);
        logger.info((Object)GSXML.xmlNodeToString(mr_query_message));
        Element mr_query_response = (Element)this.mr.process(mr_query_message);
        if (this.processErrorElements(mr_query_response, page_response)) {
            return page_response;
        }
        NodeList responses = mr_query_response.getElementsByTagName("response");
        Element query_response = (Element)responses.item(0);
        Element format_response = (Element)responses.item(1);
        Element query_result_metadata_list = (Element)GSXML.getChildByTagName(query_response, "metadataList");
        if (query_result_metadata_list == null) {
            logger.error((Object)"No query result metadata.\n");
        } else {
            page_response.appendChild(this.doc.importNode(query_result_metadata_list, true));
        }
        Element query_term_info_list = (Element)GSXML.getChildByTagName(query_response, "termList");
        if (query_term_info_list == null) {
            logger.error((Object)"No query term information.\n");
        } else {
            page_response.appendChild(this.doc.importNode(query_term_info_list, true));
        }
        Element document_list = (Element)GSXML.getChildByTagName(query_response, "documentNodeList");
        if (document_list == null) {
            page_response.appendChild(this.doc.createElement("documentNodeList"));
            return page_response;
        }
        NodeList doc_metadata = document_list.getElementsByTagName("metadataList");
        if (doc_metadata.getLength() > 0) {
            logger.error((Object)"have already found metadata!");
            page_response.appendChild(this.doc.importNode(document_list, true));
            return page_response;
        }
        HashSet<String> metadata_names = new HashSet<String>();
        metadata_names.add("Title");
        Element format_elem = (Element)GSXML.getChildByTagName(format_response, "format");
        if (format_elem != null) {
            format_elem.setAttribute("type", "search");
            page_response.appendChild(this.doc.importNode(format_elem, true));
            this.extractMetadataNames(format_elem, metadata_names);
        }
        Element filtered_doc_list = this.filterDocList(params, service_params, document_list);
        Element mr_metadata_message = this.doc.createElement("message");
        to = "DocumentMetadataRetrieve";
        if (collection != null) {
            to = GSPath.prependLink(to, collection);
        }
        Element mr_metadata_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
        mr_metadata_message.appendChild(mr_metadata_request);
        Element dm_param_list = this.createMetadataParamList(metadata_names);
        mr_metadata_request.appendChild(dm_param_list);
        mr_metadata_request.appendChild(filtered_doc_list);
        Element mr_metadata_response = (Element)this.mr.process(mr_metadata_message);
        this.processErrorElements(mr_metadata_response, page_response);
        Element metadata_response = (Element)GSXML.getChildByTagName(mr_metadata_response, "response");
        Element query_result_document_list = (Element)GSXML.getChildByTagName(metadata_response, "documentNodeList");
        if (query_result_document_list != null) {
            page_response.appendChild(this.doc.importNode(query_result_document_list, true));
        }
        logger.debug((Object)("Query page:\n" + XMLConverter.getPrettyString(page_response)));
        return page_response;
    }

    protected Element filterDocList(HashMap params, HashMap service_params, Element orig_doc_list) {
        String hits_pp = (String)service_params.get("hitsPerPage");
        if (hits_pp == null) {
            hits_pp = (String)params.get("hitsPerPage");
        }
        int hits = 20;
        if (hits_pp != null && !hits_pp.equals("")) {
            try {
                hits = Integer.parseInt(hits_pp);
            }
            catch (Exception e) {
                hits = 20;
            }
        }
        if (hits == -1) {
            return (Element)this.doc.importNode(orig_doc_list, true);
        }
        NodeList result_docs = orig_doc_list.getElementsByTagName("documentNode");
        int num_docs = result_docs.getLength();
        if (num_docs <= hits) {
            return (Element)this.doc.importNode(orig_doc_list, true);
        }
        Element result_list = this.doc.createElement("documentNodeList");
        String start_p = (String)service_params.get("startPage");
        if (start_p == null) {
            start_p = (String)params.get("startPage");
        }
        int start = 1;
        if (start_p != null && !start_p.equals("")) {
            try {
                start = Integer.parseInt(start_p);
            }
            catch (Exception e) {
                start = 1;
            }
        }
        int start_from = (start - 1) * hits;
        int end_at = start * hits - 1;
        if (start_from > num_docs) {
            return result_list;
        }
        if (end_at > num_docs) {
            end_at = num_docs - 1;
        }
        for (int i = start_from; i <= end_at; ++i) {
            result_list.appendChild(this.doc.importNode(result_docs.item(i), true));
        }
        return result_list;
    }
}

