/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.action;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.action.Action;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AppletAction
extends Action {
    static Logger logger = Logger.getLogger((String)AppletAction.class.getName());

    public Node process(Node message_node) {
        Element message = XMLConverter.nodeToElement(message_node);
        Element request = (Element)GSXML.getChildByTagName(message, "request");
        Element result = this.doc.createElement("message");
        Element page_response = this.doc.createElement("response");
        result.appendChild(page_response);
        Element cgi_param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(cgi_param_list, false);
        String request_type = (String)params.get("rt");
        if (!request_type.equals("d") && !request_type.equals("r")) {
            logger.error((Object)("AppletAction Error: the rt arg should be either d or r, instead it was " + request_type + "!"));
            return result;
        }
        String collection = (String)params.get("c");
        boolean coll_specified = true;
        String service_name = (String)params.get("s");
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        String to = null;
        if (collection == null || collection.equals("")) {
            coll_specified = false;
            to = service_name;
        } else {
            to = GSPath.appendLink(collection, service_name);
        }
        if (request_type.equals("r")) {
            Element mr_message = this.doc.createElement("message");
            Element mr_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
            mr_message.appendChild(mr_request);
            mr_request.appendChild(this.doc.importNode(cgi_param_list, true));
            Element mr_response = (Element)this.mr.process(mr_message);
            String path = GSPath.appendLink("response", "appletData");
            Element applet_info = GSXML.getFirstElementChild(GSXML.getNodeByPath(mr_response, path));
            return applet_info;
        }
        Element mr_message = this.doc.createElement("message");
        Element applet_request = GSXML.createBasicRequest(this.doc, "describe", to, lang, uid);
        mr_message.appendChild(applet_request);
        Element mr_response = (Element)this.mr.process(mr_message);
        String path = GSPath.appendLink("response", "service");
        Element service_elem = (Element)this.doc.importNode(GSXML.getNodeByPath(mr_response, path), true);
        Element applet_elem = (Element)GSXML.getChildByTagName(service_elem, "applet");
        this.editLocalParams(applet_elem, (String)this.config_params.get("library_name"), collection);
        page_response.appendChild(service_elem);
        return result;
    }

    protected void editLocalParams(Element description, String library_name, String full_collection_name) {
        for (Node child = description.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name;
            String param;
            if (child.getNodeType() != 1 || !(param = child.getNodeName()).equals("PARAM") && !param.equals("param") || (name = ((Element)child).getAttribute("NAME")) == null || name.equals("")) continue;
            if (name.equals("library")) {
                ((Element)child).setAttribute("VALUE", library_name);
                continue;
            }
            if (!name.equals("collection")) continue;
            ((Element)child).setAttribute("VALUE", full_collection_name);
        }
    }
}

