###########################################################################
#
# win32 makefile -- gsdl runtime code
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDLHOME = $(GSDLHOME)
RUNTIMEHOME = $(MAKEDIR)

GSDL_VC4 = 0
LOCAL_LIBRARY = 0
APACHE_HTTPD = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0
USE_GDBM = 1
USE_JDBM = 1
USE_SQLITE = 1
USE_MSSQL = 0
USE_Z3950 = 0
ENABLE_MG = 1
ENABLE_MGPP = 1
ENABLE_LUCENE = 1

MDEFINES = /f win32.mak

COMPILEDIRS = src\colservr src\protocol

INSTALLDIRS = src\recpt src\oaiservr 

PACKAGEDIRS = 

YAZ_DIR = packages\yaz\yaz-2.1.56\win

MAKECMD = $(MAKE) $(MDEFINES) GSDLHOME="$(GSDLHOME)"
!IF $(GSDL_VC4)
MAKECMD = $(MAKECMD) GSDL_VC4=1
!ENDIF
!IF $(LOCAL_LIBRARY)
MAKECMD = $(MAKECMD) LOCAL_LIBRARY=1
INSTALLDIRS = $(INSTALLDIRS) src\w32server
!ENDIF
!IF $(APACHE_HTTPD)
MAKECMD = $(MAKECMD) APACHE_HTTPD=1
INSTALLDIRS = $(INSTALLDIRS) src\w32apachectl packages\apache-httpd
!ENDIF
!IF $(DEBUG)
MAKECMD = $(MAKECMD) DEBUG=1
!ENDIF
!IF $(DLL)
MAKECMD = $(MAKECMD) DLL=1
!ENDIF
!IF $(DLLDEBUG)
MAKECMD = $(MAKECMD) DLLDEBUG=1
!ENDIF
!IF !$(USE_GDBM)
MAKECMD = $(MAKECMD) USE_GDBM=0
!ENDIF
!IF !$(USE_JDBM)
MAKECMD = $(MAKECMD) USE_JDBM=0
!ENDIF
!IF !$(USE_SQLITE)
MAKECMD = $(MAKECMD) USE_SQLITE=0
!ENDIF
!IF $(USE_MSSQL)
MAKECMD = $(MAKECMD) USE_MSSQL=1
!ENDIF
!IF $(USE_Z3950)
MAKECMD = $(MAKECMD) USE_Z3950=1
INSTALLDIRS = src\z3950 $(INSTALLDIRS) 
PACKAGEDIRS = $(PACKAGEDIRS) packages\d2m $(YAZ_DIR)
!ENDIF
!IF !$(ENABLE_MG)
MAKECMD = $(MAKECMD) ENABLE_MG=0
!ENDIF
!IF !$(ENABLE_MGPP)
MAKECMD = $(MAKECMD) ENABLE_MGPP=0
!ENDIF
!IF !$(ENABLE_LUCENE)
MAKECMD = $(MAKECMD) ENABLE_LUCENE=0
!ENDIF

MAKECLEANCMD = $(MAKE) $(MDEFINES) GSDLHOME="$(GSDLHOME)" clean

all: win32.mak $(PACKAGEDIRS) $(COMPILEDIRS) $(INSTALLDIRS) 

install: win32.mak $(INSTALLDIRS)	
	if not exist "$(GSDLHOME)\etc\logs-gsi\*.*" MD "$(GSDLHOME)\etc\logs-gsi"
clean:
	cd "$(RUNTIMEHOME)"
	cd src\colservr
	$(MAKECLEANCMD)
	cd "$(RUNTIMEHOME)"
	cd src\protocol
	$(MAKECLEANCMD)
	cd "$(RUNTIMEHOME)"
	cd src\recpt
	$(MAKECLEANCMD)
	cd "$(RUNTIMEHOME)"
	cd src\oaiservr
	$(MAKECLEANCMD)
	cd "$(RUNTIMEHOME)"
	cd src\w32server
	$(MAKECLEANCMD)
	cd "$(RUNTIMEHOME)"
	cd src\w32apachectl
	$(MAKECLEANCMD)
	cd "$(RUNTIMEHOME)"
	cd packages\apache-httpd
	$(MAKECLEANCMD)
	cd "$(GSDLHOME)"

$(COMPILEDIRS): FORCE
	cd "$(RUNTIMEHOME)"
	cd "$@"
	$(MAKECMD)
	cd "$(GSDLHOME)"

$(INSTALLDIRS): FORCE
	cd "$(RUNTIMEHOME)"
	cd "$@"
	$(MAKECMD)
	$(MAKECMD) install
	cd "$(GSDLHOME)"

$(YAZ_DIR): FORCE
	cd "$@"
	nmake HAVE_ICONV=0 HAVE_LIBXML2=0
	cd "$(GSDLHOME)"

FORCE:

