/**********************************************************************
 *
 * wizardaction.h -- 
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_WIZARD_ACTION

#ifndef WIZARDACTION_H
#define WIZARDACTION_H

#include "action.h"
#include "receptionist.h"

class wizardaction : public action {
  

public:
  wizardaction ();
  virtual ~wizardaction ();

  void configure (const text_t &key, const text_tarray &cfgline);

  bool init (ostream &logout);

  void set_receptionist (receptionist *therecpt) {recpt=therecpt;}

  text_t get_action_name () {return "wizard";}

  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response,text_t &response_data, 
			 ostream &logout);

  bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      recptprotolistclass * protos, ostream &logout);


protected:
  bool disabled;
  receptionist *recpt;

  text_t macro_prefix;

  text_t message;
  char failcode;

  virtual text_t get_button (cgiargsclass &args, const text_t &thispage, 
			     const text_t &color, 
			     const text_t &type, bool enabled)=0;
			    

  text_t carriage_replace (const text_t &intext, int sw);

  text_t get_directory_name (const text_t &fullname);

  bool collection_protected (const text_t &collection);

  bool assign_tmpname (cgiargsclass &args, ostream &logout);


  void set_statusline (displayclass &disp, cgiargsclass &args, ostream &logout);
  void gsdl_build (cgiargsclass &args, ostream &logout);

  void gsdl_cancel_build (cgiargsclass &args, ostream &logout);

  text_t get_collectdir (cgiargsclass &args);

  void create_colserver (const text_t &collection, ostream &logout);

  void remove_colservr (const text_t &collection, ostream &logout);

  bool create_event_header_file (const text_t &filename, cgiargsclass &args, 
				 ostream &logout);

  text_t get_event_header (cgiargsclass &args);

  text_t format_url (const text_t &url);

  text_t remove_trailing_slashes (text_t str);

  void set_fullnamemenu (displayclass &disp, cgiargsclass &args,
			 recptprotolistclass *protos, ostream &logout);

  bool uses_weird_plugin (const text_t &collection);

};

#endif //!WIZARDACTION_H
#endif //GSDL_USE_WIZARD_ACTION
