/**********************************************************************
 *
 * os_process_test.cpp -- test harness of os_process classes
 * Copyright (C) 2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/



#include "os_process_windows.h"
#include "os_process_unix.h"

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace/std/iostream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#else
#  include <iostream>
using namespace std;
#endif




void test_uni_write_pipe()
{
#ifdef __WIN32__
  char* prog_name = "c:\\cygwin\\bin\\tr.exe";  
#else
  char* prog_name = "tr";
#endif

  char* argv[] = { "tr", "[A-Z]", "[a-z]", NULL };

  cout << "<hr>" << endl;
  cout << "<p>Unidirectional Write Test<br>" << endl;
  cout << "&nbsp;&nbsp;Converts uppercase letters to lowercase<br>" << endl;
  cout << "&nbsp;&nbsp;These are then sent to whereever the stdout of the child process goes" << endl;
  cout << "<p>" << endl;

#ifdef __WIN32__
  osprocesswindows* process = new osprocesswindows(uniWrite,prog_name,argv);
#else
  osprocessunix* process = new osprocessunix(uniWrite,prog_name,argv);
#endif
  
  char* buffer = "TESTING uniWirite IN CAP<br>\nTesting uniWrite in Mixed Case<br>\n";
  int buffer_len = strlen(buffer);

  if (!process->write(buffer,buffer_len)) {
    cerr << "Error: failed to write to child process\n";
  }

  process->close();

  process->wait();

  delete process;
}


void test_uni_read_pipe()
{
  char* prog_name = "java";
  char* argv[] = { "java", NULL };

  cout << "<hr>" << endl;
  cout << "<p>Unidirectional Read Test<br>" << endl;
  cout << "&nbsp;&nbsp;The output of 'java' is read in by this process and then sent to stdout" << endl;
  cout << "<p>" << endl;


  // through virutal inheritence can pass object around as base class, if
  // desired
#ifdef __WIN32__
  osprocess* process = new osprocesswindows(uniRead,prog_name,argv);
#else
  osprocess* process = new osprocessunix(uniRead,prog_name,argv);
#endif
  
  const int BufferSize = 1024;
  char buffer[BufferSize];

  int bytes_read = 0;
  do {
    bytes_read = process->read(buffer,BufferSize);
    if (bytes_read>0) {
      fwrite(buffer,1,bytes_read,stdout);
    }
  } while (bytes_read==BufferSize);


  // deleting object will also have the effect of closing any open handles
  delete process;

}



void test_bi_read_write_pipe()
{
#ifdef __WIN32__
  char* prog_name = "c:\\cygwin\\bin\\tr.exe";
#else
  char* prog_name = "tr";
#endif
  char* argv[] = { "tr", "[A-Z]", "[a-z]", NULL };

  // Converts uppercase letters to lowercase
  // Answer is read back and then printed to STDOUT by this process

  cout << "<hr>" << endl;
  cout << "<p>Bidirectional Read/Write Test<br>" << endl;
  cout << "&nbsp;&nbsp;Converts uppercase letters to lowercase<br>" << endl;
  cout << "&nbsp;&nbsp;Data is sent to child process down pipe by this process<br>" << endl;
  cout << "&nbsp;&nbsp;Answer is read back from child process and printed to stdout" << endl;
  cout << "<p>" << endl;

#ifdef __WIN32__
  osprocesswindows* process = new osprocesswindows(biReadWrite,prog_name,argv);
#else
  osprocessunix* process = new osprocessunix(biReadWrite,prog_name,argv);
#endif
  
  char* write_buffer = "TESTING biReadWrite IN CAP<br>\nTesting biReadWrite in Mixed Case<br>\n";
  int write_buffer_len = strlen(write_buffer);

  if (!process->write(write_buffer,write_buffer_len)) {
    cerr << "Error: failed to write to child process\n";
  }

  const int BufferSize = 1024;
  char read_buffer[BufferSize];
  process->close_write_pipe();

  int bytes_read = 0;
  do {
    bytes_read = process->read(read_buffer,BufferSize);
    if (bytes_read>0) {
      fwrite(read_buffer,1,bytes_read,stdout);
    }
  } while (bytes_read==BufferSize);


  process->close();

  delete process;

}


int main()
{
  printf("Content-type: text/html\n\n");
  
  printf( "<html>\n");
  printf( "  <head>\n");
  printf( "    <title>Testing</title>\n");
  printf( "  </head>\n");
  printf( "  <body>\n");

  test_uni_read_pipe();
  test_uni_write_pipe();
  test_bi_read_write_pipe();

  printf( "  </body>\n");
  printf( "</html>\n");
  
  return 0;
}



