/**********************************************************************
 *
 * cgiwrapper.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef CGIWRAPPER_H
#define CGIWRAPPER_H


#include "receptionist.h"
#include "userdb.h"
#include "ispersistentaction.h"

void add_all_actions(receptionist& recpt, userdbclass* udb, keydbclass* kdb, isPersistentEnum isPersistentVal);
void add_all_browsers(receptionist& recpt);

// cgiwrapper does everything necessary to output a page
// using the cgi protocol. If this is being run for a particular
// collection then "collection" should be set, otherwise it
// should equal "".
//
// NB: the collectset MAY NOT exist for remote protocols (e.g.
//     the corba protocol; as references must point to a non-
//     null instance, we must therefore use a pointer - sorry!
void cgiwrapper (receptionist &recpt, text_t collection);


#endif
