/**********************************************************************
 *
 * recptprototools.h -- 
 * Copyright (C) 1999-2008  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef RECPTPROTOTOOLS_H
#define RECPTPROTOTOOLS_H


#include "text_t.h"
#include "recptproto.h"


// get_info does a protocol call and returns (in response) the info 
// associated with OID. Metadata should be loaded with whatever
// metadata fields are to be requested
bool get_info (const text_t &OID, const text_t &collection, const text_t &lang,
	       const text_tset &metadata, bool getParents,
	       recptproto *collectproto, FilterResponse_t &response, 
	       ostream &logout, int filterResultOptions=0);
bool get_oai_info (const text_t &OID, const text_t &collection, const text_t &lang,
	       const text_tset &metadata, bool getParents,
	       recptproto *collectproto, FilterResponse_t &response, 
	       ostream &logout);
bool get_info (const text_t &OID, const text_t &collection, const text_t &lang,
	       const text_tset &metadata, const OptionValue_tarray &options,
	       bool getParents,
	       recptproto *collectproto, FilterResponse_t &response, 
	       ostream &logout);
bool get_info (const text_tarray &OIDs, const text_t &collection, const text_t &lang,
	       const text_tset &metadata, bool getParents,
	       recptproto *collectproto, FilterResponse_t &response, 
	       ostream &logout);

// has_children returns true if OID has children
bool has_children (const text_t &OID, const text_t &collection, const text_t &lang, 
		   recptproto *collectproto, ostream &logout);

// get_children does a protocol call and returns (in response) the OIDs and 
// metadata of all the children of OID. The metadata set should be loaded
// with whatever metadata fields are to be requested.
bool get_children (const text_t &OID, const text_t &collection, const text_t &lang, 
		   const text_tset &metadata, bool getParents,
		   recptproto *collectproto, FilterResponse_t &response, 
		   ostream &logout, int filterResultOptions=0);

// get_contents returns OIDs and metadata of all contents 
// below (and including) OID.
void get_contents (const text_t &topOID, const bool &is_classify, 
		   text_tset &metadata, const text_t &collection, const text_t &lang, 
		   recptproto *collectproto, FilterResponse_t &response, 
		   ostream &logout);

bool get_metadata_values (const text_t metadata_elements, const text_t metadata_value_filter,
			  const text_t metadata_value_grouping_expression, const text_t &collection,
			  recptproto *collectproto, FilterResponse_t &response, ostream &logout);

bool get_documents_with_metadata_value (const text_t metadata_elements, const text_t metadata_value,
					const text_t sort_by_metadata_element_name, const text_t &collection,
					recptproto *collectproto, FilterResponse_t &response, ostream &logout);

#endif
