/**********************************************************************
 *
 * mgsearch.h --  implementation of search for old versions of mg
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef MGSEARCH_H
#define MGSEARCH_H


#include "search.h"

class mgsearchclass : public searchclass {
public:
  mgsearchclass ();
  virtual ~mgsearchclass ();

  virtual text_t get_textindex_type() {return "mg";}

  // you only need to use this function before doing any stemming
  // casefolding and stemming will be set if values for them are
  // provided (0 or 1).
  // makeindexcurrent returns true if it was able to load the database
  bool makeindexcurrent (const text_t &index, const text_t &subcollection,
			 const text_t &language, const text_t &collection,
			 int casefolding = -1, int stemming = -1);

  // stem word uses the values set in the last call to makeindexcurrent
  // to stem the word. It is assumed that word is in unicode
  text_t stemword (const text_t &word);
  text_t stemword (text_t::const_iterator here, text_t::const_iterator end);
  
  // the search results are returned in queryresults
  // search returns 'true' if it was able to do a search
  bool search(const queryparamclass &queryparams, 
	      queryresultsclass &queryresults);
  
  // the document text for 'docnum' is placed in 'output'
  // docTargetDocument returns 'true' if it was able to
  // try to get a document
  // collection is needed to see if an index from the 
  // collection is loaded. If no index has been loaded
  // defaultindex is needed to load one
  bool docTargetDocument(const text_t &defaultindex,
			 const text_t &defaultsubcollection,
			 const text_t &defaultlanguage,
			 const text_t &collection,
			 int docnum,
			 text_t &output);

  // same as docTargetDocument except the document is returned
  // in its raw form. UDoc remains the property of mg and may
  // be destroyed on the next call to mg.
  bool mgdocument (const text_t &defaultindex,
		   const text_t &defaultsubcollection,
		   const text_t &defaultlanguage,
		   const text_t &collection,
		   int docnum,
		   char *&UDoc, int &ULen);

  // unload_database simply calls mgq's close_all_databases function to
  // clear any cached databases - this is useful when attempting to
  // completely remove all trace of a collectionserver at runtime (when
  // using a persistent version of Greenstone like the windows local
  // library)
  void unload_database ();

  void set_indexstem(const text_t &indexstem);

protected:

  text_t indexstem; // the stem of the index files - defaults to the collectionname
  void setsearchmode (const queryparamclass &queryparams);
  void submitquery (const queryparamclass &queryparams);
  void getresults (const queryparamclass &queryparams, queryresultsclass &queryresults);
  text_t getindexsuffix (const text_t &collection, const text_t &index);
  virtual void filterquery (text_t &ttquerystring);
};


#endif
