/**********************************************************************
 *
 * expat_document.cpp --
 *
 * Copyright (C) 2005-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include <stdio.h>
#include <string.h>
#include <expat.h>
#include "gsdlunicode.h"

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\iostream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#else
#  include <iostream>
using namespace std;
#endif

#include "queryinfo.h"

#include "expat_document.h"

#include "text_t.h"
#include "fileutil.h"
#include "expat_resultset.h"

struct resultpack {
  text_t *current_text;
  text_t *section_num;
  text_t *section_level;
  bool store_text;
};

static void XMLCALL 
startElement(void *userData, const char *name, const char **attributes)
{
  resultpack * rpack_ptr = (resultpack*)userData;
  text_t element_name = (char*)name;
  if (element_name == *(rpack_ptr->section_level)) {
    text_t id_att = (char *)get_attribute(attributes,"gs2:docOID");
    if (id_att == *(rpack_ptr->section_num)) {
      rpack_ptr->store_text = true;
    }
    
  }
}

static void XMLCALL
endElement(void *userData, const char *name)
{
  resultpack * rpack_ptr = (resultpack*)userData;
  text_t element_name = (char*)name;
  if (element_name == *(rpack_ptr->section_level)) {
    if (rpack_ptr->store_text == true) {
      // we have finished now, can we quit this??
      rpack_ptr->store_text = false;
    }
  }
  
}

static void XMLCALL
characterData(void *userData, const char * text, int len) {
  resultpack * rpack_ptr = (resultpack*)userData;
  if  (rpack_ptr->store_text) {
    rpack_ptr->current_text->appendcarr(text, len);
  }
}


int expat_document(const text_t &filename, const text_t &sec_level, const text_t &sec_num, text_t & doc_content)
{
  text_t current_text;
  current_text.clear();
  text_t section_num = sec_num;
  text_t section_level = sec_level;

  resultpack rpack = { &current_text, &section_num, &section_level, false};
  //cerr << "sec num = "<<sec_num<<", sec level="<<sec_level<<", filename="<<filename<<endl;
  text_t doc_text;
  read_file(filename, doc_text);

  char* c_doc_text = doc_text.getcstr();
  XML_Parser parser = XML_ParserCreate(NULL);
  
  XML_SetUserData(parser, &rpack);
  XML_SetElementHandler(parser, startElement, endElement);
  XML_SetCharacterDataHandler(parser, characterData);
  int return_status = 0;
  const int parse_status 
    = XML_Parse(parser, c_doc_text, strlen(c_doc_text), XML_TRUE);

  if (parse_status == XML_STATUS_ERROR) {
    cerr << "Error: " << XML_ErrorString(XML_GetErrorCode(parser)) << " at line " << XML_GetCurrentLineNumber(parser) << endl;
    return_status = 1;
  }
  
  XML_ParserFree(parser);
  delete []c_doc_text;

  doc_content = to_uni(current_text);  // Vital for non-ASCII documents
  return return_status;
}


