/**********************************************************************
 *
 * colservrconfig.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: colservrconfig.cpp 16310 2008-07-09 01:12:15Z davidb $
 *
 *********************************************************************/

#include "colservrconfig.h"
#include "fileutil.h"
#include "cfgread.h"


#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace/std/iostream>
#  include <ospace/std/fstream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#  include <fstream.h>
#else
#  include <iostream>
#  include <fstream>
#endif

// collect_cfg_read reads collect.cfg returning true on success.
bool collect_cfg_read (collectserver &cserver, const text_t &gsdlhome,
		       const text_t& collecthome,
		       const text_t &collection) 
{
  text_t filename = filename_cat (collecthome, collection);
  filename = filename_cat (filename, "custom",collection,"etc","custom.cfg");

  if (!file_exists (filename)) {
    filename = filename_cat (collecthome, collection, "etc", "collect.cfg");

    if (!file_exists (filename)) {
      filename = filename_cat (gsdlhome, "etc", "collect.cfg");
      if (!file_exists (filename)) return false;
    }
  }

  return cserver.read_configfile(filename);
}


// build_cfg_read reads build.cfg and returns true on success.
bool build_cfg_read (collectserver &cserver, const text_t &gsdlhome,
		     const text_t& collecthome,
		     const text_t &collection) {
  text_t filename = filename_cat (collecthome, collection,"index","build.cfg");

  if (!file_exists (filename)) {
    filename = filename_cat (gsdlhome, "index", "build.cfg");
    if (!file_exists (filename)) return false;
  }

  return cserver.read_configfile(filename);

}
