# This program replaces each occurrence of tempfile.bat in the current input line 
# with tempfile-concatenated-to-current-count-.bat.

# The current line is denoted by dollar-0. The global substitution regex, gsub,
# doesn't return anything, but replaces what's in the 3rd argument. By default
# gsub's 3rd argument is dollar-0 but we explicitly provide this as 3rd argument here.
# The print command then outputs what we want for the current input line, in this
# case dollar-0 which has been modified by the gsub.

# https://www.gnu.org/software/gawk/manual/gawk.html#Two-Rules
# For global substition function gsub, see https://www.tutorialspoint.com/awk/awk_string_functions.htm


# The begin block is for initialisation such as declaration of vars
BEGIN { count = 1 }

# We can have as many regex rules here as we want. Each gets applied in
# sequence to the current input line. In this case we have one regex rule
# It matches tempfile\d*.bat and then defines what should happen when that
# line is encountered.
/tempfile\.bat/ { 
                    uniq_temp = "tempfile" count ".bat"
					gsub("tempfile.bat",uniq_temp,$0)					
					count++
				}
/\/MD/ {
	gsub("/MD", "/MT")	
}

# the current line is now correct, output it
{
	print $0
}
