:: This file ports the changes Sam made to the release-kit (using ant tasks) for compiling the GS2 release
:: See changeset http://trac.greenstone.org/changeset/22490
:: (Also http://trac.greenstone.org/browser/main/trunk/ant-tasks/src/org/greenstone/anttasks/RegexSearchReplace.java
:: http://trac.greenstone.org/browser/main/trunk/ant-tasks/src/org/greenstone/anttasks/InsertUniqueValue.java)
:: This script makes use of mod_winmake_file.awk to perform the following 2 steps
:: to prevent race conditions to any win32.mak file trying to create/access the same tempfile.bat: 
:: - in each .mak within httpd-2.2.11, make each line that refers to "tempfile.bat" refer to a unique tempfile.bat instead
:: - replace all occurrences of "/MD" in .mak files within httpd-2.2.11 with "/MT"

:: http://www.theverge.com/2016/3/30/11331014/microsoft-windows-linux-ubuntu-bash
:: "Microsoft is adding the Linux command line to Windows 10" Mar 30, 2016


@echo off

:: pass in the httpd folder to this script, e.g. httpd-2.2.11
if [%1]==[] echo ERROR: Extracted httpd folder name not specified. Unable to adjust win .mak files&& goto :eof
if not exist "%~dp0%1" echo ERROR: Extracted httpd folder %~dp0%1 doesn't exist. Unable to adjust win .mak files&& goto :eof

setlocal enableextensions enabledelayedexpansion
set httpdfolder=%1

:: http://stackoverflow.com/questions/4419868/what-is-the-current-directory-in-a-batch-file
pushd "%CD%"
cd /d "%~dp0"

:: Use sed to regex search and replace text files
:: http://stackoverflow.com/questions/1115508/batch-find-and-edit-lines-in-txt-file
:: (Instead of sed can also use FindRepl.bat from http://www.dostips.com/forum/viewtopic.php?t=4697)
:: First add SED to PATH:
set PATH=..\..\..\bin\windows;%PATH%

:: Incrementing http://stackoverflow.com/questions/21697199/how-to-increment-variable-under-dos
:: http://stackoverflow.com/questions/2913231/how-do-i-increment-a-dos-variable-in-a-for-f-loop
:: http://stackoverflow.com/questions/17605767/create-list-or-arrays-in-windows-batch
rem set counter=0

:: http://stackoverflow.com/questions/2951063/windows-bat-file-how-to-recursively-list-all-files-of-type-mp3
:: "This batch file demonstrates how to extract elements of a filename from the variable in a for loop.
:: Save this as listfiles.bat, then run "listfiles some\folder *.mp3".
:: I set up the file finding as a subroutine in the batch file so you can insert it into your own scripts."

call :rsr-files %httpdfolder% *.mak

popd
endlocal

goto :eof

:: ************************ SUBROUTINES **********************************************

:: A win mak file may make references to tempfile.bat in various lines of the makefile. The different
:: references could end up clashing with each other when they're generated on the file system by
:: that .mak file, leading to race conditions. To avoid this, within each win32.mak file, ensure
:: unique tempfile .bat files are generated:
:: For each win32.mak file, change each line of reference to tempfile.bat to a unique tempfile.bat
:: by renaming the references in that makefile line to tempfile<number>.bat. Note: change each
:: LINE to refer consistently to a unique tempfile .bat, don't make each reference in a line
:: refer to a different tempfile.bat.
:: Further, change any occurrence of /MD to /MT in each .mak file too.
:: To check this script has worked, check httpd-2.2.11/modules/ssl/mod_ssl.mak to make sure
:: occurrences of "tempfile.bat" have a number suffix before the extension and that there's
:: no occurrence of /MD (or /MDd) only of /MT (and /MTd).
:: See https://msdn.microsoft.com/en-us/library/2kzt1wy3.aspx for /MD, /MDd, /MT, /MTd
		
:rsr-files
    set PATHS=
    set NAMES=
    for /r "%~1" %%P in ("%~2") do (
        
		set filename=%%~fP
		echo file: Modifying win32.mak file !filename! to refer to unique tempfile .bat files to avoid race conditions.		
		
		rem http://stackoverflow.com/questions/4462954/sed-increment-number
		rem https://www.gnu.org/software/gawk/manual/gawk.html see section An Example with Two Rules
		copy "!filename!" "!filename!.tmp"
		awk -f mod_winmak_file.awk "!filename!.tmp" > "!filename!"
		del "!filename!.tmp"
		
    )
goto :eof
