package org.greenstone.gatherer.feedback;

import java.util.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
import javax.swing.*;
import java.awt.*;

/**
 * This class willl hold the information about a component and the contents inside the component.
 * @author Veronica Liesaputra
 */
public class UserComponent implements Serializable
{
    /**
     * This variable will hold what is the type of instance this component is.
     */
    private String type = null;

    /**
     * This variable will store the title of this component.
     */
    private String title = null;

    /**
     * This varaible will store the array list of the contents of this component.
     */
    private ArrayList content = null;

    /**
     * This variable will store the status of this component, whether or not
     * this component is selected by the user.
     */
    private String selected = null;

    /**
     * This variable will store the status of this component, whether or not
     * this component is visible.
     */
    private String visible = null;

    /**
     * This variable will hold the descrption text saying that there is no
     * image in this component.
     */
    private String image = null;

    /**
     * This is the supposed filename of the image that is in this component should use if 
     * we want to save it to a jpeg file.
     */
    private String img = null;

    /**
     * This is the string representation of the image that is in this component.
     */
    private String imgFile = null;

    /**
     * This is the index that will help storing the data to the correct data member.
     */
    private int index;

    /**
     * This is the height of the image that is in this component.
     */
    private String height;

    /**
     * This is the width of the image that is in this component.
     */
    private String width;

    /**
     * This variable will hold the tooltiptext set for this component.
     */
    private String tooltip;

    /**
     * This will initialized content to a new empty Arrray list.
     */
    public UserComponent()
    {
	content = new ArrayList();
    }

    /**
     * This method will get the width of the image that is inside this component.
     * @return image's width.
     */
    public String getWidth()
    {
	return width;
    }

    /**
     * This method will get the height of the image that is inside this component.
     * @return image's height.
     */
    public String getHeight()
    {
	return height;
    }

    /**
     * This method will get the type of instance this component is.
     * @return component's type.
     */
    public String getType()
    {
	return type;
    }

    /**
     * This method will get the tooltiptext set for this component.
     * @return component's tooltiptext.
     */
    public String getToolTip()
    {
	return tooltip;
    }

    /**
     * This method will get the title for this component.
     * @return component's title.
     */
    public String getTitle()
    {
	return title;
    }

    /**
     * This method will get the content inside this component.
     * @return component's content.
     */
    public ArrayList getContent()
    {
	return content;
    }

    /**
     * This method will get whether or not this component is 
     * selected by the user.
     * @return component selected or not.
     */
    public String getSelected()
    {
	return selected;
    }

    /**
     * This method will get whether or not this component is 
     * visible.
     * @return component visible or not.
     */
    public String getVisible()
    {
	return visible;
    }

    /**
     * This method will get the descrption text saying that there is no
     * image in this component.
     * @return the description text.
     */
    public String getImage()
    {
	return image;
    }

    /**
     * This method will get the supposed filename of the image that is in this component should use if 
     * we want to save it to a jpeg file.
     * @return the image file name.
     */
    public String getImageFileName()
    {
	return img;
    }

    /**
     * This method will get the string representation of the image that is in this component.
     * @return the image.
     */
    public String getImageFile()
    {
	return imgFile;
    }

    /**
     * This method will set the index value.
     * (Precondition: (num > 0))
     * @param num the new index value.
     */
    public void startContent (int num)
    {
	index = num;
    }
    
    /**
     * This method will add the UserComponent to the content array list.
     * @param comp the content of the component.
     */
    public void saveContent (UserComponent comp)
    {
	content.add(comp);
    }

    /**
     * This method will set the data member value to the text passed
     * to this method depending on the index value.
     * @param text the value to be set to the data member.
     */
    public void saveContent (String text)
    {
	if (text == null)
	    text = " ";

	switch (index)
	    {
	    case 1 : type = text; break;
	    case 2 : title = text; break;
	    case 3 : content.add(text); break;
	    case 4 : selected = text;break;
            case 5 : visible = text;break;
	    case 6 : image = text; break;
	    case 7 : tooltip = text;break;
            }
    }

    /**
     * This method will encode the ImageIcon into its String representation using Based64encoder and
     * it will also set the image's filename,height and width.
     * @param image is the image to be converted.
     * @param filename is the file name of the image.
     */
    public void saveImage (ImageIcon image,String filename) 
    {
	/*int w;
	w = image.getIconWidth();
	int h;
	h = image.getIconHeight();

	height = "" + h;
	width = "" + w;
	img = filename;
	
	if (w > 50)
	    w = w - 50;
	
	if (h > 50)
	    h = h - 50;
	
	ImageIcon icon;
	icon = new ImageIcon(image.getImage().getScaledInstance(w,h,Image.SCALE_SMOOTH));
   
	if ( w < 0 || h < 0)
	    {
		System.out.println(img);
		return;
	    }

	BufferedImage bi;
	bi =new BufferedImage(w,h, BufferedImage.TYPE_INT_RGB);
	Graphics2D big;
	big = bi.createGraphics();
	
	big.drawImage(icon.getImage(),0,0,null);
	
	try	
	    {
		ByteArrayOutputStream stream;
		stream = new ByteArrayOutputStream();
		ImageIO.write(bi,"jpeg",stream);
		byte[] bytes;
		bytes = stream.toByteArray();
		imgFile = Base64.encodeBytes(bytes);
	    }
	catch (IOException exp) {}
	
	big.dispose();
	image = null;
	bi = null;
	icon = null;*/
    }

    /**
     * This method will encode the Icon into its String representation using Based64encoder and
     * it will also set the image's filename,height and width.
     * @param image is the image to be converted.
     * @param filename is the file name of the image
     */
    public void saveImage (Icon image,String filename)
    {
	if (image == null)
	    System.out.println("null image??");
	else if (image instanceof ImageIcon)
	    saveImage((ImageIcon)image, filename);
	else
	    System.out.println("Its a icon");
	    //saveIcon (image,filename);
    }

    /**
     * This method will encode the Icon into its String representation using Based64encoder and
     * it will also set the image's filename,height and width.
     * @param image is the image to be converted.
     * @param filename is the file name of the image.
     */
    private void saveIcon (Icon image,String filename)
    {
	JFrame lbl = new JFrame();
	lbl.setVisible(false);

	ImageIcon icon;
	Image img;
	img = iconToImage(image,lbl);
	icon = new ImageIcon(img);
	lbl.dispose();
	lbl = null;
	saveImage(icon,filename);
    }

    /**
     * This method will save to content of this UserComponent to an xml file.
     * The xml file should already have an opening tag and closing tag first before calling
     * this method or it wont make a valid xml file.
     * @param sx this is the xml file where we want to save it.
     */
    public void sendingXML (SaveToXML sx)
    {
	if (type != null)
	    {
		sx.startContent(1);
		sx.saveContent(type);
		sx.closeContent(1);
	    }

	if (title != null)
	    {
		sx.startContent(2);
		sx.saveContent(title);
		sx.closeContent(2);
	    }

	if (content != null)
	    {
		sx.startContent(3);
		for (int j = 0 ; j < content.size() ; j++)
		    {
			if (content.get(j) instanceof String)
			    sx.saveContent((String) content.get(j));
			else
			    {
				sx.startContent(0);
				UserComponent cmp;
				cmp = (UserComponent) content.get(j);
				cmp.sendingXML(sx);
				sx.closeContent(0);
			    }
		    }
		sx.closeContent(3);
	    }

	if (selected != null)
	    {
		sx.startContent(4);
		sx.saveContent(selected);
		sx.closeContent(4);
	    }

	if (visible != null)
	    {
		sx.startContent(5);
		sx.saveContent(visible);
		sx.closeContent(5);
	    }

	if (img != null)
	    {
		sx.startContent(6);
		sx.saveImage(imgFile,img,width,height);
		sx.closeContent(6);
	    }
	else
	    {
		if (image != null)
		    {
			sx.startContent(11);
			sx.saveContent(image);
			sx.closeContent(11);
		    }
	    }

	if (tooltip != null)
	    {
		sx.startContent(12);
		sx.saveContent(tooltip);
		sx.closeContent(12);
	    }
    }

    /**
     * This method will convert an Icon to a BufferedImage.
     * @param icon icon to be converted.
     * @param targetComponent is the component where we want to draw this BufferedImage.
     * @return is the BufferedImage of the icon.
     */
    public BufferedImage iconToImage(Icon icon, Component targetComponent) 
    {
	int w,h;
	w = icon.getIconWidth();
	h = icon.getIconHeight();
	GraphicsConfiguration gc;
	gc = targetComponent.getGraphicsConfiguration();
	BufferedImage image;
	image = gc.createCompatibleImage(w, h,Transparency.TRANSLUCENT);
	
	Graphics2D g;
	g = image.createGraphics();
	icon.paintIcon(targetComponent,g,0,0);
	g.dispose();
	return image;
    }
}













