/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.cdm;

/**************************************************************************************
 * Title:        Gatherer
 * Description:  The Gatherer: a tool for gathering and enriching a digital collection.
 * Company:      The University of Waikato
 * Written:      20/05/02
 * Revised:      03/10/02 - Commented
 **************************************************************************************/
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;

/** This class extends the functionality of the DefaultListModel to include simple methods for refreshing the contents of this model if one of its elements changes.
 * @author John Thompson, Greenstone Digital Library, University of Waikato
 * @version 2.3
 */
public class DynamicListModel
    extends DefaultListModel
    implements ComboBoxModel {

    private boolean auto_order = false;

    private Object object = null;

    public void addElement(Object element) {
	if(auto_order) {
	    // Insert the object in its alphabetically correct place.
	    int position = 0;
	    boolean found = false;
	    while(!found && position < size()) {
		///ystem.err.print("Compare " + element.toString() + " to " + get(position).toString() + ": ");
		int order = element.toString().compareTo(get(position).toString());
		if(order < 0) {
		    add(position, element);
		    found = true;
		    ///ystem.err.println("Greater than. Insert");
		}
		else if(order == 0) {
		    found = true;
		    ///ystem.err.println("Equal. End.");
		}
		else {
		    position++;
		    ///ystem.err.println("Less than. Carry on.");
		}
	    }
	    if(!found) {
		super.addElement(element);
		///ystem.err.println("Out of elements. Insert");
	    }
	}
	else {
	    super.addElement(element);
	}
    }

    /* private DynamicListModel shallowCopy() {
	DynamicListModel copy = new DynamicListModel();
	copy.setAutoOrder(auto_order);
	for(int i = 0; i < size(); i++) {
	    copy.addElement(get(i));
	}
	return copy;
	} */

    public Object getSelectedItem() {
	///ystem.err.println("Get item: " + object);
	return object;
    }
    /** Notify all controls that are based on this list model that its contents have changed, and they should repaint themselves. */
    public void refresh() {
	fireContentsChanged(this, 0, size());
    }

    public void setAutoOrder(boolean auto_order) {
	this.auto_order = auto_order;
    }

    public void setSelectedItem(Object object) {
	///ystem.err.println("Set item: " + object);
	this.object = object;
    }
}
