@echo off

set MAKE=nmake
set MAKE_OPTIONS=/f

if "%DEBUG%" == "" (
  set MAKE_VARS=DEBUG=0
) else (
  set MAKE_VARS=DEBUG=%DEBUG%
)

:: ENABLE_MG/MGPP/LUCENE are guaranteed to be set to either 1 or 0 at this point
set MAKE_VARS=%MAKE_VARS% ENABLE_MG=%ENABLE_MG%
set MAKE_VARS=%MAKE_VARS% ENABLE_MGPP=%ENABLE_MGPP%
set MAKE_VARS=%MAKE_VARS% ENABLE_LUCENE=%ENABLE_LUCENE%

if "%ENABLE_MG%" == "1" if not exist mg (
  echo ***** Folder mg does not exist, cannot ENABLE_MG.
  goto failed
)

if "%ENABLE_MGPP%" == "1" if not exist mgpp (
  echo ***** Folder mgpp does not exist, cannot ENABLE_MGPP.
  goto failed
)

if "%ENABLE_LUCENE%" == "1" if not exist lucene-gs (
  echo ***** Folder lucene-gs does not exist, cannot ENABLE_LUCENE.
  goto failed
)

if ""%1"" == """" goto all
if ""%1"" == ""all"" goto go
if ""%1"" == ""install"" goto go
if ""%1"" == ""clean"" goto clean

:unknown
	echo Error: Unrecognized argument %1.
	goto failed

:clean
	del bin\*

:go
	if ""%2"" == ""javaonly"" goto java
	if ""%2"" == ""nojava"" goto nojava
	if ""%2"" == ""without-jni"" goto without-jni

:all
:with-jni
	if NOT EXIST "bin" mkdir bin

	cd packages\windows\iconv
	set ICONVZIP=iconv-VS14-PLUS.zip
	if %VISUAL_STUDIO_MAJORVERSION% LSS 14 set ICONVZIP=iconv-PRE-VS14.zip
	echo Selected iconvzip: %ICONVZIP%
	if NOT EXIST "iconv" unzip "%ICONVZIP%"
	cd iconv
	%MAKE% %MAKE_OPTIONS% Makefile.msvc %1 %MAKE_VARS% NO_NLS=1
	cd ..\..\..\..

	cd packages\unac
	if NOT EXIST "iconv.h" if EXIST "iconv.h.win" copy "%CD%\iconv.h.win" iconv.h
	%MAKE% %MAKE_OPTIONS% win32.mak %1 %MAKE_VARS% 
	cd ..\..

	if "%ENABLE_MG%" == "1" (
	  cd mg
	  call winMake.bat %1
	  cd ..
	)

	if "%ENABLE_MGPP%" == "1" (
	  cd mgpp
	  call winMake.bat %1 
	  cd ..
	)

	if "%ENABLE_LUCENE%" == "1" (
	  cd lucene-gs
	  call winMake.bat %1
	  cd ..
	)

	if ""%1"" == ""clean"" goto clean2 
	goto done

:: Need another clean because a pre-all clean command sent to iconv regenerates some lib 
:: and object files. So we delete these after it's finished processing the clean command
:clean2	
	for %%I in (lib srclib libcharset\lib) do if exist packages\windows\iconv\iconv\%%I\^*.obj del packages\windows\iconv\iconv\%%I\*.obj;
	for %%I in (lib srclib libcharset\lib) do if exist packages\windows\iconv\iconv\%%I\^*.lib del packages\windows\iconv\iconv\%%I\*.lib;
	goto done

:java
	if "%ENABLE_MG%" == "1" (
	  cd mg
	  call winMake.bat %1 javaonly
	  cd ..
	)

	if "%ENABLE_MGPP%" == "1" (
	  cd mgpp
	  call winMake.bat %1 javaonly
	  cd ..
	)
	
	if "%ENABLE_LUCENE%" == "1" (
	  cd lucene-gs
	  call winMake.bat %1 
	  cd ..
	)
	goto done

:nojava
	cd packages\windows\iconv\iconv
	%MAKE% %MAKE_OPTIONS% Makefile.msvc %MAKE_VARS% NO_NLS=1
	cd ..\..\..\..

	cd packages\unac
	if NOT EXIST "iconv.h" if EXIST "iconv.h.win" copy "%CD%\iconv.h.win" iconv.h
	%MAKE% %MAKE_OPTIONS% win32.mak %1 %MAKE_VARS% 
	cd ..\..

	if "%ENABLE_MG%" == "1" (
	  cd mg
	  call winMake.bat %1 nojava
	  cd ..
	)
	
	if "%ENABLE_MGPP%" == "1" (
	  cd mgpp
	  call winMake.bat %1 nojava
	  cd ..
	)
	goto done

:without-jni
	if NOT EXIST "bin" mkdir bin

	cd packages\windows\iconv\iconv
	%MAKE% %MAKE_OPTIONS% Makefile.msvc %MAKE_VARS% NO_NLS=1
	cd ..\..\..\..

	cd packages\unac
	if NOT EXIST "iconv.h" if EXIST "iconv.h.win" copy "%CD%\iconv.h.win" iconv.h
	%MAKE% %MAKE_OPTIONS% win32.mak %1 %MAKE_VARS% 
	cd ..\..

	if "%ENABLE_MG%" == "1" (
	  cd mg
	  call winMake.bat %1 nojava
	  cd ..
	)

	if "%ENABLE_MGPP%" == "1" (
	  cd mgpp
	  call winMake.bat %1 nojava
	  cd ..
	)

	if "%ENABLE_LUCENE%" == "1" (	
	  cd lucene-gs
	  call winMake.bat %1
	  cd ..
	)
	goto done


:failed
echo ***** Compilation terminated with failure in %~dp0%0
exit /b 1

:done
