/**********************************************************************
 *
 * IsisTypes.h
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

///////////////////////////////////////////////////////////////////////////////
//  isisType.h 


#ifndef __ISIS_TYPE_H__
#define __ISIS_TYPE_H__

#include "DLLCode.h"

#ifdef __USE_ISOC99 // get double_t type from math.h
#include <math.h>
#endif
namespace isis
{


// ----------------------------------------
// Type definitions common to all platforms
// ----------------------------------------
typedef char            int8_t;    // 8-bit signed value
typedef unsigned char   uint8_t;   // 8-bit unsigned value
typedef int             int32_t;   // Word size (4 bytes)
typedef unsigned int    uint32_t;  // Unsigned word size (4 bytes)
typedef mg_s_long       long32_t;  // Long word (4 bytes)
typedef mg_u_long       ulong32_t; // Unsigned long word (4 bytes)
typedef short           int16_t;   // short word (2 bytes)
typedef unsigned short  uint16_t;  // Unsigned short word (2 bytes)
#ifndef __USE_ISOC99 // gnu lic math.h has a double_t
typedef double          double_t;  // Double precision floating point (8 bytes)
#endif


// --------------------------------------------------------------
// Platform/compiler specific INT64 types
// --------------------------------------------------------------
#if defined (__64_BIT_FILE_SYSTEM__)
#include "TYPES64.H" 
#endif
} // namespace isis

namespace isis
{
    typedef  isis::int16_t  db_t;
    typedef  isis::int16_t  server_t;
    typedef  isis::int16_t  IsisClientId;
    typedef  isis::uint32_t mfn_t;
}
// typedef char            int8_t;    // 8-bit signed value
typedef unsigned char   uint8_t;   // 8-bit unsigned value
typedef int             int32_t;   // Word size (4 bytes)
typedef unsigned int    uint32_t;  // Unsigned word size (4 bytes)
typedef mg_s_long       long32_t;  // Long word (4 bytes)
typedef mg_u_long       ulong32_t; // Unsigned long word (4 bytes)
typedef short           int16_t;   // short word (2 bytes)
typedef unsigned short  uint16_t;  // Unsigned short word (2 bytes)
#ifndef __USE_ISOC99 // gnu lic math.h has a double_t
typedef double     double_t;  // Double precision floating point (8 bytes) // ****
#endif

typedef uint32_t        xrf_page_no_t;

typedef uint32_t        mst_page_no_t;
typedef uint16_t        mst_offset_t;
typedef uint32_t        mfn_t;
typedef uint32_t        mfrl_t;

typedef isis::uint32_t file_size_t;


#endif // __ISIS_TYPE_H__



