/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.lzw;

import com.sun.jimi.core.util.lzw.BitInput;
import com.sun.jimi.core.util.lzw.LZWDecompressionStringTable;
import java.io.IOException;
import java.io.InputStream;

public final class LZWDecompressor {
    private int f1;
    private int f2;
    protected BitInput input_;
    protected int initialCodeSize_;
    protected int codeSize_;
    protected int limit_;
    protected boolean tiff_;
    protected LZWDecompressionStringTable table_;
    protected int count_;
    protected int oldCode_;
    protected byte oldCodeFirstChar_;
    protected int leftOverCode_;
    protected int leftOverIndex_;
    protected int leftOverOldCode_;
    protected boolean isLeftOver_;

    public void setInputStream(InputStream inputStream) {
        this.input_ = new BitInput(inputStream, !this.tiff_);
        this.clearTable();
        this.resetCodeSize();
    }

    public int decompress(byte[] byArray) throws IOException {
        int n = this.writeLeftOver(byArray);
        if (this.isLeftOver_) {
            return byArray.length;
        }
        int n2 = 0 + n;
        while (n2 < byArray.length) {
            int n3;
            int n4 = this.getNextCode();
            if (n4 == this.f2) break;
            if (n4 == this.f1) {
                this.clearTable();
                n4 = this.getNextCode();
                if (n4 == this.f2) break;
                byArray[n2++] = (byte)n4;
                this.oldCode_ = n4;
                this.oldCodeFirstChar_ = (byte)n4;
                continue;
            }
            if (this.table_.contains(n4)) {
                n3 = this.writeCode(byArray, n2, n4);
                if (this.table_.addCharString(this.oldCode_, byArray[n2]) == this.limit_) {
                    this.incrementCodeSize();
                }
                this.oldCode_ = n4;
                this.oldCodeFirstChar_ = byArray[n2];
                if (n3 < 0) {
                    return byArray.length;
                }
                n2 += n3;
                continue;
            }
            n3 = this.table_.addCharString(this.oldCode_, this.oldCodeFirstChar_);
            int n5 = this.writeCode(byArray, n2, n3);
            this.oldCode_ = n4;
            this.oldCodeFirstChar_ = byArray[n2];
            if (n3 == this.limit_) {
                this.incrementCodeSize();
            }
            if (n5 < 0) {
                return byArray.length;
            }
            n2 += n5;
        }
        return n2;
    }

    protected int writeCode(byte[] byArray, int n, int n2) {
        return this.writeCode(byArray, n, n2, 0);
    }

    protected int writeCode(byte[] byArray, int n, int n2, int n3) {
        int n4 = this.table_.expandCode(byArray, n, n2, n3);
        if (n4 < 0) {
            this.leftOverCode_ = n2;
            this.leftOverOldCode_ = this.oldCode_;
            this.isLeftOver_ = true;
            this.leftOverIndex_ = -n4;
        } else {
            this.isLeftOver_ = false;
        }
        return n4;
    }

    protected int writeLeftOver(byte[] byArray) {
        if (!this.isLeftOver_) {
            return 0;
        }
        return this.writeCode(byArray, 0, this.leftOverCode_, this.leftOverIndex_);
    }

    protected int getNextCode() throws IOException {
        return this.input_.read();
    }

    protected void clearTable() {
        this.table_.clearTable();
        this.resetCodeSize();
    }

    protected void resetCodeSize() {
        this.count_ = 0;
        this.codeSize_ = this.initialCodeSize_;
        this.incrementCodeSize();
    }

    protected void incrementCodeSize() {
        if (this.codeSize_ != 12) {
            ++this.codeSize_;
            this.limit_ = (1 << this.codeSize_) - 1;
            if (this.tiff_) {
                --this.limit_;
            }
            this.input_.setNumBits(this.codeSize_);
        }
    }

    public void gifFinishBlocks() throws IOException {
        if (!this.tiff_) {
            this.input_.gifFinishBlocks();
        }
    }

    public LZWDecompressor(InputStream inputStream, int n, boolean bl) {
        this.initialCodeSize_ = n;
        this.tiff_ = bl;
        this.f1 = 1 << n;
        this.f2 = (1 << n) + 1;
        this.table_ = new LZWDecompressionStringTable(n);
        this.setInputStream(inputStream);
        this.clearTable();
    }
}

