/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class PCXImage {
    private PCXHeader f1;
    private byte[] f2;
    private int f3;
    private int f4;
    private int f5;
    private int f6 = 0;
    private int f7 = 0;

    public void get16ColorPCX(LEDataInputStream lEDataInputStream) throws IOException {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = (this.f3 << 3) / this.f4;
        if (n > n3) {
            n = n3;
        }
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[this.f5 * this.f3];
        int n4 = 0;
        while (n4 < n2) {
            this.getPCXRow(lEDataInputStream, byArray2, this.f5 * this.f3);
            if (this.f5 == 1) {
                this.pcxUnpackPixels(byArray, byArray2);
            } else {
                this.pcxPlanesToPixels(byArray, byArray2);
            }
            int n5 = 0;
            while (n5 < n) {
                this.f2[n4 * this.getWidth() + n5] = byArray[n5];
                ++n5;
            }
            ++n4;
        }
    }

    public void getPCXRow(LEDataInputStream lEDataInputStream, byte[] byArray, int n) {
        try {
            this.f6 = 0;
            int n2 = 0;
            while (n2 < n) {
                if (this.f6 > 0) {
                    byArray[n2++] = (byte)this.f7;
                    --this.f6;
                    continue;
                }
                this.f7 = lEDataInputStream.readByte();
                if ((this.f7 & 0xC0) != 192) {
                    byArray[n2++] = (byte)this.f7;
                    continue;
                }
                this.f6 = this.f7 & 0x3F;
                this.f7 = lEDataInputStream.readByte();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void pcxUnpackPixels(byte[] byArray, byte[] byArray2) {
        int n = this.f3;
        int n2 = 0;
        int n3 = 0;
        if (this.f4 == 8) {
            while (--n >= 0) {
                byArray[n2++] = byArray2[n3++];
            }
            return;
        }
        if (this.f4 == 4) {
            while (--n >= 0) {
                byte by = byArray2[n3++];
                byArray[n2++] = (byte)(by >> 4 & 0xF);
                byArray[n2++] = (byte)(by & 0xF);
            }
            return;
        }
        if (this.f4 == 2) {
            while (--n >= 0) {
                byte by = byArray2[n3++];
                byArray[n2++] = (byte)(by >> 6 & 3);
                byArray[n2++] = (byte)(by >> 4 & 3);
                byArray[n2++] = (byte)(by >> 2 & 3);
                byArray[n2++] = (byte)(by & 3);
            }
            return;
        }
        if (this.f4 == 1) {
            while (--n >= 0) {
                byte by = byArray2[n3++];
                byArray[n2++] = (byte)(by >> 7 & 1);
                byArray[n2++] = (byte)(by >> 6 & 1);
                byArray[n2++] = (byte)(by >> 5 & 1);
                byArray[n2++] = (byte)(by >> 4 & 1);
                byArray[n2++] = (byte)(by >> 3 & 1);
                byArray[n2++] = (byte)(by >> 2 & 1);
                byArray[n2++] = (byte)(by >> 1 & 1);
                byArray[n2++] = (byte)(by & 1);
            }
        }
    }

    public void pcxPlanesToPixels(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.f5) {
            int n3 = 0;
            int n4 = 1 << n2;
            int n5 = 0;
            while (n5 < this.f3) {
                byte by = byArray2[n++];
                int n6 = 128;
                while (n6 != 0) {
                    if ((by & n6) > 0) {
                        int n7 = n3;
                        byArray[n7] = (byte)(byArray[n7] | n4);
                    }
                    n6 >>= 1;
                    ++n3;
                }
                ++n5;
            }
            ++n2;
        }
    }

    public void get256ColorPCX(LEDataInputStream lEDataInputStream) {
        try {
            int n = 0;
            while (n < this.getHeight()) {
                int n2 = 0;
                while (n2 < this.f3) {
                    byte by = lEDataInputStream.readByte();
                    if ((by & 0xC0) == 192) {
                        byte by2 = lEDataInputStream.readByte();
                        int n3 = by & 0x3F;
                        int n4 = 0;
                        while (n4 < n3) {
                            this.f2[n2 + n * this.f3] = by2;
                            ++n2;
                            ++n4;
                        }
                        continue;
                    }
                    this.f2[n2 + n * this.f3] = by;
                    ++n2;
                }
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void getTrueColorPCX(LEDataInputStream lEDataInputStream) {
    }

    public int getBytesPerLine() {
        return this.f3;
    }

    public byte[] getImageData() {
        return this.f2;
    }

    public int getBitCount() {
        return this.f1.getDepth();
    }

    public int getWidth() {
        return this.f1.getWidth();
    }

    public int getHeight() {
        return this.f1.getHeight();
    }

    public PCXImage(LEDataInputStream lEDataInputStream, PCXHeader pCXHeader) throws IOException {
        this.f1 = pCXHeader;
        this.f5 = pCXHeader.getPlanes();
        this.f3 = pCXHeader.getBytesPerLine();
        this.f4 = this.getBitCount();
        this.f2 = new byte[this.getHeight() * this.getWidth()];
        switch (this.f4) {
            case 1: {
                if (this.f5 < 1 || this.f5 > 4) break;
                this.get16ColorPCX(lEDataInputStream);
                return;
            }
            case 2: 
            case 4: {
                if (this.f5 == 1) {
                    this.get16ColorPCX(lEDataInputStream);
                }
            }
            case 8: {
                switch (this.f5) {
                    case 1: {
                        this.get256ColorPCX(lEDataInputStream);
                        return;
                    }
                    case 3: 
                    case 4: {
                        this.getTrueColorPCX(lEDataInputStream);
                    }
                }
            }
        }
    }
}

