/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class BMPFileHeader {
    static final short FILETYPE_BM = 19778;
    static final short VERSION_2X = 12;
    static final short VERSION_3X = 40;
    static final short VERSION_4X = 108;
    LEDataInputStream in_;
    short fileType = (short)19778;
    int fileSize;
    short reserved1 = 0;
    short reserved2 = 0;
    int bitmapOffset;
    int size;
    int width;
    int height;
    int planes;
    int bitsPerPixel;
    int compression;
    int sizeOfBitmap;
    int horzResolution;
    int vertResolution;
    int colorsUsed;
    int colorsImportant;
    int redMask;
    int greenMask;
    int blueMask;
    int alphaMask;
    int csType;
    int redX;
    int redY;
    int redZ;
    int greenX;
    int greenY;
    int greenZ;
    int blueX;
    int blueY;
    int blueZ;
    int gammaRed;
    int gammaGreen;
    int gammaBlue;
    boolean topDown;
    int actualSizeOfBitmap;
    int scanLineSize;
    int actualColorsUsed;
    int noOfPixels;
    int bmpVersion;

    void readVersion2x() throws IOException {
        this.width = this.in_.readShort();
        this.height = this.in_.readShort();
        this.planes = this.in_.readUnsignedShort();
        this.bitsPerPixel = this.in_.readUnsignedShort();
        this.compression = 0;
        this.bmpVersion = 2;
        this.topDown = this.height < 0;
    }

    void readVersion3x() throws IOException {
        this.width = this.in_.readInt();
        this.height = this.in_.readInt();
        this.planes = this.in_.readUnsignedShort();
        this.bitsPerPixel = this.in_.readUnsignedShort();
        this.compression = this.in_.readInt();
        this.sizeOfBitmap = this.in_.readInt();
        this.horzResolution = this.in_.readInt();
        this.vertResolution = this.in_.readInt();
        this.colorsUsed = this.in_.readInt();
        this.colorsImportant = this.in_.readInt();
        if (this.compression == 3) {
            this.redMask = this.in_.readInt();
            this.greenMask = this.in_.readInt();
            this.blueMask = this.in_.readInt();
        } else if (this.bitsPerPixel == 16) {
            this.redMask = 31744;
            this.greenMask = 992;
            this.blueMask = 31;
            this.alphaMask = 0;
        }
        this.bmpVersion = 3;
        this.topDown = this.height < 0;
    }

    void readVersion4x() throws IOException {
        this.width = this.in_.readInt();
        this.height = this.in_.readInt();
        this.planes = this.in_.readUnsignedShort();
        this.bitsPerPixel = this.in_.readUnsignedShort();
        this.compression = this.in_.readInt();
        this.sizeOfBitmap = this.in_.readInt();
        this.horzResolution = this.in_.readInt();
        this.vertResolution = this.in_.readInt();
        this.colorsUsed = this.in_.readInt();
        this.colorsImportant = this.in_.readInt();
        this.redMask = this.in_.readInt();
        this.greenMask = this.in_.readInt();
        this.blueMask = this.in_.readInt();
        this.alphaMask = this.in_.readInt();
        this.csType = this.in_.readInt();
        this.redX = this.in_.readInt();
        this.redY = this.in_.readInt();
        this.redZ = this.in_.readInt();
        this.greenX = this.in_.readInt();
        this.greenY = this.in_.readInt();
        this.greenZ = this.in_.readInt();
        this.blueX = this.in_.readInt();
        this.blueY = this.in_.readInt();
        this.blueZ = this.in_.readInt();
        this.gammaRed = this.in_.readInt();
        this.gammaGreen = this.in_.readInt();
        this.gammaBlue = this.in_.readInt();
        this.bmpVersion = 4;
        this.topDown = this.height < 0;
    }

    public String toString() {
        return "BMP Header " + " size=" + this.size + " width=" + this.width + " height=" + this.height + " planes=" + this.planes + " bitsPerPixel=" + this.bitsPerPixel + " compression=" + this.compression + " sizeOfBitmap=" + this.sizeOfBitmap + " actualSizeOfBitmap=" + this.actualSizeOfBitmap + " scanLineSize=" + this.scanLineSize + " horzResolution=" + this.horzResolution + " vertResolution=" + this.vertResolution + " colorsUsed=" + this.colorsUsed + " colorsImportant=" + this.colorsImportant;
    }

    public BMPFileHeader(LEDataInputStream lEDataInputStream) throws IOException, JimiException {
        this.in_ = lEDataInputStream;
        this.fileType = this.in_.readShort();
        if (this.fileType != 19778) {
            throw new JimiException("Not a BMP file");
        }
        this.fileSize = this.in_.readInt();
        this.reserved1 = this.in_.readShort();
        this.reserved2 = this.in_.readShort();
        this.bitmapOffset = this.in_.readInt();
        this.size = this.in_.readInt();
        if (this.size == 12) {
            this.readVersion2x();
        } else if (this.size == 40) {
            this.readVersion3x();
        } else if (this.size == 108) {
            this.readVersion4x();
        } else {
            throw new JimiException("Unsupported BMP version " + this.size);
        }
        if (this.topDown) {
            throw new JimiException("Unsupported topdown BMPs");
        }
        this.noOfPixels = this.width * this.height;
        this.scanLineSize = this.width * this.bitsPerPixel + 31 >> 5 << 2;
        this.actualSizeOfBitmap = this.sizeOfBitmap != 0 ? this.sizeOfBitmap : this.scanLineSize * this.height;
        if (this.colorsUsed != 0) {
            this.actualColorsUsed = this.colorsUsed;
            return;
        }
        if (this.bitsPerPixel < 16) {
            this.actualColorsUsed = 1 << this.bitsPerPixel;
            return;
        }
        this.actualColorsUsed = 0;
    }
}

