/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.EventQueue;
import de.qfs.lib.log.Logger;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class SwingUtil {
    public static final int NO_EVENTS = 0;
    public static final int ALL_EVENTS = -1;
    public static final int PAINT_EVENTS = 1;
    public static final int INPUT_EVENTS = 2;
    public static final int OTHER_EVENTS = -4;
    private static Logger logger = new Logger(class$de$qfs$lib$gui$SwingUtil == null ? (class$de$qfs$lib$gui$SwingUtil = SwingUtil.class$("de.qfs.lib.gui.SwingUtil")) : class$de$qfs$lib$gui$SwingUtil);
    private static Keymap defaultKeymap;
    private static int doneID;
    static /* synthetic */ Class class$de$qfs$lib$gui$SwingUtil;

    public static boolean invokeAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getTargetException();
                }
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public static Object withEvents(UnsafeRunnable unsafeRunnable, boolean bl) throws InvocationTargetException {
        if (bl) {
            return SwingUtil.withEvents(unsafeRunnable, -3, 2);
        }
        return SwingUtil.withEvents(unsafeRunnable, -1, 0);
    }

    public static Object withEvents(final UnsafeRunnable unsafeRunnable, int n, int n2) throws InvocationTargetException {
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "withEvents(UnsafeRunnable,int,int)", SwingUtil.logger.level < 8 ? "" : "runnable: " + unsafeRunnable + ", " + "delay: " + n + ", " + "discard: " + n2);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                return unsafeRunnable.run();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                return new InvocationTargetException(exception);
            }
        }
        final Exception[] exceptionArray = new Exception[1];
        final Object[] objectArray = new Object[1];
        final int n3 = doneID++;
        new Thread(){

            public void run() {
                try {
                    objectArray[0] = unsafeRunnable.run();
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                }
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new DoneEvent(n3));
            }
        }.start();
        SwingUtil.poll(n, n2, n3);
        if (exceptionArray[0] != null) {
            if (exceptionArray[0] instanceof RuntimeException) {
                throw (RuntimeException)exceptionArray[0];
            }
            throw new InvocationTargetException(exceptionArray[0]);
        }
        return objectArray[0];
    }

    private static void poll(int n, int n2, int n3) {
        AWTEvent aWTEvent;
        Object object;
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "poll(int,int,int)", SwingUtil.logger.level < 8 ? "" : "delay: " + n + ", " + "discard: " + n2 + ", " + "id: " + n3);
        }
        java.awt.EventQueue eventQueue = EventQueue.instance();
        if (SwingUtil.logger.level >= 9) {
            logger.log(9, "poll(int,int,int)", "queue: " + eventQueue);
        }
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!bl) {
            try {
                object = eventQueue.getNextEvent();
                aWTEvent = object;
                if (object instanceof EventQueue.WrapperEvent) {
                    object = ((EventQueue.WrapperEvent)object).getWrappedEvent();
                }
                if (SwingUtil.logger.level >= 9) {
                    logger.log(9, "poll(int,int,int)", "event: " + object);
                }
                if (object instanceof DoneEvent) {
                    if (((DoneEvent)object).id == n3) {
                        bl = true;
                        continue;
                    }
                    arrayList.add(object);
                    continue;
                }
                if (object instanceof InputEvent) {
                    if ((n2 & 2) != 0) {
                        ((InputEvent)object).consume();
                        continue;
                    }
                    if ((n & 2) != 0) {
                        arrayList.add(object);
                        continue;
                    }
                    try {
                        SwingUtil.doDispatch(aWTEvent, (AWTEvent)object);
                    }
                    catch (RuntimeException runtimeException) {
                        if (SwingUtil.logger.level < 1) continue;
                        logger.log("poll(int,int,int)", runtimeException);
                    }
                    continue;
                }
                if (object instanceof PaintEvent) {
                    if ((n2 & 1) != 0) continue;
                    if ((n & 1) != 0) {
                        arrayList.add(object);
                        continue;
                    }
                    try {
                        SwingUtil.doDispatch(aWTEvent, (AWTEvent)object);
                    }
                    catch (RuntimeException runtimeException) {
                        if (SwingUtil.logger.level < 1) continue;
                        logger.log("poll(int,int,int)", runtimeException);
                    }
                    continue;
                }
                if ((n2 & 0xFFFFFFFC) == -4) continue;
                if ((n & 0xFFFFFFFC) == -4) {
                    arrayList.add(object);
                    continue;
                }
                try {
                    SwingUtil.doDispatch(aWTEvent, (AWTEvent)object);
                }
                catch (RuntimeException runtimeException) {
                    if (SwingUtil.logger.level < 1) continue;
                    logger.log("poll(int,int,int)", runtimeException);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (arrayList.size() > 0) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                aWTEvent = (AWTEvent)object.next();
                if (SwingUtil.logger.level >= 9) {
                    logger.log(9, "poll(int,int,int)", "pevent: " + aWTEvent);
                }
                eventQueue.postEvent(aWTEvent);
            }
        }
    }

    private static void doDispatch(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "doDispatch(AWTEvent,AWTEvent)", SwingUtil.logger.level < 8 ? "" : "orig: " + aWTEvent + ", " + "event: " + aWTEvent2);
        }
        if (aWTEvent instanceof EventQueue.WrapperEvent) {
            ((EventQueue.WrapperEvent)aWTEvent).dispatch();
        } else if (EventQueue.isInstalled()) {
            ((EventQueue)EventQueue.instance()).dispatchEvent(aWTEvent2);
        } else {
            Object object = aWTEvent2.getSource();
            if (aWTEvent2 instanceof ActiveEvent) {
                ((ActiveEvent)((Object)aWTEvent2)).dispatch();
            } else if (object instanceof Component) {
                ((Component)object).dispatchEvent(aWTEvent2);
            } else if (object instanceof MenuComponent) {
                ((MenuComponent)object).dispatchEvent(aWTEvent2);
            }
        }
    }

    public static void prepareKeymaps() {
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "prepareKeymaps()", "");
        }
        if (defaultKeymap == null) {
            JTextField jTextField = new JTextField();
            Keymap keymap = jTextField.getKeymap();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            Action action = keymap.getAction(keyStroke);
            keymap.removeKeyStrokeBinding(keyStroke);
            new JPasswordField().getKeymap().removeKeyStrokeBinding(keyStroke);
            defaultKeymap = JTextField.addKeymap("old", keymap);
            defaultKeymap.addActionForKeyStroke(keyStroke, action);
        }
    }

    public static void setDefaultEnterBinding(JTextComponent jTextComponent) {
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "setDefaultEnterBinding(JTextComponent)", SwingUtil.logger.level < 8 ? "" : "text: " + jTextComponent);
        }
        jTextComponent.setKeymap(defaultKeymap);
    }

    public static void closeOnEscape(final Window window) {
        window.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && keyEvent.getModifiers() == 0) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(window, 201));
                    keyEvent.consume();
                }
            }
        });
    }

    public static void constrainScroll(JScrollPane jScrollPane) {
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "constrainScroll(JScrollPane)", SwingUtil.logger.level < 8 ? "" : "scrollPane: " + jScrollPane);
        }
        ConstrainedViewport constrainedViewport = new ConstrainedViewport();
        JViewport jViewport = jScrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        constrainedViewport.setView(jViewport.getView());
        constrainedViewport.setViewPosition(point);
        jScrollPane.setViewport(constrainedViewport);
    }

    public static void showPopup(JPopupMenu jPopupMenu, Component component, int n, int n2, boolean bl) {
        Dimension dimension;
        Point point;
        Window window;
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "showPopup(JPopupMenu,Component,int,int,boolean)", SwingUtil.logger.level < 8 ? "" : "menu: " + jPopupMenu + ", " + "parent: " + component + ", " + "x: " + n + ", " + "y: " + n2 + ", " + "constrain: " + bl);
        }
        if (component == null) {
            jPopupMenu.show(component, n, n2);
            return;
        }
        jPopupMenu.pack();
        Dimension dimension2 = jPopupMenu.getPreferredSize();
        if (component instanceof Window) {
            window = (Window)component;
            point = new Point(n, n2);
        } else {
            window = SwingUtilities.windowForComponent(component);
            point = SwingUtilities.convertPoint(component, n, n2, window);
            n = point.x;
            n2 = point.y;
        }
        Point point2 = window.getLocation();
        if (SwingUtil.logger.level >= 9) {
            logger.log(9, "showPopup(JPopupMenu,Component,int,int,boolean)", "x: " + n + ", y: " + n2 + ", wPos: " + point2 + ", size: " + dimension2);
        }
        if (bl) {
            dimension = window.getSize();
            if (n + dimension2.width > dimension.width) {
                n = dimension.width - dimension2.width;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 + dimension2.height > dimension.height) {
                n2 = dimension.height - dimension2.height;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (SwingUtil.logger.level >= 9) {
                logger.log(9, "showPopup(JPopupMenu,Component,int,int,boolean)", "Window constrain x: " + n + ", y: " + n2);
            }
        }
        dimension = Toolkit.getDefaultToolkit().getScreenSize();
        n2 += point2.y;
        if ((n += point2.x) + dimension2.width > dimension.width) {
            n = dimension.width - dimension2.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 + dimension2.height > dimension.height) {
            n2 = dimension.height - dimension2.height;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (SwingUtil.logger.level >= 9) {
            logger.log(9, "showPopup(JPopupMenu,Component,int,int,boolean)", "Screen constrain x: " + n + ", y: " + n2);
        }
        point = SwingUtilities.convertPoint(window, n - point2.x, n2 - point2.y, component);
        if (SwingUtil.logger.level >= 9) {
            logger.log(9, "showPopup(JPopupMenu,Component,int,int,boolean)", "Converted back x: " + point.x + ", y: " + point.y);
        }
        jPopupMenu.show(component, point.x, point.y);
    }

    public static void scrollUpLine(JScrollPane jScrollPane) {
        Component component;
        JViewport jViewport = jScrollPane.getViewport();
        Component component2 = component = jViewport == null ? null : jViewport.getView();
        if (!(component instanceof Scrollable)) {
            return;
        }
        Rectangle rectangle = jViewport.getViewRect();
        Dimension dimension = component.getSize();
        int n = ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, 1, -1);
        rectangle.y += n;
        if (rectangle.y + rectangle.height > dimension.height) {
            rectangle.y = Math.max(0, dimension.height - rectangle.height);
        }
        jViewport.setViewPosition(rectangle.getLocation());
    }

    public static void scrollDownLine(JScrollPane jScrollPane) {
        Component component;
        JViewport jViewport = jScrollPane.getViewport();
        Component component2 = component = jViewport == null ? null : jViewport.getView();
        if (!(component instanceof Scrollable)) {
            return;
        }
        Rectangle rectangle = jViewport.getViewRect();
        int n = ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, 1, -1);
        rectangle.y -= n;
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        jViewport.setViewPosition(rectangle.getLocation());
    }

    public static void cleanup(Component component) {
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "cleanup(Component)", SwingUtil.logger.level < 8 ? "" : "c: " + component);
        }
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                ((Container)component).remove(componentArray[n]);
                SwingUtil.cleanup(componentArray[n]);
                ++n;
            }
        }
        if (component instanceof JMenu) {
            ((JMenu)component).removeAll();
        }
    }

    public static void expandAll(JTree jTree, TreePath treePath) {
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "expandAll(JTree,TreePath)", SwingUtil.logger.level < 8 ? "" : "tree: " + jTree + ", " + "path: " + treePath);
        }
        Object object = treePath.getLastPathComponent();
        TreeModel treeModel = jTree.getModel();
        if (treeModel.isLeaf(object)) {
            return;
        }
        jTree.expandPath(treePath);
        int n = treeModel.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            SwingUtil.expandAll(jTree, treePath.pathByAddingChild(treeModel.getChild(object, n2)));
            ++n2;
        }
    }

    public static void collapseAll(JTree jTree, TreePath treePath) {
        if (SwingUtil.logger.level >= 7) {
            logger.log(7, "expandAll(JTree,TreePath)", SwingUtil.logger.level < 8 ? "" : "tree: " + jTree + ", " + "path: " + treePath);
        }
        Object object = treePath.getLastPathComponent();
        TreeModel treeModel = jTree.getModel();
        if (treeModel.isLeaf(object)) {
            return;
        }
        int n = treeModel.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            SwingUtil.collapseAll(jTree, treePath.pathByAddingChild(treeModel.getChild(object, n2)));
            ++n2;
        }
        jTree.collapsePath(treePath);
    }

    public static void autoSizeTableColumn(JTable jTable, int n) {
        if (jTable.getRowCount() == 0 || !(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jViewport.getViewRect();
        int n2 = jTable.rowAtPoint(new Point(0, rectangle.y));
        int n3 = jTable.rowAtPoint(new Point(0, rectangle.y + rectangle.height));
        if (n3 < 0) {
            n3 = jTable.getRowCount() - 1;
        }
        int n4 = 0;
        int n5 = n2;
        while (n5 <= n3) {
            Component component = jTable.prepareRenderer(jTable.getCellRenderer(n5, n), n5, n);
            n4 = component instanceof JComponent ? Math.max(n4, ((JComponent)component).getPreferredSize().width) : Math.max(n4, component.getSize().width);
            ++n5;
        }
        int n6 = jTable.convertColumnIndexToModel(n);
        jTable.getColumnModel().getColumn(n6).setPreferredWidth(n4);
        jTable.getColumnModel().getColumn(n6).setWidth(n4);
        jTable.revalidate();
    }

    public static void centerWindow(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        window.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ConstrainedViewport
    extends JViewport {
        public void setViewPosition(Point point) {
            Point point2 = new Point(point.x < 0 ? 0 : point.x, point.y < 0 ? 0 : point.y);
            super.setViewPosition(point2);
        }
    }

    private static class DoneEvent
    extends AWTEvent {
        private static Label dummy = new Label();
        public int id;

        public DoneEvent(int n) {
            super(dummy, 1999);
            if (logger.level >= 7) {
                logger.log(7, "DoneEvent(int)", logger.level < 8 ? "" : "id: " + n);
            }
            this.id = n;
        }

        public String toString() {
            return "DoneEvent[id=" + this.id + "]";
        }
    }

    public static interface UnsafeRunnable {
        public Object run() throws Exception;
    }
}

