/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.util.Dictionary;
import org.greenstone.server.BaseProperty;
import org.greenstone.server.BaseServerControl;
import org.greenstone.util.BrowserLauncher;
import org.greenstone.util.RunTarget;

public abstract class BaseServer {
    protected static String START_CMD;
    protected static String RESTART_CMD;
    protected static String CONFIGURE_CMD;
    protected static String STOP_CMD;
    protected static final int SERVER_STARTED = 0;
    protected static final int SERVER_START_FAILED = 1;
    protected static final int BROWSER_LAUNCHED = 2;
    protected static final int BROWSER_LAUNCH_FAILED = 3;
    protected static final int START_SERVER = 4;
    protected static Properties config_properties;
    protected static Logger logger_;
    public static File config_properties_file;
    public static Dictionary dictionary;
    public static BaseProperty Property;
    protected int server_state_ = -1;
    protected boolean configure_required_ = true;
    protected String gsdl_home;
    protected String logs_folder;
    protected boolean start_browser;
    protected BaseServerControl server_control_;

    protected BaseServer(String gsdl_home, String lang, String config_properties_path, String logs) {
        this.gsdl_home = gsdl_home;
        this.logs_folder = this.gsdl_home + File.separator + logs;
        this.initLogger();
        logger_ = Logger.getLogger((String)BaseServer.class.getName());
        config_properties_file = new File(config_properties_path);
        if (!config_properties_file.exists()) {
            logger_.fatal((Object)("Can't find configuration file " + config_properties_path));
            System.exit(1);
        }
        config_properties = new Properties();
        this.reloadConfigProperties(true);
        dictionary = new Dictionary("server", lang, this.getClass().getClassLoader());
    }

    public void autoStart() {
        String auto_start = config_properties.getProperty(BaseServer.Property.AUTOSTART, "true");
        if (auto_start.equals("true") || auto_start.equals("1")) {
            String start_browser = config_properties.getProperty(BaseServer.Property.START_BROWSER, "true");
            if (start_browser.equals("true") || start_browser.equals("1")) {
                this.restart();
            } else {
                this.start();
            }
            this.server_control_.setState(1);
        } else {
            if (this.configure_required_) {
                this.server_control_.displayMessage(dictionary.get("ServerControl.Configuring"));
                int state = this.run(CONFIGURE_CMD);
                if (state != RunTarget.SUCCESS) {
                    this.recordError(CONFIGURE_CMD);
                }
            }
            this.reload();
            this.configure_required_ = false;
            this.server_state_ = 4;
            this.server_control_.updateControl();
        }
    }

    BaseServerControl getServerControl() {
        return this.server_control_;
    }

    protected int getServerState() {
        return this.server_state_;
    }

    protected void initLogger() {
    }

    protected abstract int runTarget(String var1);

    protected int run(String cmd) {
        int result = this.runTarget(cmd);
        this.server_control_.repaint();
        this.server_control_.invalidate();
        this.server_control_.validate();
        return result;
    }

    public abstract String getBrowserURL();

    public abstract void reload();

    protected void preStop() {
    }

    protected void postStart() {
    }

    public void reconfigRequired() {
        this.configure_required_ = true;
    }

    public void start() {
        int state = -1;
        this.server_state_ = -1;
        this.server_control_.updateControl();
        this.server_control_.displayMessage(dictionary.get("ServerControl.Starting"));
        this.stop(true);
        if (this.configure_required_) {
            this.server_control_.displayMessage(dictionary.get("ServerControl.Configuring"));
            state = this.run(CONFIGURE_CMD);
            if (state != RunTarget.SUCCESS) {
                this.recordError(CONFIGURE_CMD);
            }
            this.reload();
            this.configure_required_ = false;
        } else {
            this.recordSuccess(CONFIGURE_CMD);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            logger_.error((Object)("Exception trying to sleep: " + e));
        }
        state = this.run(START_CMD);
        if (state != RunTarget.SUCCESS) {
            this.recordError(START_CMD);
            this.server_state_ = 1;
        } else {
            this.recordSuccess(START_CMD);
            this.server_state_ = 0;
            this.postStart();
        }
        this.server_control_.updateControl();
    }

    protected void recordError(String message) {
        message = dictionary.get("ServerControl.Error", new String[]{message, this.logs_folder});
        this.server_control_.displayMessage(message);
        logger_.error((Object)dictionary.get("ServerControl.Failed", new String[]{message}));
    }

    protected void recordError(String message, Exception e) {
        message = dictionary.get("ServerControl.Error", new String[]{message, this.logs_folder});
        this.server_control_.displayMessage(message);
        logger_.error((Object)dictionary.get("ServerControl.Failed", new String[]{message}), (Throwable)e);
    }

    protected void recordSuccess(String message) {
        message = dictionary.get("ServerControl.Success", new String[]{message});
        this.server_control_.displayMessage(message);
        logger_.info((Object)message);
    }

    public void launchBrowser() {
        this.server_state_ = -1;
        this.server_control_.updateControl();
        String url = this.getBrowserURL();
        String message = dictionary.get("ServerControl.LaunchingBrowser");
        this.server_control_.displayMessage(message);
        BrowserLauncher launcher = new BrowserLauncher(config_properties.getProperty(BaseServer.Property.BROWSER_PATH, ""), url);
        logger_.info((Object)message);
        launcher.start();
        while (launcher.getBrowserState() == -1) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger_.error((Object)e);
            }
        }
        if (launcher.getBrowserState() != 0) {
            this.recordError(dictionary.get("ServerControl.LaunchBrowser"));
            this.server_state_ = 3;
        } else {
            this.recordSuccess(dictionary.get("ServerControl.LaunchBrowser"));
            this.server_state_ = 2;
        }
        this.server_control_.updateControl();
    }

    public void restart() {
        this.start();
        if (this.server_state_ == 0) {
            this.launchBrowser();
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean silent) {
        int state;
        this.preStop();
        if (!silent) {
            this.server_control_.displayMessage(dictionary.get("ServerControl.Stopping"));
        }
        if ((state = this.run(STOP_CMD)) != RunTarget.SUCCESS) {
            this.recordError(STOP_CMD);
        } else {
            this.recordSuccess(STOP_CMD);
        }
    }

    public boolean reloadConfigProperties(boolean port_has_changed) {
        try {
            FileInputStream in = new FileInputStream(config_properties_file);
            if (in != null) {
                logger_.info((Object)("loading configuration properties: " + config_properties_file));
                config_properties.load(in);
                in.close();
            } else {
                logger_.error((Object)("Couldn't load configuration properties from " + config_properties_file + "!"));
            }
        }
        catch (Exception e) {
            logger_.error((Object)("Exception trying to reload configuration properties " + config_properties_file + ": " + e));
        }
        return true;
    }
}

