/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.GlobalProperties;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OAIXML {
    static Logger logger = Logger.getLogger((String)GSXML.class.getName());
    public static final String VERB = "verb";
    public static final String GET_RECORD = "GetRecord";
    public static final String LIST_RECORDS = "ListRecords";
    public static final String LIST_IDENTIFIERS = "ListIdentifiers";
    public static final String LIST_SETS = "ListSets";
    public static final String LIST_METADATA_FORMATS = "ListMetadataFormats";
    public static final String IDENTIFY = "Identify";
    public static final String OAI_METADATAFORMAT = "OAIMetadataFormat";
    public static final String METADATA_NAMESPACE = "metadataNamespace";
    public static final String OAI_DC = "oai_dc";
    public static final String DC = "dc";
    public static final String METADATA_PREFIX = "metadataPrefix";
    public static final String FROM = "from";
    public static final String UNTIL = "until";
    public static final String SET = "set";
    public static final String RESUMPTION_TOKEN = "resumptionToken";
    public static final String RESUMPTION_TOKEN_EXPIRATION = "resumptionTokenExpiration";
    public static final String IDENTIFIER = "identifier";
    public static final String ADMIN_EMAIL = "adminEmail";
    public static final String BAD_ARGUMENT = "badArgument";
    public static final String BAD_RESUMPTION_TOKEN = "badResumptionToken";
    public static final String BAD_VERB = "badVerb";
    public static final String BASE_URL = "baseURL";
    public static final String CANNOT_DISSEMINATE_FORMAT = "cannotDisseminateFormat";
    public static final String CODE = "code";
    public static final String COLLECTION = "collection";
    public static final String COLLECTION_LIST = "collectionList";
    public static final String COMPLETE_LIST_SIZE = "completeListSize";
    public static final String COMPRESSION = "compression";
    public static final String CURSOR = "cursor";
    public static final String DATESTAMP = "datestamp";
    public static final String DC_METADATA_NAMES = "DCMetadataNames";
    public static final String DELETED_RECORD = "deletedRecord";
    public static final String DESCRIPTION = "description";
    public static final String EARLIEST_DATESTAMP = "earliestDatestamp";
    public static final String ERROR = "error";
    public static final String EXPIRATION_DATE = "expirationDate";
    public static final String GRANULARITY = "granularity";
    public static final String GS3OAI = "GS3OAI";
    public static final String HAS_OAI = "hasOAI";
    public static final String HEADER = "header";
    public static final String ILLEGAL_OAI_VERB = "Illegal OAI verb";
    public static final String INDEX_STEM = "indexStem";
    public static final String LASTMODIFIED = "lastmodified";
    public static final String MAPPING = "mapping";
    public static final String MAPPING_LIST = "mappingList";
    public static final String MESSAGE = "message";
    public static final String METADATA = "metadata";
    public static final String METADATA_FORMAT = "metadataFormat";
    public static final String NAME = "name";
    public static final String NO_RECORDS_MATCH = "noRecordsMatch";
    public static final String OAI = "OAI";
    public static final String OAI_DASH_PMH = "OAI-PMH";
    public static final String OAIPMH = "OAIPMH";
    public static final String OAI_RESUMPTION_TOKENS = "OAIResumptionTokens";
    public static final String OAI_SERVICE = "oaiService";
    public static final String OAI_SET_LIST = "oaiSetList";
    public static final String OAI_SERVICE_UNAVAILABLE = "OAI service unavailable";
    public static final String OID = "OID";
    public static final String PARAM = "param";
    public static final String PARAM_LIST = "paramList";
    public static final String PROTOCOL_VERSION = "protocolVersion";
    public static final String RECORD = "record";
    public static final String REQUEST = "request";
    public static final String REPOSITORY_NAME = "repositoryName";
    public static final String RESPONSE = "response";
    public static final String RESPONSE_DATE = "responseDate";
    public static final String RESUME_AFTER = "resumeAfter";
    public static final String SCHEMA = "schema";
    public static final String SERVICE = "service";
    public static final String SERVICE_UNAVAILABLE = "service unavailable";
    public static final String SET_SPEC = "setSpec";
    public static final String SET_NAME = "setName";
    public static final String SET_DESCRIPTION = "setDescription";
    public static final String SITE = "site";
    public static final String TO = "to";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String ID_DOES_NOT_EXIST = "idDoesNotExist";
    public static final String NO_METADATA_FORMATS = "noMetadataFormats";
    public static final String BROWSELIST = "browselist";
    public static final String FILE_SEPARATOR = File.separator;
    public static final String OAI_VERSION1 = "1.0";
    public static final String OAI_VERSION2 = "2.0";
    public static Element resumption_token_elem = null;
    public static File resumption_token_file = null;
    public static Element oai_config_elem = null;
    public static String granularity = "";
    public static long token_expiration = 7200L;
    public static String oai_version = "2.0";
    public static Document response_doc;
    public static String[] special_char;
    public static String[] escape_sequence;

    public static void init() {
        resumption_token_elem = OAIXML.getOAIResumptionTokenXML();
    }

    public static String getOAIVersion() {
        return oai_version;
    }

    public static Element createElement(String tag_name) {
        return response_doc.createElement(tag_name);
    }

    public static Element getResponse(Element core_msg) {
        Element res = OAIXML.createElement(RESPONSE);
        res.appendChild(response_doc.importNode(core_msg, true));
        return res;
    }

    public static Element getOAIResumptionTokenXML() {
        resumption_token_file = new File(GlobalProperties.getGSDL3Home() + FILE_SEPARATOR + "WEB-INF" + FILE_SEPARATOR + "classes" + FILE_SEPARATOR + "OAIResumptionToken.xml");
        if (resumption_token_file.exists()) {
            Document token_doc = OAIXML.parseXMLFile(resumption_token_file);
            if (token_doc == null) {
                logger.error((Object)"Fail to parse resumption token file OAIReceptionToken.xml.");
                return null;
            }
            resumption_token_elem = token_doc.getDocumentElement();
            OAIXML.clearExpiredTokens();
            return resumption_token_elem;
        }
        logger.info((Object)("resumption token file: " + resumption_token_file.getPath() + " not found! create an empty one."));
        resumption_token_elem = OAIXML.createElement(OAI_RESUMPTION_TOKENS);
        OAIXML.saveOAIResumptionTokenXML(resumption_token_elem);
        return resumption_token_elem;
    }

    public static void saveOAIResumptionTokenXML(Element token_elem) {
        if (!OAIXML.writeXMLFile(resumption_token_file, token_elem.getOwnerDocument())) {
            logger.error((Object)"Fail to save the resumption token file");
        }
    }

    public static void clearExpiredTokens() {
        boolean token_deleted = false;
        NodeList tokens = GSXML.getChildrenByTagName(resumption_token_elem, RESUMPTION_TOKEN);
        for (int i = 0; i < tokens.getLength(); ++i) {
            Element token_elem = (Element)tokens.item(i);
            String expire_str = token_elem.getAttribute(EXPIRATION_DATE);
            long datestamp = OAIXML.getTime(expire_str);
            if (datestamp >= System.currentTimeMillis()) continue;
            resumption_token_elem.removeChild(token_elem);
            token_elem = null;
            token_deleted = true;
        }
        if (token_deleted) {
            OAIXML.saveOAIResumptionTokenXML(resumption_token_elem);
        }
    }

    public static boolean containsToken(String token) {
        NodeList tokens = GSXML.getChildrenByTagName(resumption_token_elem, RESUMPTION_TOKEN);
        for (int i = 0; i < tokens.getLength(); ++i) {
            if (!token.equals(GSXML.getNodeText((Element)tokens.item(i)).trim())) continue;
            return true;
        }
        return false;
    }

    public static void addToken(Element token) {
        Document doc = resumption_token_elem.getOwnerDocument();
        resumption_token_elem.appendChild(OAIXML.duplicateElement(doc, token, true));
        OAIXML.saveOAIResumptionTokenXML(resumption_token_elem);
    }

    public static void addToken(String token) {
        Element te = resumption_token_elem.getOwnerDocument().createElement(RESUMPTION_TOKEN);
        resumption_token_elem.appendChild(te);
        OAIXML.saveOAIResumptionTokenXML(resumption_token_elem);
    }

    public static boolean removeToken(String token) {
        NodeList tokens = GSXML.getChildrenByTagName(resumption_token_elem, RESUMPTION_TOKEN);
        int num_tokens = tokens.getLength();
        for (int i = 0; i < num_tokens; ++i) {
            Element e = (Element)tokens.item(i);
            if (!token.equals(GSXML.getNodeText(e))) continue;
            resumption_token_elem.removeChild(e);
            OAIXML.saveOAIResumptionTokenXML(resumption_token_elem);
            return true;
        }
        return false;
    }

    public static Element getOAIConfigXML() {
        OAIXML.init();
        File oai_config_file = new File(GlobalProperties.getGSDL3Home() + FILE_SEPARATOR + "WEB-INF" + FILE_SEPARATOR + "classes" + FILE_SEPARATOR + "OAIConfig.xml");
        if (!oai_config_file.exists()) {
            logger.error((Object)(" oai config file: " + oai_config_file.getPath() + " not found!"));
            return null;
        }
        Document oai_config_doc = OAIXML.parseXMLFile(oai_config_file);
        if (oai_config_doc == null) {
            logger.error((Object)"Fail to parse oai config file OAIConfig.xml.");
            return null;
        }
        oai_config_elem = oai_config_doc.getDocumentElement();
        Element protocol_version = (Element)GSXML.getChildByTagName(oai_config_elem, PROTOCOL_VERSION);
        oai_version = GSXML.getNodeText(protocol_version).trim();
        Element expiration = (Element)GSXML.getChildByTagName(oai_config_elem, RESUMPTION_TOKEN_EXPIRATION);
        String expire_str = GSXML.getNodeText(expiration).trim();
        if (expiration != null && !expire_str.equals("")) {
            token_expiration = Long.parseLong(expire_str);
        }
        Element granu_elem = (Element)GSXML.getChildByTagName(oai_config_elem, GRANULARITY);
        granularity = GSXML.getNodeText(granu_elem).trim();
        granularity = granularity.replaceAll("T", "'T'");
        granularity = granularity.replaceAll("Z", "'Z'");
        granularity = granularity.replaceAll("YYYY", "yyyy").replaceAll("DD", "dd").replaceAll("hh", "HH");
        return oai_config_elem;
    }

    public static String[] getGlobalMetadataMapping(String prefix) {
        Element list_meta_formats = (Element)GSXML.getChildByTagName(oai_config_elem, LIST_METADATA_FORMATS);
        if (list_meta_formats == null) {
            return null;
        }
        Element metadata_format = GSXML.getNamedElement(list_meta_formats, METADATA_FORMAT, METADATA_PREFIX, prefix);
        if (metadata_format == null) {
            return null;
        }
        NodeList mappings = metadata_format.getElementsByTagName(MAPPING);
        int size = mappings.getLength();
        if (size == 0) {
            logger.info((Object)"No metadata mappings are provided in OAIConfig.xml.");
            return null;
        }
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = GSXML.getNodeText((Element)mappings.item(i)).trim();
        }
        return names;
    }

    public static String[] getDublinCoreNames() {
        Element dc_metadata_names = (Element)GSXML.getChildByTagName(oai_config_elem, DC_METADATA_NAMES);
        if (dc_metadata_names == null) {
            logger.error((Object)"Dublin Core metadata names are not provided.");
            return null;
        }
        String names = GSXML.getNodeText(dc_metadata_names).trim();
        return names.split(",");
    }

    public static long getTokenExpiration() {
        return token_expiration * 1000L;
    }

    public static Element getCollectionConfigXML(String site_name, String coll_name) {
        OAIXML.init();
        Element coll_config = null;
        File coll_config_file = new File(GlobalProperties.getGSDL3Home() + FILE_SEPARATOR + "sites" + FILE_SEPARATOR + site_name + FILE_SEPARATOR + "collect" + FILE_SEPARATOR + coll_name + FILE_SEPARATOR + "etc" + FILE_SEPARATOR + "collectionConfig.xml");
        if (!coll_config_file.exists()) {
            logger.error((Object)(" collection config file: " + coll_config_file.getPath() + " not found!"));
            return null;
        }
        Document coll_config_doc = OAIXML.parseXMLFile(coll_config_file);
        if (coll_config_doc == null) {
            logger.error((Object)("Fail to parse collectionConfig.xml of collection: " + coll_config_file.getPath()));
            return null;
        }
        coll_config = coll_config_doc.getDocumentElement();
        return coll_config;
    }

    public static Element createBasicResponse(String verb, String[] pairs) {
        Element response = OAIXML.createResponseHeader(verb);
        Element request_elem = (Element)GSXML.getChildByTagName(response, REQUEST);
        if (verb.equals("")) {
            request_elem.setAttribute(VERB, verb);
        }
        int num_pairs = pairs == null ? 0 : pairs.length;
        for (int i = num_pairs - 1; i >= 0; --i) {
            String[] strs;
            int index = pairs[i].indexOf("=");
            if (index == -1 || (strs = pairs[i].split("=")) == null || strs.length != 2) continue;
            request_elem.setAttribute(strs[0], OAIXML.oaiDecode(strs[1]));
        }
        Element base_url_elem = (Element)GSXML.getChildByTagName(oai_config_elem, BASE_URL);
        String base_url = GSXML.getNodeText(base_url_elem);
        GSXML.setNodeText(request_elem, base_url);
        Node resp_date = GSXML.getChildByTagName(response, RESPONSE_DATE);
        if (resp_date != null) {
            GSXML.setNodeText((Element)resp_date, OAIXML.getCurrentUTCTime());
        }
        return response;
    }

    public static Element createErrorElement(String error_code, String error_text) {
        Element error = OAIXML.createElement(ERROR);
        error.setAttribute(CODE, error_code);
        GSXML.setNodeText(error, error_text);
        return error;
    }

    public static String oaiDecode(String escaped_str) {
        logger.info((Object)("oaiDecode() " + escaped_str));
        for (int i = 0; i < special_char.length; ++i) {
            if (escaped_str.indexOf(escape_sequence[i]) == -1) continue;
            escaped_str = escaped_str.replaceAll(escape_sequence[i], special_char[i]);
        }
        return escaped_str;
    }

    public static String oaiEncode(String original_str) {
        logger.info((Object)("oaiEncode() " + original_str));
        for (int i = 0; i < special_char.length; ++i) {
            if (original_str.indexOf(special_char[i]) == -1) continue;
            original_str = original_str.replaceAll(special_char[i], escape_sequence[i]);
        }
        return original_str;
    }

    public static String convertToJava(String oai_format) {
        oai_format = oai_format.replaceAll("YYYY", "yyyy").replaceAll("DD", "dd").replaceAll("hh", "HH");
        return oai_format;
    }

    public static String convertToOAI(String java_format) {
        java_format = java_format.replaceAll("yyyy", "YYYY").replaceAll("dd", "DD").replaceAll("HH", "hh");
        return java_format;
    }

    public static String getCurrentUTCTime() {
        Date current_utc = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat(granularity);
        return formatter.format(current_utc);
    }

    public static Date getDate(String pattern) {
        if (pattern == null || pattern.equals("")) {
            return null;
        }
        Date date = null;
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(granularity);
            date = sdf.parse(pattern);
        }
        catch (Exception e) {
            logger.error((Object)("invalid date format: " + pattern));
            return null;
        }
        return date;
    }

    public static long getTime(String pattern) {
        if (pattern == null || pattern.equals("")) {
            return -1L;
        }
        Date date = null;
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(granularity);
            date = sdf.parse(pattern);
        }
        catch (Exception e) {
            logger.error((Object)("invalid date format: " + pattern));
            return -1L;
        }
        return date.getTime();
    }

    public static String getTime(long seconds) {
        Date date = new Date(seconds);
        SimpleDateFormat sdf = new SimpleDateFormat(granularity);
        return sdf.format(date);
    }

    public static Element createResponseHeader(String verb) {
        String tag_name = oai_version.equals(OAI_VERSION2) ? OAI_DASH_PMH : verb;
        Element oai = response_doc.createElement(tag_name);
        Element resp_date = response_doc.createElement(RESPONSE_DATE);
        Element req = response_doc.createElement(REQUEST);
        oai.appendChild(resp_date);
        oai.appendChild(req);
        if (oai_version.equals(OAI_VERSION2)) {
            oai.setAttribute("xmlns", "http://www.openarchives.org/OAI/2.0/");
            oai.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            oai.setAttribute("xsi:schemaLocation", "http://www.openarchives.org/OAI/2.0 \n http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd");
        } else {
            oai.setAttribute("xmlns", "http://www.openarchives.com/OAI/1.1/OAI_" + verb);
            oai.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            oai.setAttribute("xsi:schemaLocation", "http://www.openarchives.org/OAI/1.1/OAI_" + verb + "\n http://www.openarchives.org/OAI/1.1/OAI_" + verb + ".xsd");
        }
        return oai;
    }

    public static Element getMetadataPrefixElement(String tag_name, String version) {
        Element oai = response_doc.createElement(tag_name);
        if (version.equals(OAI_VERSION2)) {
            oai.setAttribute("xmlns", "http://www.openarchives.org/OAI/2.0/");
            oai.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            oai.setAttribute("xsi:schemaLocation", "http://www.openarchives.org/OAI/2.0 \n http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd");
        } else {
            oai.setAttribute("xmlns", "ttp://www.openarchives.com/OAI/1.1/");
            oai.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            oai.setAttribute("xsi:schemaLocation", "http://www.openarchives.org/OAI/1.1/" + tag_name + ".xsd");
        }
        return oai;
    }

    public static HashMap getChildrenMapByTagName(Node n, String tag_name) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if (!name.equals(tag_name)) continue;
            map.put(name, child);
        }
        return map;
    }

    public static Element duplicateElement(Document owner, Element element, boolean with_attributes) {
        return OAIXML.duplicateElementNS(owner, element, null, with_attributes);
    }

    public static Element duplicateElementNS(Document owner, Element element, String namespace_uri, boolean with_attributes) {
        int i;
        Element duplicate = namespace_uri == null ? owner.createElement(element.getTagName()) : owner.createElementNS(namespace_uri, element.getTagName());
        if (with_attributes) {
            NamedNodeMap attributes = element.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                duplicate.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        NodeList children = element.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            duplicate.appendChild(owner.importNode(child, true));
        }
        return duplicate;
    }

    public static void copyElement(Element to, Element from, String elem_name) {
        Document to_doc = to.getOwnerDocument();
        for (Node child = from.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(elem_name)) continue;
            to.appendChild(to_doc.importNode(child, true));
            return;
        }
    }

    public static HashMap getParamMap(NodeList params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < params.getLength(); ++i) {
            Element param = (Element)params.item(i);
            String param_name = param.getAttribute(NAME);
            String param_value = param.getAttribute(VALUE);
            map.put(param_name, param_value);
        }
        return map;
    }

    public static Document parseXMLFile(File xml_file) {
        if (!xml_file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            doc = OAIXML.parseXML(new FileInputStream(xml_file));
        }
        catch (Exception exception) {
            logger.error((Object)exception.toString());
            return null;
        }
        return doc;
    }

    public static Document parseXML(InputStream xml_input_stream) {
        Document document = null;
        try {
            InputStreamReader isr = new InputStreamReader(xml_input_stream, "UTF-8");
            BufferedReader xml_reader = new BufferedReader(isr);
            document = OAIXML.parseXML(xml_reader);
            isr.close();
            xml_input_stream.close();
        }
        catch (Exception exception) {
            logger.error((Object)exception.toString());
        }
        return document;
    }

    public static Document parseXML(Reader xml_reader) {
        Document document = null;
        try {
            InputSource isc = new InputSource(xml_reader);
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", true);
            parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            parser.parse(isc);
            document = parser.getDocument();
        }
        catch (SAXException exception) {
            System.err.println("SAX exception: " + exception.getMessage());
            logger.error((Object)exception.toString());
        }
        catch (Exception exception) {
            logger.error((Object)exception.toString());
        }
        return document;
    }

    public static boolean writeXMLFile(File xml_file, Document document) {
        try {
            FileOutputStream os = new FileOutputStream(xml_file);
            OutputFormat f = new OutputFormat(document);
            f.setEncoding("UTF-8");
            f.setIndenting(true);
            f.setLineWidth(0);
            f.setPreserveSpace(false);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
            BufferedWriter w = new BufferedWriter(osw);
            XMLSerializer s = new XMLSerializer((Writer)w, f);
            s.asDOMSerializer();
            s.serialize(document);
            ((OutputStream)os).close();
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)exception.toString());
            return false;
        }
    }

    static {
        new XMLConverter();
        response_doc = XMLConverter.newDOM();
        special_char = new String[]{"/", "?", "#", "=", "&", ":", ";", " ", "%", "+"};
        escape_sequence = new String[]{"%2F", "%3F", "%23", "%3D", "%26", "%3A", "%3B", "%20", "%25", "%2B"};
    }
}

