/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GlobalProperties {
    static Logger logger = Logger.getLogger((String)GlobalProperties.class.getName());
    private static Properties properties = null;
    private static String properties_filename = "global.properties";
    private static String gsdl3_home = null;
    private static String gsdl3_web_address = null;

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String default_value) {
        return properties.getProperty(key, default_value);
    }

    public static String getGSDL3Home() {
        return gsdl3_home;
    }

    public static String getGSDL3WebAddress() {
        return gsdl3_web_address;
    }

    public static void reload() {
        try {
            InputStream in = Class.forName("org.greenstone.gsdl3.util.GlobalProperties").getClassLoader().getResourceAsStream(properties_filename);
            if (in != null) {
                logger.error((Object)"loading global properties");
                properties.load(in);
                in.close();
            } else {
                logger.error((Object)"couldn't load global properties!");
            }
            gsdl3_home = properties.getProperty("gsdl3.home");
            File gs3_file = new File(gsdl3_home);
            gsdl3_home = gs3_file.getPath();
            String protocolSpecifier = null;
            String hostSpecifier = null;
            String portSpecifier = null;
            String contextSpecifier = null;
            protocolSpecifier = properties.getProperty("tomcat.protocol") == null || properties.getProperty("tomcat.protocol").equals("") ? "http://" : (properties.getProperty("tomcat.protocol").endsWith("://") ? properties.getProperty("tomcat.protocol") : properties.getProperty("tomcat.protocol") + "://");
            if (properties.getProperty("tomcat.server") == null) {
                hostSpecifier = "localhost";
            } else {
                hostSpecifier = properties.getProperty("tomcat.server");
                while (hostSpecifier.endsWith("/")) {
                    hostSpecifier = hostSpecifier.substring(0, hostSpecifier.length() - 1);
                }
            }
            portSpecifier = properties.getProperty("tomcat.port") == null || properties.getProperty("tomcat.port").equals("") || protocolSpecifier.equals("http://") && properties.getProperty("tomcat.port").equals("80") || protocolSpecifier.equals("https://") && properties.getProperty("tomcat.port").equals("443") ? "" : ":" + properties.getProperty("tomcat.port");
            if (properties.getProperty("tomcat.context") == null || properties.getProperty("tomcat.context").equals("") || properties.getProperty("tomcat.context").equals("/")) {
                contextSpecifier = "";
            } else {
                contextSpecifier = properties.getProperty("tomcat.context");
                if (!contextSpecifier.startsWith("/")) {
                    contextSpecifier = "/" + contextSpecifier;
                }
            }
            gsdl3_web_address = protocolSpecifier + hostSpecifier + portSpecifier + contextSpecifier;
        }
        catch (Exception e) {
            logger.error((Object)("Exception trying to reload global.properties: " + e));
        }
    }

    static {
        properties = new Properties();
        GlobalProperties.reload();
    }
}

