/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.greenstone.gsdl3.util.UserQueryResult;

public class DerbyWrapper {
    static final String PROTOCOL = "jdbc:derby:";
    static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    static final String USERSDB = "usersDB";
    static final String USERS = "users";
    private Connection conn = null;
    private Statement state = null;
    private String protocol_str;

    public DerbyWrapper() {
    }

    public DerbyWrapper(String dbpath) {
        this.connectDatabase(dbpath, false);
    }

    public void connectDatabase(String dbpath, boolean create_database) {
        try {
            Class.forName(DRIVER).newInstance();
            this.protocol_str = PROTOCOL + dbpath;
            this.conn = create_database ? DriverManager.getConnection(this.protocol_str + ";create=true") : DriverManager.getConnection(this.protocol_str);
            this.state = this.conn.createStatement();
        }
        catch (Throwable e) {
            System.out.println("exception thrown:");
            if (e instanceof SQLException) {
                DerbyWrapper.printSQLError((SQLException)e);
            }
            e.printStackTrace();
        }
    }

    public void closeDatabase() {
        this.state = null;
        this.conn = null;
        boolean gotSQLExc = false;
        try {
            DriverManager.getConnection(this.protocol_str + ";shutdown=true");
        }
        catch (SQLException se) {
            gotSQLExc = true;
        }
        if (!gotSQLExc) {
            System.out.println("Database did not shut down normally");
        }
    }

    public void createDatabase() throws SQLException {
        this.conn.setAutoCommit(false);
        this.state.execute("create table users (username varchar(40) not null, password varchar(40) not null, groups varchar(500), accountstatus varchar(10), comment varchar(100), primary key(username))");
        this.state.execute("insert into users values ('admin', 'admin', 'administrator,all-collections-editor', 'true', 'change the password for this account as soon as possible')");
        this.conn.commit();
    }

    public UserQueryResult listAllUser() throws SQLException {
        UserQueryResult userQueryResult = new UserQueryResult();
        String sql_list_all_user = "select username, password, groups, accountstatus, comment from users";
        ResultSet rs = this.state.executeQuery(sql_list_all_user);
        while (rs.next()) {
            String returned_username = rs.getString("username");
            String returned_password = rs.getString("password");
            String returned_groups = rs.getString("groups");
            String returned_accountstatus = rs.getString("accountstatus");
            String returned_comment = rs.getString("comment");
            userQueryResult.addUserTerm(returned_username, returned_password, returned_groups, returned_accountstatus, returned_comment);
        }
        if (userQueryResult.getSize() == 0) {
            System.out.println("couldn't find any users");
            return null;
        }
        return userQueryResult;
    }

    public String addUser(String username, String password, String groups, String accountstatus, String comment) throws SQLException {
        this.conn.setAutoCommit(false);
        String sql_insert_user = "insert into users values ('" + username + "', '" + password + "', '" + groups + "', '" + accountstatus + "', '" + comment + "')";
        try {
            this.state.execute(sql_insert_user);
            this.conn.commit();
        }
        catch (Throwable e) {
            System.out.println("exception thrown:");
            if (e instanceof SQLException) {
                DerbyWrapper.printSQLError((SQLException)e);
            } else {
                e.printStackTrace();
            }
            this.closeDatabase();
            System.out.println("Error:" + e.getMessage());
            return "Error:" + e.getMessage();
        }
        return "succeed";
    }

    public String deleteUser(String del_username) throws SQLException {
        this.conn.setAutoCommit(false);
        String sql_delete_user = "delete from users where username='" + del_username + "'";
        try {
            this.state.execute(sql_delete_user);
            this.conn.commit();
        }
        catch (Throwable e) {
            System.out.println("exception thrown:");
            if (e instanceof SQLException) {
                DerbyWrapper.printSQLError((SQLException)e);
            } else {
                e.printStackTrace();
            }
            this.closeDatabase();
            return "Error:" + e.getMessage();
        }
        return "succeed";
    }

    public boolean deleteAllUser() throws SQLException {
        this.conn.setAutoCommit(false);
        try {
            this.state.execute("delete from users");
            this.conn.commit();
        }
        catch (Throwable e) {
            System.out.println("exception thrown:");
            if (e instanceof SQLException) {
                DerbyWrapper.printSQLError((SQLException)e);
            } else {
                e.printStackTrace();
            }
            this.closeDatabase();
            return false;
        }
        return true;
    }

    public UserQueryResult findUser(String username, String password) throws SQLException {
        UserQueryResult userQueryResult = new UserQueryResult();
        this.conn.setAutoCommit(false);
        String sql_find_user = "SELECT  username, password, groups, accountstatus, comment FROM users";
        String append_sql = "";
        if (username != null) {
            append_sql = " WHERE username = '" + username + "'";
        }
        if (password != null) {
            append_sql = append_sql.equals("") ? " WHERE password = '" + password + "'" : append_sql + " and password = '" + password + "'";
        }
        if (!append_sql.equals("")) {
            sql_find_user = sql_find_user + append_sql;
        }
        ResultSet rs = this.state.executeQuery(sql_find_user);
        while (rs.next()) {
            String returned_username = rs.getString("username");
            String returned_password = rs.getString("password");
            String returned_groups = rs.getString("groups");
            String returned_accountstatus = rs.getString("accountstatus");
            String returned_comment = rs.getString("comment");
            userQueryResult.addUserTerm(returned_username, returned_password, returned_groups, returned_accountstatus, returned_comment);
        }
        this.conn.commit();
        if (userQueryResult.getSize() > 0) {
            return userQueryResult;
        }
        System.out.println("couldn't find the user");
        return null;
    }

    public String modifyUserInfo(String username, String new_password, String groups, String accountstatus, String comment) throws SQLException {
        this.conn.setAutoCommit(false);
        String sql_modify_user_info = "update users set ";
        if (new_password != null && !new_password.equals("")) {
            sql_modify_user_info = sql_modify_user_info + "password='" + new_password + "'";
        }
        if (groups != null && accountstatus != null && comment != null) {
            sql_modify_user_info = sql_modify_user_info + ", groups='" + groups + "'" + ", accountstatus='" + accountstatus + "'" + ", comment='" + comment + "'";
        }
        sql_modify_user_info = sql_modify_user_info + " where username='" + username + "'";
        try {
            System.out.println(sql_modify_user_info);
            this.state.execute(sql_modify_user_info);
            this.conn.commit();
        }
        catch (Throwable e) {
            System.out.println("exception thrown:");
            if (e instanceof SQLException) {
                DerbyWrapper.printSQLError((SQLException)e);
            } else {
                e.printStackTrace();
            }
            this.closeDatabase();
            return "Error:" + e.getMessage();
        }
        return "succeed";
    }

    public void db2txt() throws SQLException {
        UserQueryResult userQueryResult = new UserQueryResult();
        String sql_list_all_user = "select username, password, groups, accountstatus, comment from users";
        ResultSet rs = this.state.executeQuery(sql_list_all_user);
        while (rs.next()) {
            String returned_username = rs.getString("username");
            System.out.println("[" + returned_username + "]");
            String returned_comment = rs.getString("comment");
            System.out.println("<comment>" + returned_comment);
            String returned_accountstatus = rs.getString("accountstatus");
            System.out.println("<enabled>" + returned_accountstatus);
            String returned_groups = rs.getString("groups");
            System.out.println("<groups>" + returned_groups);
            String returned_password = this.rot13(rs.getString("password"));
            System.out.println("<password>" + returned_password);
            System.out.println("<username>" + returned_username);
            System.out.println("");
            System.out.println("----------------------------------------------------------------------");
        }
        this.conn.commit();
        this.closeDatabase();
    }

    static void printSQLError(SQLException e) {
        while (e != null) {
            System.out.println(e.toString());
            e = e.getNextException();
        }
    }

    public String rot13(String password) {
        String out_password = "";
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'Z') {
                c = (char)(c - 13);
            }
            out_password = out_password + c;
        }
        return out_password;
    }
}

