/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSEntityResolver;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLRetrieve
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)XMLRetrieve.class.getName());
    protected static final String CONTENT_SERVICE = "DocumentContentRetrieve";
    protected static final String METADATA_SERVICE = "DocumentMetadataRetrieve";
    protected static final String STRUCTURE_SERVICE = "DocumentStructureRetrieve";
    protected String toc_xsl_name = "";
    protected String document_encoding = "";
    protected String document_root_tag = "";
    protected Element collection_doc_list = null;
    protected boolean provide_content = true;
    protected boolean provide_structure = true;
    protected boolean provide_metadata = true;

    public boolean configure(Element info, Element extra_info) {
        Element retrieve_service;
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"configuring XMLRetrieve...");
        Element param_list = (Element)GSXML.getChildByTagName(info, "paramList");
        String services_to_provide = "";
        if (param_list != null) {
            HashMap params = GSXML.extractParams(param_list, false);
            this.toc_xsl_name = (String)params.get("tocXSLT");
            this.document_encoding = (String)params.get("documentEncoding");
            this.document_root_tag = (String)params.get("documentRootTag");
            services_to_provide = (String)params.get("provideServices");
        }
        if (this.toc_xsl_name == null || this.toc_xsl_name.equals("")) {
            this.toc_xsl_name = "default_toc";
        }
        this.toc_xsl_name = this.toc_xsl_name + ".xsl";
        if (this.document_encoding == null || this.document_encoding.equals("")) {
            this.document_encoding = "UTF-8";
        }
        if (services_to_provide != null && !services_to_provide.equals("")) {
            if (services_to_provide.indexOf("content") == -1) {
                this.provide_content = false;
            }
            if (services_to_provide.indexOf("metadata") == -1) {
                this.provide_metadata = false;
            }
            if (services_to_provide.indexOf("structure") == -1) {
                this.provide_structure = false;
            }
        }
        if (this.provide_content) {
            retrieve_service = this.doc.createElement("service");
            retrieve_service.setAttribute("type", "retrieve");
            retrieve_service.setAttribute("name", CONTENT_SERVICE);
            this.short_service_info.appendChild(retrieve_service);
        }
        if (this.provide_metadata) {
            retrieve_service = this.doc.createElement("service");
            retrieve_service.setAttribute("type", "retrieve");
            retrieve_service.setAttribute("name", METADATA_SERVICE);
            this.short_service_info.appendChild(retrieve_service);
        }
        if (this.provide_structure) {
            retrieve_service = this.doc.createElement("service");
            retrieve_service.setAttribute("type", "retrieve");
            retrieve_service.setAttribute("name", STRUCTURE_SERVICE);
            this.short_service_info.appendChild(retrieve_service);
        }
        this.collection_doc_list = (Element)GSXML.getChildByTagName(extra_info, "documentList");
        GSEntityResolver resolver = new GSEntityResolver();
        resolver.setClassLoader(this.class_loader);
        this.converter.setEntityResolver(resolver);
        return true;
    }

    protected Element getServiceDescription(String service_id, String lang, String subset) {
        Element retrieve_service = this.doc.createElement("service");
        retrieve_service.setAttribute("type", "retrieve");
        retrieve_service.setAttribute("name", service_id);
        return retrieve_service;
    }

    protected Element processDocumentContentRetrieve(Element request) {
        Element result = this.doc.createElement("response");
        result.setAttribute("from", CONTENT_SERVICE);
        result.setAttribute("type", "process");
        Element doc_list = (Element)GSXML.getChildByTagName(request, "documentNodeList");
        if (doc_list == null) {
            return result;
        }
        Element result_doc_list = (Element)this.doc.importNode(doc_list, true);
        result.appendChild(result_doc_list);
        NodeList docs = result_doc_list.getElementsByTagName("documentNode");
        for (int i = 0; i < docs.getLength(); ++i) {
            Element doc = (Element)docs.item(i);
            Element content = this.doc.createElement("nodeContent");
            doc.appendChild(content);
            String node_id = doc.getAttribute("nodeID");
            String doc_name = this.getWorkName(node_id);
            Element doc_elem = this.loadDocument(doc_name);
            if (doc_elem == null) continue;
            if (doc_name.equals(node_id)) {
                content.appendChild(this.doc.importNode(doc_elem, true));
                continue;
            }
            Element section = this.getSection(doc_elem, node_id);
            if (section == null) continue;
            content.appendChild(this.doc.importNode(section, true));
        }
        return result;
    }

    protected Element processDocumentStructureRetrieve(Element request) {
        Element result = this.doc.createElement("response");
        result.setAttribute("from", STRUCTURE_SERVICE);
        result.setAttribute("type", "process");
        Element doc_list = (Element)GSXML.getChildByTagName(request, "documentNodeList");
        if (doc_list == null) {
            logger.error((Object)"no documents specified in the request. ");
            return result;
        }
        Element result_doc_list = (Element)this.doc.importNode(doc_list, true);
        result.appendChild(result_doc_list);
        File stylesheet = new File(GSFile.collStylesheetFile(this.site_home, this.cluster_name, this.toc_xsl_name));
        if (!stylesheet.exists()) {
            stylesheet = new File(GSFile.siteStylesheetFile(this.site_home, this.toc_xsl_name));
        }
        if (!stylesheet.exists()) {
            logger.error((Object)("couldn't find the stylesheet file to produce the table of contents:" + stylesheet.getPath()));
            return result;
        }
        XMLTransformer transformer = new XMLTransformer();
        NodeList docs = result_doc_list.getElementsByTagName("documentNode");
        for (int i = 0; i < docs.getLength(); ++i) {
            Element doc = (Element)docs.item(i);
            Element structure = this.doc.createElement("nodeStructure");
            doc.appendChild(structure);
            String doc_name = doc.getAttribute("nodeID");
            doc_name = this.getWorkName(doc_name);
            File doc_file = new File(GSFile.collectionIndexDir(this.site_home, this.cluster_name) + File.separator + "text" + File.separatorChar + doc_name + ".xml");
            if (!doc_file.exists()) {
                logger.error((Object)("couldn't find file in coll " + this.cluster_name + ", file " + doc_name + ".xml"));
                continue;
            }
            try {
                Node toc = transformer.transform(stylesheet, doc_file);
                structure.appendChild(this.doc.importNode(toc, true));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"couldn't transform the document to get the toc");
            }
        }
        return result;
    }

    protected Element processDocumentMetadataRetrieve(Element request) {
        Element result = this.doc.createElement("response");
        result.setAttribute("from", METADATA_SERVICE);
        result.setAttribute("type", "process");
        Element doc_list = (Element)GSXML.getChildByTagName(request, "documentNodeList");
        if (doc_list == null) {
            logger.error((Object)"no documents in the request");
            return result;
        }
        Element result_doc_list = (Element)this.doc.importNode(doc_list, true);
        result.appendChild(result_doc_list);
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"no metadata in the request");
            return result;
        }
        Vector<String> meta_name_list = new Vector<String>();
        boolean all_metadata = false;
        for (Element param = GSXML.getFirstElementChild(param_list); param != null; param = (Element)param.getNextSibling()) {
            if (!param.getAttribute("name").equals("metadata")) continue;
            String metadata = GSXML.getValue(param);
            if (metadata.equals("all")) {
                all_metadata = true;
                break;
            }
            meta_name_list.add(metadata);
        }
        NodeList docs = result_doc_list.getElementsByTagName("documentNode");
        for (int i = 0; i < docs.getLength(); ++i) {
            Element doc = (Element)docs.item(i);
            String node_id = doc.getAttribute("nodeID");
            String doc_name = this.getWorkName(node_id);
            Element metadata_list = this.getMetadata(node_id, all_metadata, meta_name_list);
            doc.appendChild(metadata_list);
        }
        return result;
    }

    protected Element loadDocument(String doc_name) {
        File doc_file = new File(GSFile.collectionIndexDir(this.site_home, this.cluster_name) + File.separator + "text" + File.separatorChar + doc_name + ".xml");
        if (!doc_file.exists()) {
            logger.info((Object)("couldn't find file in coll " + this.cluster_name + ", file " + doc_name + ".xml"));
            return null;
        }
        Document the_doc = null;
        try {
            the_doc = this.converter.getDOM(doc_file, this.document_encoding);
        }
        catch (Exception e) {
            logger.error((Object)("couldn't create a DOM from file " + doc_file.getPath()));
            return null;
        }
        return the_doc.getDocumentElement();
    }

    protected Element getSection(Element doc_elem, String node_id) {
        NodeList elements;
        String[] bits = node_id.split("\\.");
        if (bits.length > 4) {
            logger.error((Object)("badly formatted node id (" + node_id + "), cant retrieve the section"));
            return null;
        }
        String id = "";
        String tagname = "";
        String scope = "";
        if (bits.length == 2) {
            tagname = bits[1];
        } else {
            scope = bits[1];
            tagname = bits[2];
            if (bits.length == 4) {
                id = bits[3];
            }
        }
        scope = this.translateScope(scope);
        Element top = null;
        if (!scope.equals("")) {
            top = (Element)GSXML.getNodeByPath(doc_elem, scope);
            if (top == null) {
                return null;
            }
        } else {
            top = doc_elem;
        }
        if ((elements = top.getElementsByTagName(tagname)).getLength() == 0) {
            return null;
        }
        if (id.equals("")) {
            return (Element)elements.item(0);
        }
        for (int i = 0; i < elements.getLength(); ++i) {
            Element e = (Element)elements.item(i);
            if (!e.getAttribute("gs3:id").equals(id)) continue;
            return e;
        }
        return null;
    }

    protected Element getMetadata(String node_id, boolean all, Vector meta_name_list) {
        Element title_meta;
        Element section;
        Element doc_elem;
        Element metadata_list = this.doc.createElement("metadataList");
        String doc_name = this.getWorkName(node_id);
        boolean node_is_root = false;
        if (doc_name.equals(node_id)) {
            node_is_root = true;
        }
        Element this_doc = GSXML.getNamedElement(this.collection_doc_list, "document", "name", doc_name);
        Element doc_meta_list = (Element)GSXML.getChildByTagName(this_doc, "metadataList");
        boolean get_section_title = false;
        if (all) {
            if (node_is_root) {
                return (Element)this.doc.importNode(doc_meta_list, true);
            }
            get_section_title = true;
        } else {
            for (int i = 0; i < meta_name_list.size(); ++i) {
                String meta_name;
                String actual_meta_name = meta_name = (String)meta_name_list.elementAt(i);
                if (meta_name.startsWith("root_")) {
                    actual_meta_name = meta_name.substring(5);
                } else if (!node_is_root) {
                    if (!meta_name.equals("Title")) continue;
                    get_section_title = true;
                    continue;
                }
                Element meta_item = GSXML.getNamedElement(doc_meta_list, "metadata", "name", actual_meta_name);
                if (meta_item == null) continue;
                meta_item = (Element)this.doc.importNode(meta_item, true);
                meta_item.setAttribute("name", meta_name);
                metadata_list.appendChild(meta_item);
            }
        }
        if (get_section_title && (doc_elem = this.loadDocument(doc_name)) != null && (section = this.getSection(doc_elem, node_id)) != null && (title_meta = this.extractTitleMeta(section)) != null) {
            metadata_list.appendChild(title_meta);
        }
        return metadata_list;
    }

    protected Element extractTitleMeta(Element section) {
        Element meta_elem = this.doc.createElement("metadata");
        meta_elem.setAttribute("name", "Title");
        String title = "dummy title";
        Text t = this.doc.createTextNode(title);
        meta_elem.appendChild(t);
        return meta_elem;
    }

    protected String getWorkName(String node_id) {
        int pos = node_id.indexOf(46);
        if (pos == -1) {
            return node_id;
        }
        return node_id.substring(0, pos);
    }

    protected String translateScope(String scope) {
        if (this.document_root_tag != null) {
            return GSPath.appendLink(this.document_root_tag, scope);
        }
        return scope;
    }
}

