/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.action.Action;
import org.greenstone.gsdl3.core.ModuleInterface;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSParams;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.GlobalProperties;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Receptionist
implements ModuleInterface {
    static Logger logger = Logger.getLogger((String)Receptionist.class.getName());
    protected HashMap config_params = null;
    protected Document doc = null;
    protected XMLConverter converter = new XMLConverter();
    protected ModuleInterface mr = null;
    protected HashMap action_map = null;
    protected GSParams params = null;
    protected Element language_list = null;
    protected ArrayList base_interfaces = null;

    public Receptionist() {
        Receptionist receptionist = this;
        this.doc = receptionist.converter.newDOM();
        this.action_map = new HashMap();
    }

    public void cleanUp() {
    }

    public void setParams(GSParams params) {
        this.params = params;
    }

    public void setConfigParams(HashMap params) {
        this.config_params = params;
    }

    public HashMap getConfigParams() {
        return this.config_params;
    }

    public void setMessageRouter(ModuleInterface m) {
        this.mr = m;
    }

    public boolean configure() {
        if (this.config_params == null) {
            logger.error((Object)" config variables must be set before calling configure");
            return false;
        }
        if (this.mr == null) {
            logger.error((Object)" message router must be set  before calling configure");
            return false;
        }
        File interface_config_file = new File(GSFile.interfaceConfigFile(GSFile.interfaceHome(GlobalProperties.getGSDL3Home(), (String)this.config_params.get("interface_name"))));
        if (!interface_config_file.exists()) {
            logger.error((Object)(" interface config file: " + interface_config_file.getPath() + " not found!"));
            return false;
        }
        Document config_doc = this.converter.getDOM(interface_config_file);
        if (config_doc == null) {
            logger.error((Object)(" could not parse interface config file: " + interface_config_file.getPath()));
            return false;
        }
        Element config_elem = config_doc.getDocumentElement();
        String base_interface = config_elem.getAttribute("baseInterface");
        this.setUpBaseInterface(base_interface);
        this.setUpInterfaceOptions(config_elem);
        Element action_list = (Element)GSXML.getChildByTagName(config_elem, "actionList");
        NodeList actions = action_list.getElementsByTagName("action");
        for (int i = 0; i < actions.getLength(); ++i) {
            Element action = (Element)actions.item(i);
            String class_name = action.getAttribute("class");
            String action_name = action.getAttribute("name");
            Action ac = null;
            try {
                ac = (Action)Class.forName("org.greenstone.gsdl3.action." + class_name).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)(" couldn't load in action " + class_name));
                e.printStackTrace();
                continue;
            }
            ac.setConfigParams(this.config_params);
            ac.setMessageRouter(this.mr);
            ac.configure();
            ac.getActionParameters(this.params);
            this.action_map.put(action_name, ac);
        }
        this.language_list = (Element)GSXML.getChildByTagName(config_elem, "languageList");
        if (this.language_list == null) {
            logger.error((Object)" didn't find a language list in the config file!!");
        }
        return true;
    }

    public String process(String xml_in) {
        Document message_node = this.converter.getDOM(xml_in);
        Node page = this.process(message_node);
        return XMLConverter.getString(page);
    }

    public Node process(Node message_node) {
        String value;
        Element param;
        Element message = XMLConverter.nodeToElement(message_node);
        Element request = (Element)GSXML.getChildByTagName(message, "request");
        if (request == null) {
            logger.error((Object)" message had no request!");
            return null;
        }
        String type = request.getAttribute("type");
        if (!type.equals("page")) {
            logger.error((Object)(" request type is not 'page', but it is '" + type + "', so forwarding the message to the MR!"));
            return this.mr.process(message);
        }
        String action = request.getAttribute("action");
        if (action.equals("")) {
            logger.error((Object)" no action specified in the request!");
            return null;
        }
        Action a = (Action)this.action_map.get(action);
        String action_name = null;
        if (a == null) {
            try {
                action_name = action.substring(0, 1).toUpperCase() + action.substring(1) + "Action";
                Action ac = (Action)Class.forName("org.greenstone.gsdl3.action." + action_name).newInstance();
                ac.setConfigParams(this.config_params);
                ac.setMessageRouter(this.mr);
                ac.configure();
                ac.getActionParameters(this.params);
                this.action_map.put(action, ac);
                a = ac;
            }
            catch (Exception e) {
                logger.error((Object)(" a new action (" + action_name + ") was specified and it couldn't be created. Error message:" + e.getMessage()));
                return null;
            }
        }
        this.preProcessRequest(request);
        Element page = this.doc.createElement("page");
        page.setAttribute("lang", request.getAttribute("lang"));
        page.setAttribute("xmlns:gsf", "http://www.greenstone.org/greenstone3/schema/ConfigFormat");
        page.setAttribute("xmlns:xsl", "http://www.w3.org/1999/XSL/Transform");
        Node action_response = a.process(message);
        boolean response_only = false;
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list != null && (param = GSXML.getNamedElement(param_list, "param", "name", "ro")) != null && (value = param.getAttribute("value")).equals("1")) {
            response_only = true;
        }
        if (response_only) {
            return action_response;
        }
        page.appendChild(GSXML.duplicateWithNewName(this.doc, request, "pageRequest", true));
        Element page_response = GSXML.duplicateWithNewName(this.doc, (Element)GSXML.getChildByTagName(action_response, "response"), "pageResponse", true);
        page.appendChild(page_response);
        Node resulting_page = this.postProcessPage(page);
        logger.debug((Object)"receptionist returned response");
        logger.debug((Object)XMLConverter.getString(resulting_page));
        return resulting_page;
    }

    protected boolean setUpBaseInterface(String base_interface) {
        if (base_interface == null || base_interface.equals("")) {
            return true;
        }
        while (!base_interface.equals("")) {
            File base_interface_config_file = new File(GSFile.interfaceConfigFile(GSFile.interfaceHome(GlobalProperties.getGSDL3Home(), base_interface)));
            if (!base_interface_config_file.exists()) {
                logger.error((Object)(" base interface config file: " + base_interface_config_file.getPath() + " not found!"));
                return false;
            }
            if (this.base_interfaces == null) {
                this.base_interfaces = new ArrayList();
            }
            this.base_interfaces.add(base_interface);
            Document config_doc = this.converter.getDOM(base_interface_config_file);
            if (config_doc == null) {
                logger.error((Object)(" could not parse base interface config file: " + base_interface_config_file.getPath()));
                return false;
            }
            Element config_elem = config_doc.getDocumentElement();
            base_interface = config_elem.getAttribute("baseInterface");
        }
        return true;
    }

    protected boolean setUpInterfaceOptions(Element config_elem) {
        Element option_list = (Element)GSXML.getChildByTagName(config_elem, "optionList");
        if (option_list != null) {
            logger.info((Object)"found an interface optionList");
            NodeList options = option_list.getElementsByTagName("option");
            for (int i = 0; i < options.getLength(); ++i) {
                Element option = (Element)options.item(i);
                String name = option.getAttribute("name");
                String value = option.getAttribute("value");
                logger.info((Object)("option: " + name + ", " + value));
                if (name.equals("") || value.equals("")) continue;
                this.config_params.put(name, value);
            }
        }
        return true;
    }

    protected void preProcessRequest(Element request) {
    }

    protected Node postProcessPage(Element page) {
        return page;
    }
}

