/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.build;

import java.io.File;
import org.greenstone.gsdl3.build.ConstructionEvent;
import org.greenstone.gsdl3.build.ConstructionListener;
import org.greenstone.gsdl3.build.GS2PerlConstructor;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConstructCollection
implements ConstructionListener {
    public static void main(String[] args) {
        String site_home = null;
        String coll_name = null;
        int process_mode = -1;
        if (args.length < 4) {
            ConstructCollection.printUsage();
            return;
        }
        XMLConverter converter = new XMLConverter();
        Document doc = converter.newDOM();
        Element option_list = doc.createElement("paramList");
        for (int i = 0; i < args.length - 1; ++i) {
            String key = args[i];
            if (!key.startsWith("-")) continue;
            key = key.substring(1);
            String val = args[i + 1];
            if (val.startsWith("-")) {
                val = null;
            } else {
                ++i;
            }
            if (key.equals("site")) {
                site_home = val;
                continue;
            }
            if (key.equals("mode")) {
                if (val == null) continue;
                if (val.equals("new")) {
                    process_mode = 0;
                    continue;
                }
                if (val.equals("import")) {
                    process_mode = 1;
                    continue;
                }
                if (val.equals("build")) {
                    process_mode = 2;
                    continue;
                }
                if (!val.equals("activate")) continue;
                process_mode = 3;
                continue;
            }
            Element option = doc.createElement("param");
            option.setAttribute("name", key);
            if (val != null) {
                option.setAttribute("value", val);
            }
            option_list.appendChild(option);
        }
        String last_arg = args[args.length - 1];
        if (last_arg.startsWith("-")) {
            System.out.println("ERROR: the last arg should be the collection name!");
            ConstructCollection.printUsage();
            return;
        }
        coll_name = last_arg;
        if (site_home == null || process_mode == -1 || coll_name == null) {
            System.out.println("ERROR: you have not specified all the necessary args!");
            ConstructCollection.printUsage();
            return;
        }
        File coll_dir = new File(GSFile.collectionBaseDir(site_home, coll_name));
        if (process_mode != 0 && !coll_dir.exists()) {
            System.out.println("ERROR: Invalid collection (" + coll_name + ").");
            ConstructCollection.printUsage();
            return;
        }
        if (process_mode == 0 && coll_dir.exists()) {
            System.out.println("ERROR: there is already a collection named " + coll_name);
            ConstructCollection.printUsage();
            return;
        }
        ConstructCollection processor = new ConstructCollection();
        GS2PerlConstructor constructor = new GS2PerlConstructor("perl_build");
        if (!constructor.configure()) {
            System.out.println("couldn't configure the constructor!!");
            return;
        }
        constructor.setCollectionName(coll_name);
        constructor.setSiteHome(site_home);
        constructor.setProcessParams(option_list);
        constructor.setActionType(process_mode);
        constructor.addListener(processor);
        constructor.start();
    }

    protected static void printUsage() {
        System.out.println("Usage: the following arguments need to be supplied:\n -site <site-home> -mode new|import|build|activate [options] <coll-name>");
        System.out.println("Options available are:");
        System.out.println("-maxdocs N\t process at most N documents\n-gs2\t use greenstone 2 style building");
    }

    public void processBegun(ConstructionEvent evt) {
        System.out.println("begun: " + evt.getMessage());
    }

    public void processComplete(ConstructionEvent evt) {
        System.out.println("complete: " + evt.getMessage());
    }

    public void processStatus(ConstructionEvent evt) {
        System.out.println(evt.getMessage());
    }

    public void message(ConstructionEvent evt) {
        System.out.println(evt.getMessage());
    }
}

