###########################################################################
#
# win32 makefile -- src/w32server
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDL_DIR = ..\..\..
COMMON_DIR = $(GSDL_DIR)\common-src
RUNTIME_DIR = $(GSDL_DIR)\runtime-src

INDEXERS_DIR = $(COMMON_DIR)\indexers
COMMON_PACKAGES_DIR = $(COMMON_DIR)\packages
PACKAGES_DIR = $(RUNTIME_DIR)\packages
COLSERVR_DIR = $(RUNTIME_DIR)\src\colservr
PROTOCOL_DIR = $(RUNTIME_DIR)\src\protocol
RECPT_DIR    = $(RUNTIME_DIR)\src\recpt


GSDL_VC4 = 0
DEBUG = 0
ENABLE_ACCENTFOLD = 1
USE_GDBM = 1
USE_JDBM = 1
USE_SQLITE = 1
USE_MSSQL = 0
ENABLE_MG = 1
ENABLE_MGPP = 1
ENABLE_LUCENE = 1

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS = 
!ENDIF


!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(ENABLE_ACCENTFOLD)
ACCENTFOLD_LIBS = "$(INDEXERS_DIR)\packages\unac\libunac.lib" "$(INDEXERS_DIR)\packages\windows\iconv\iconv\lib\iconv.lib"
!ELSE
ACCENTFOLD_LIBS = 
!ENDIF

!IF $(USE_GDBM)
GDBM_INCLUDES = -I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3" \
	-I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\windows"
GDBM_LIBS = "$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\gdbm.lib"
GDBM_DEFINES = -DUSE_GDBM
!ELSE
GDBM_INCLUDES = 
GDBM_LIBS = 
GDBM_DEFINES =
!ENDIF

!IF $(USE_JDBM)
JDBM_DEFINES = -DUSE_JDBM
!ELSE
JDBM_DEFINES =
!ENDIF

!IF $(USE_SQLITE)
SQLITE_LIBS = "$(COMMON_PACKAGES_DIR)\sqlite\lib\sqlite3.lib"
SQLITE_DEFINES = -DUSE_SQLITE
!ELSE
SQLITE_LIBS = 
SQLITE_DEFINES =
!ENDIF

!IF $(USE_MSSQL)
MSSQL_DEFINES = -DUSE_MSSQL
!ELSE
MSSQL_DEFINES =
!ENDIF

!IF $(ENABLE_MG)
MG_DEFS = -DENABLE_MG
MG_LIBS = "$(INDEXERS_DIR)\mg\src\text\libmgtext.lib" \
	"$(INDEXERS_DIR)\mg\lib\libmglib.lib"
MG_INCLUDES = -I"$(INDEXERS_DIR)\mg" -I"$(INDEXERS_DIR)\mg\lib" -I"$(INDEXERS_DIR)\mg\src\text"
!ELSE
MG_DEFS = 
MG_LIBS =
MG_INCLUDES =
!ENDIF

!IF $(ENABLE_MGPP)
MGPP_DEFS = -DENABLE_MGPP
MGPP_LIBS = "$(INDEXERS_DIR)\mgpp\text\libmgpptext.lib" \
	"$(INDEXERS_DIR)\mgpp\lib\libmgpplib.lib"
MGPP_INCLUDES = -I"$(INDEXERS_DIR)\mgpp\lib" -I"$(INDEXERS_DIR)\mgpp\text"
!ELSE
MGPP_DEFS =
MGPP_LIBS =
MGPP_INCLUDES =
!ENDIF

!IF $(ENABLE_LUCENE)
LUCENE_DEFS = -DENABLE_LUCENE
!ELSE
LUCENE_DEFS=
!ENDIF

AR = lib
CC = cl
DEFS = -D__WIN32__ -DHAVE_CONFIG_H -D_LITTLE_ENDIAN -DPARADOCNUM -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE \
	$(GDBM_DEFINES) $(JDBM_DEFINES) $(SQLITE_DEFINES) $(MSSQL_DEFINES) \
	$(MG_DEFS) $(MGPP_DEFS) $(LUCENE_DEFS)
INCLUDES = -I"$(GSDL_DIR)" -I"$(COMMON_DIR)\src\lib" -I"$(COLSERVR_DIR)" -I"$(PROTOCOL_DIR)" -I"$(RECPT_DIR)" \
	$(GDBM_INCLUDES) \
	-I"$(COLSERVR_DIR)" \
	$(MG_INCLUDES) \
    	$(MGPP_INCLUDES)

LIBS = "$(COMMON_PACKAGES_DIR)\windows\crypt\crypt\crypt.lib" "$(COMMON_PACKAGES_DIR)\expat\lib\libexpat.lib" \
        $(GDBM_LIBS) $(ACCENTFOLD_LIBS) $(SQLITE_LIBS)
RSC = rc
WINLIBS = kernel32.lib user32.lib gdi32.lib winspool.lib \
          comdlg32.lib advapi32.lib shell32.lib ole32.lib \
          oleaut32.lib uuid.lib odbc32.lib odbccp32.lib 
#wsock32.lib


!IF $(GSDL_VC4)
DEFS = $(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\stlport\stlport"
!ENDIF


COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo $(LDFLAGS) -Fe"$@"


.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 


SOURCES = \
	cgiwrapper.cpp \
	conftools.cpp \
	d_winsock.cpp \
	fnord.cpp \
	httpreq.cpp \
	httpsend.cpp \
        httpsrv.cpp \
	locate.cpp \
	netio.cpp \
	parse.cpp \
	settings.cpp \
	startbrowser.cpp \
	wincgiutils.cpp

OBJECTS = \
	cgiwrapper.obj \
	conftools.obj \
	d_winsock.obj \
	fnord.obj \
	httpreq.obj \
	httpsend.obj \
        httpsrv.obj \
	locate.obj \
	netio.obj \
	parse.obj \
	settings.obj \
	startbrowser.obj \
	wincgiutils.obj

RESOURCES = \
	server.res

GSDL_LIBS = \
	"$(RECPT_DIR)\gsdlrecpt.lib" \
	"$(PROTOCOL_DIR)\gsdlprotocol.lib" \
	"$(COLSERVR_DIR)\gsdlcolservr.lib" \
	$(MG_LIBS) \
	$(MGPP_LIBS) \
	"$(COMMON_DIR)\src\lib\gsdllib.lib"

EXECUTABLE_OBJECTS = \
	$(OBJECTS) \
	$(RESOURCES) \
	$(GSDL_LIBS)

EXECUTABLE = server.exe


# Default target: make the local library executable
all: $(EXECUTABLE)

server.exe: $(EXECUTABLE_OBJECTS)
	$(LINK) $(EXECUTABLE_OBJECTS) $(LIBS) $(WINLIBS) 
install:
	copy $(EXECUTABLE) "$(GSDL_DIR)"

clean:
	del *.obj
	del $(EXECUTABLE)
	if exist *.pdb del *.pdb

# Resources stuff
SOURCE = "$(RUNTIME_DIR)\src\w32server\newgsdl.bmp"
SOURCE = "$(RUNTIME_DIR)\src\w32server\resource.h"
SOURCE = "$(RUNTIME_DIR)\src\w32server\server.ico"
SOURCE = "$(RUNTIME_DIR)\src\w32server\gsdlcol.bmp"
SOURCE = "$(RUNTIME_DIR)\src\w32server\server.rc"
DEP_RSC_SERVE=\
	"$(RUNTIME_DIR)\src\w32server\gsdlcol.bmp"\
	"$(RUNTIME_DIR)\src\w32server\newgsdl.bmp"\
	"$(RUNTIME_DIR)\src\w32server\server.ico"

server.res : $(SOURCE) $(DEP_RSC_SERVE) "$(RUNTIME_DIR)\src\w32server"
   $(RSC) /l 0x409 /fo"$(RUNTIME_DIR)\src\w32server\server.res" /i "$(RUNTIME_DIR)\src\w32server" \
 /i "$(VCINSTALLDIR)/include/mfc" /d "NDEBUG" $(SOURCE)

"$(RUNTIME_DIR)\src\w32server\server.res" : $(SOURCE) $(DEP_RSC_SERVE) "$(RUNTIME_DIR)\src\w32server"
   $(RSC) /l 0x409 /fo"$(RUNTIME_DIR)\src\w32server\server.res" /i "$(RUNTIME_DIR)\src\w32server" \
 /d "NDEBUG" $(SOURCE)
