###########################################################################
#
# win32 makefile -- src/oaiserver
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999-2008  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDL_DIR = ..\..\..
COMMON_DIR = $(GSDL_DIR)\common-src
RUNTIME_DIR = $(GSDL_DIR)\runtime-src

INDEXERS_DIR = $(COMMON_DIR)\indexers
COMMON_PACKAGES_DIR = $(COMMON_DIR)\packages
PACKAGES_DIR = $(RUNTIME_DIR)\packages
COLSERVR_DIR = $(RUNTIME_DIR)\src\colservr
PROTOCOL_DIR = $(RUNTIME_DIR)\src\protocol
RECPT_DIR    = $(RUNTIME_DIR)\src\recpt


GSDL_VC4 = 0
DEBUG = 0
LOCAL_LIBRARY = 0
DLL = 0
DLLDEBUG = 0
ENABLE_ACCENTFOLD = 1
USE_GDBM = 1
USE_JDBM = 1
USE_SQLITE = 1
USE_MSSQL = 0
ENABLE_MG = 1
ENABLE_MGPP = 1
ENABLE_LUCENE = 1

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS =
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(DLL)
CXXFLAGS = $(CXXFLAGS) -MD
!ELSE
!IF ($(DLLDEBUG))
CXXFLAGS = $(CXXFLAGS) -MDd
!ENDIF
!ENDIF

!IF $(ENABLE_ACCENTFOLD)
ACCENTFOLD_LIBS = "$(INDEXERS_DIR)\packages\unac\libunac.lib" "$(INDEXERS_DIR)\packages\windows\iconv\iconv\lib\iconv.lib"
!ELSE
ACCENTFOLD_LIBS = 
!ENDIF

!IF $(USE_GDBM)
GDBM_INCLUDES = -I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3" \
	-I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\windows"
GDBM_LIBS = "$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\gdbm.lib"
GDBM_DEFINES = -DUSE_GDBM
!ELSE
GDBM_INCLUDES = 
GDBM_LIBS = 
GDBM_DEFINES =
!ENDIF

!IF $(USE_JDBM)
JDBM_DEFINES = -DUSE_JDBM
!ELSE
JDBM_DEFINES =
!ENDIF

!IF $(USE_SQLITE)
SQLITE_LIBS = "$(COMMON_PACKAGES_DIR)\sqlite\lib\sqlite3.lib"
SQLITE_DEFINES = -DUSE_SQLITE
!ELSE
SQLITE_LIBS = 
SQLITE_DEFINES =
!ENDIF

!IF $(USE_MSSQL)
MSSQL_DEFINES = -DUSE_MSSQL
!ELSE
MSSQL_DEFINES =
!ENDIF

!IF $(ENABLE_MG)
MG_DEFS = -DENABLE_MG
MG_LIBS = "$(INDEXERS_DIR)\mg\src\text\libmgtext.lib" \
	"$(INDEXERS_DIR)\mg\lib\libmglib.lib"	
!ELSE
MG_DEFS =
MG_LIBS =
!ENDIF

!IF $(ENABLE_MGPP)
MGPP_DEFS = -DENABLE_MGPP
MGPP_LIBS = "$(INDEXERS_DIR)\mgpp\text\libmgpptext.lib" \
	"$(INDEXERS_DIR)\mgpp\lib\libmgpplib.lib"
MGPP_INCLUDES = -I"$(INDEXERS_DIR)\mgpp\text" -I"$(INDEXERS_DIR)\mgpp\lib"
!ELSE
MGPP_DEFS =
MGPP_LIBS =
MGPP_INCLUDES =
!ENDIF

!IF $(ENABLE_LUCENE)
LUCENE_DEFS = -DENABLE_LUCENE
!ELSE
LUCENE_DEFS=
!ENDIF


AR = lib
CC = cl
DEFS = -D__WIN32__ -DHAVE_CONFIG_H -DPARADOCNUM -D_LITTLE_ENDIAN -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE \
        -DGSDL_NOCACHE $(GDBM_DEFINES) $(JDBM_DEFINES) $(SQLITE_DEFINES) $(MSSQL_DEFINES) \
	$(MG_DEFS) $(MGPP_DEFS) $(LUCENE_DEFS)
INCLUDES = -I"$(COMMON_DIR)\src\lib" -I"$(COLSERVR_DIR)" -I"$(PROTOCOL_DIR)" -I"$(RECPT_DIR)" \
        $(MGPP_INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\crypt\crypt" \
	$(GDBM_INCLUDES) \
	-I"$(COMMON_PACKAGES_DIR)\expat\include"
LIBS = "$(COMMON_PACKAGES_DIR)\windows\crypt\crypt\crypt.lib" "$(COMMON_PACKAGES_DIR)\expat\lib\libexpat.lib" \
        $(GDBM_LIBS) $(ACCENTFOLD_LIBS) $(SQLITE_LIBS)

!IF $(GSDL_VC4)
DEFS = $(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\stlport\stlport"
!ENDIF
!IF $(LOCAL_LIBRARY)
DEFS = $(DEFS) -DGSDL_LOCAL_LIBRARY
!ENDIF


COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo $(LDFLAGS) -Fe"$@"


.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 


RECPT_OBJECTS = \
	"$(RECPT_DIR)\cgiargs.obj" \
	"$(RECPT_DIR)\cgiutils.obj" \
	"$(RECPT_DIR)\htmlutils.obj"

SOURCES = \
	abstractlistaction.cpp \
	dublincore.cpp \
	qualified_dublincore.cpp \
	identifyaction.cpp \
	listidsaction.cpp \
	listrecsaction.cpp \
	listsetsaction.cpp \
	metaformat.cpp \
	metaformatsaction.cpp \
	oaiaction.cpp \
	oaiargs.cpp \
	oaiconfig.cpp \
	oaidispatcher.cpp \
	oaimain.cpp \
	oaitools.cpp \
	recordaction.cpp \
	resumptiontoken.cpp \
	rfc1807.cpp

OBJECTS = \
	abstractlistaction.obj \
	dublincore.obj \
	qualified_dublincore.obj \
	identifyaction.obj \
	listidsaction.obj \
	listrecsaction.obj \
	listsetsaction.obj \
	metaformat.obj \
	metaformatsaction.obj \
	oaiaction.obj \
	oaiargs.obj \
	oaiconfig.obj \
	oaidispatcher.obj \
	oaimain.obj \
	oaitools.obj \
	recordaction.obj \
	resumptiontoken.obj \
	rfc1807.obj

GSDL_LIBS = \
	"$(PROTOCOL_DIR)\gsdlprotocol.lib" \
	"$(COLSERVR_DIR)\gsdlcolservr.lib" \
	$(MG_LIBS) \
	$(MGPP_LIBS) \
	"$(COMMON_DIR)\src\lib\gsdllib.lib"

EXECUTABLE_OBJECTS = \
	$(OBJECTS) \
	$(RECPT_OBJECTS) \
	$(GSDL_LIBS)

EXECUTABLE = oaiserver.cgi


# Default target: compile up .obj files only if LOCAL_LIBRARY is set, otherwise both obj files and oaiserver.cgi
!IF $(LOCAL_LIBRARY)
all: $(EXECUTABLE_OBJECTS)
!ELSE
all: $(EXECUTABLE)
!ENDIF

oaiserver.cgi: $(EXECUTABLE_OBJECTS)
	$(LINK) $(EXECUTABLE_OBJECTS) $(LIBS)

!IF $(LOCAL_LIBRARY)
install:
!ELSE
install: $(EXECUTABLE)
!IF "$(PROCESSOR_ARCHITECTURE)"==""
	copy $(EXECUTABLE) "$(GSDL_DIR)\cgi-bin\windows"
!ELSE IF EXIST ("$(GSDL_DIR)\bin\windows")	
	copy $(EXECUTABLE) "$(GSDL_DIR)\cgi-bin\windows"	
!ELSE IF "$(PROCESSOR_ARCHITECTURE)"=="x86"	
	copy $(EXECUTABLE) "$(GSDL_DIR)\cgi-bin\windows32"
!ELSE
	copy $(EXECUTABLE) "$(GSDL_DIR)\cgi-bin\windows64"
!ENDIF
!ENDIF

clean:
	del *.obj
	del $(EXECUTABLE)
