/**********************************************************************
 *
 * oaidispatcher.cpp --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "oaidispatcher.h"

oaidispatcher::oaidispatcher()
{ this->configuration = NULL;
}

oaidispatcher::~oaidispatcher()
{
  oaiactionmap::iterator here = this->actions.begin();
  oaiactionmap::iterator end  = this->actions.end();

  while (here != end) {
    delete here->second;
    ++here;
  }
}

void oaidispatcher::addAction(oaiaction *thisAction) {
  thisAction->setConfiguration(this->configuration);
  this->actions[thisAction->getName()] = thisAction;
}

void oaidispatcher::doAction(ostream &output, recptproto *protocol, oaiargs &args) {

  text_t verb = args["Verb"];
  if(verb == "") verb = args["verb"];
  
  oaiaction *action = actions[verb];
  
  if (action != NULL) {
    action->getResponse(output, protocol, args);
  }
  else {  
    // If the verb isn't correct, send an error.
    action = actions["Identify"];
    text_t responseDate, requestURL;
    int version = this->configuration->getOAIVersion();
    action->getResponseDate(responseDate);
    oaiargs emptySet;
    action->getRequestURL(emptySet, requestURL);

    // Bad verb is signified by a status 400 response for OAI 1.1
    if (version <= 110) {
      output << "Status: 400\n";
    }
    else {
      output << "Status: 200\n";
    }
    output << "Content-type: text/xml" << endl << endl;
    output << "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    
    if(version <= 110){
      // output OAI v1.1 action header tag - nil, as there is no valid heeader for the action
      /*
	output << "<" << action->name;
	output << "\n       xmlns=\"http://www.openarchives.org/OAI/1.1/OAI_" << action->name << "\" ";
	output << "\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ";
	output << "\n       xsi:schemaLocation=\"http://www.openarchives.org/OAI/1.1/OAI_" << action->name;
	output << "\n           http://www.openarchives.org/OAI/1.1/OAI_" << action->name << ".xsd\">\n";
      */    
    }
    else { 
      // output OAI v2.0 action header tag
      text_t baseDocRoot = this->configuration->getRelativeBaseDocRoot();
      output << "<?xml-stylesheet type=\"text/xsl\" href=\""<<baseDocRoot<<"/web/style/oai2.xsl\" ?>\n";   
      output << "<OAI-PMH xmlns=\"http://www.openarchives.org/OAI/2.0/\"\n"
	     << "         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
	     << "         xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/\n"
	     << "             http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd\">\n"
	     << "  <responseDate>" << responseDate << "</responseDate>\n"
	     << requestURL 
	     << "  <error code=\"badVerb\">Illegal OAI verb</error>\n"
	     << "</OAI-PMH>\n";
    }

    /*
      cout << "<title>Bad OAI request</title>" << endl;
      cout << "<h1>Bad OAI request</h1>" << endl;
    */
  }
  output.flush();
}
