/**********************************************************************
 *
 * oaiargs.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include <map>

#include "text_t.h"

class oaiargs
{
 private:
  text_tmap arguments;
  text_t    dummy;
  bool      duplicateArg;
  // fill the input buffer to parse the arguments
  void fillBuffer(istream &stream, unsigned char *buffer, unsigned char **currentPtr, unsigned char *end);
 public:
  oaiargs() { this->duplicateArg = false; }

  const text_t &operator [](const text_t &label) { 
    if (this->arguments.count(label) > 0) {
      return this->arguments[label]; 
    }
    return dummy; // Dodgy, but text_t's are initialised to "", so should be fine
  };

  void erase(const text_t &label) {
    this->arguments.erase(label);
  }

  void readArgs(istream &stream);
  bool hasDuplicateArg() { return this->duplicateArg; }
  int getSize(){return arguments.size();}
  text_tmap::const_iterator begin(){return arguments.begin();};
  text_tmap::const_iterator end(){return arguments.end();};
};
