/**********************************************************************
 *
 * mgppsearch.h -- implementation of search class for mgpp
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * 
 *
 *********************************************************************/


#ifndef MGPPSEARCH_H
#define MGPPSEARCH_H

#include "search.h"
#include "IndexData.h"

class mgppsearchclass : public searchclass {
public:
  mgppsearchclass ();
  virtual ~mgppsearchclass ();

  virtual text_t get_textindex_type() {return "mgpp";}

  // the search results are returned in queryresults
  // search returns 'true' if it was able to do a search
  virtual bool search(const queryparamclass &queryparams, 
	      queryresultsclass &queryresults);
  
  // this returns a list of terms in queryresults - no document info is returned
  // returns a list of numTerms terms, starting from the query string term (in queryparams)
  // + start. used for full text browsing
  virtual bool browse_search(const queryparamclass &queryparams, int start, int numTerms,
			     queryresultsclass &queryresults);

  // the document text for 'docnum' is placed in 'output'
  // docTargetDocument returns 'true' if it was able to
  // try to get a document
  // collection is needed to see if an index from the 
  // collection is loaded. If no index has been loaded
  // defaultindex is needed to load one
  virtual bool docTargetDocument(const text_t &defaultindex,
			 const text_t &defaultsubcollection,
			 const text_t &defaultlanguage,
			 const text_t &collection,
			 int docnum,
			 text_t &output);

  /*  // same as docTargetDocument except the document is returned
  // in its raw form. UDoc remains the property of mg and may
  // be destroyed on the next call to mg.
  // not implemented for mgpp
  virtual bool mgdocument (const text_t &defaultindex,
		   const text_t &defaultsubcollection,
		   const text_t &defaultlanguage,
		   const text_t &collection,
		   int docnum,
		   char *&UDoc, int &ULen);
  */
  
  void set_text_level(const text_t &textlevel_arg);
  
  void set_indexstem(const text_t &indexstem);

  // used to clear any cached databases for persistent versions of 
  // Greenstone like the Windows local library
  void unload_database ();

 protected:
  
  text_t textlevel;
  text_t indexstem; // the stem of the index file names
  IndexData *indexData; // the index data structure needed for MGQuery - keep
  // as a cache
  
  text_t getindexsuffix(const queryparamclass &qp);
  text_t getindexsuffix (const text_t &collection, const text_t &index);

};


#endif

