/**********************************************************************
 *
 * JdbGet.java -- 
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the 
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2009  The New Zealand Digital Library Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/

import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.helper.FastIterator;
import jdbm.htree.HTree;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;


public class JdbGet
{
    static private PrintWriter utf8out = null;

    static
    {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(System.out, "UTF-8");
            utf8out = new PrintWriter(osw, true);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
        }
    }

    public static void print_usage()
    {
	System.err.println("Usage: java JdbGet database-name key");
	System.exit(-1);
    }

    public static void main(String[] args)
    {
	//System.err.println("Running JdbmEdit");

	if (args.length != 2) {
	    print_usage();
	}

	String dbname = args[0];
	String key    = args[1];

	//System.err.println("Args: " + args[0] + " " + args[1]);

        try {

            JdbmAPI jdbm_api = new JdbmAPI(dbname,true);
	    //System.err.println("Constructed jdbm_api");
            String val = jdbm_api.get(key);
	    utf8out.println(val);

	    jdbm_api.close();
        } 
	catch (IOException e) {
            e.printStackTrace();
        }
    }

}
