@echo off
setlocal

set GSDL_DIR=..\..\..\..

set PROJECT=jdbm
set VERSION=1.0
set ARCHIVE=%PROJECT%-%VERSION%

set SOURCE=.\src
set MAIN=%SOURCE%\main
set ETC=%SOURCE%\etc
set BUILD=build
set CLASSES=%BUILD%\classes
set DIST=dist
set LIB=lib
set JDBM_CLASSPATH="%CLASSPATH%;%CLASSES%;%MAIN%"

rem ---- Name and location of java programs ----
set JAVAC="%JAVA_HOME%\bin\javac"
set JAVAH="%JAVA_HOME%\bin\javah"
set JAVA="%JAVA_HOME%\bin\java"
set JAVADOC="%JAVA_HOME%\bin\javadoc"
set JAR="%JAVA_HOME%\bin\jar"

set JAVACOPTIONS=-deprecation -g -O


if "%DEBUG%" == "" (
  set MAKE_VARS=DEBUG=0
) else (
  set MAKE_VARS=DEBUG=%DEBUG%
)

if ""%1"" == """" goto all
if ""%1"" == ""all"" goto all
if ""%1"" == ""install"" goto install
if ""%1"" == ""clean"" goto clean

:unknown
	echo Error: Unrecognized argument %1.
	goto done


::	for /f %%G in ("%OBJECTS%") DO %JAVAC% -classpath "%JDBM_JAR%";. "%%G.java"
::	%JAR% cvf JDBMWrapper.jar -C %JDBMHOME%
:all
	mkdir "%CD%\%BUILD%"
	mkdir "%CD%\%CLASSES%"
	mkdir "%CD%\%DIST%"

	%JAVAC% -sourcepath %MAIN% -d %CLASSES% -classpath %JDBM_CLASSPATH% -nowarn -source 1.3 -target 1.3 %MAIN%\jdbm\*.java %MAIN%\jdbm\btree\*.java %MAIN%\jdbm\htree\*.java %MAIN%\jdbm\recman\*.java %MAIN%\jdbm\helper\*.java

	if exist %DIST%\%ARCHIVE%.jar del /q %DIST%\%ARCHIVE%.jar
	"%GSDLHOME%\bin\windows\sed.exe" "s/@VERSION@/%VERSION%/g" %ETC%\MANIFEST.MF > %CLASSES%\MANIFEST.MF
	%JAR% cvfm %DIST%\%ARCHIVE%.jar %CLASSES%\MANIFEST.MF -C %CLASSES% jdbm

:install
	if not exist "%GSDLHOME%\lib\java" mkdir "%GSDLHOME%\lib\java"
	copy %DIST%\%ARCHIVE%.jar "%GSDLHOME%\lib\java\jdbm.jar"
	goto done

:clean
	if exist "%CD%\%BUILD%" rmdir /s /q "%CD%\%BUILD%"
	if exist "%CD%\%DIST%" rmdir /s /q "%CD%\%DIST%"
	goto done


:done
:: http://ss64.com/nt/endlocal.html
:: If SETLOCAL is used without a corresponding ENDLOCAL then local
:: environment variables will be discarded when the batch file ends.