/**********************************************************************
 *
 * conftools.cpp
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "text_t.h"
#include "conftools.h"

int write_confline (ofstream &fileout, const text_t &key, const text_t value) {
  if (key.empty() || value.empty()) return -1;
  outconvertclass text_t2ascii;
  fileout << text_t2ascii << key << "=" << value << "\n";
  return 0;
}

int get_confline (ifstream &filein, text_t &key, text_t &value) {
  if (filein.eof()) return -1;

  key.clear();
  value.clear();
  char c;
  filein.get(c);

  int foundeq = 0;
  while (!filein.eof() && c != '\n') {
    if (!foundeq && c == '=') {foundeq = 1; filein.get(c);}

    if (foundeq) value.push_back(c);
    else key.push_back(c);
    filein.get(c);
  }
  if (key.empty()) return -1;
  return 0;
} 

