/**********************************************************************
 *
 * tipaction.cpp -- define random tip macros
 * Copyright (C) 1999  DigiLib Systems Limited, New Zealand
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_TIP_ACTION

#include "tipaction.h"
#include <stdlib.h>


tipaction::tipaction () {
  // "st" show tips - "0"=no, "1"=yes
  cgiarginfo arg_ainfo;
  arg_ainfo.shortname = "st";
  arg_ainfo.longname = "show tips";
  arg_ainfo.multiplechar = true;
  arg_ainfo.multiplevalue = false;
  arg_ainfo.defaultstatus = cgiarginfo::weak;
  arg_ainfo.argdefault = "1";
  arg_ainfo.savedarginfo = cgiarginfo::must;
  argsinfo.addarginfo (NULL, arg_ainfo);
}

void tipaction::define_external_macros (displayclass &disp, cgiargsclass &args, 
					recptprotolistclass * /*protos*/, ostream &logout) {

  // define_external_macros sets the following macros:

  // _tip:thistip_  - a random tip (defined if st == "1")

  if (args["st"].getint()) {
    // get the maximum tip number (_tip:tipmax_)
    text_t tipmax_str;
    disp.expandstring ("tip", "_tipmax_", tipmax_str);
    if (tipmax_str.empty()) {
      // don't bother filling up the logs if tip.dm isn't loaded!
      // logout << "Warning: _tip:tipmax_ not set. This macro is needed for displaying tips.\n";
      return;
    }
    
    int tipmax = tipmax_str.getint();
    if (tipmax < 1) {
      // don't bother filling up the logs if tip.dm isn't loaded!
      // logout << "Warning: _tip:tipmax_ was less than 1. No tips were set.\n";
      return;
    }
    
    disp.setmacro("thistip", "tip", "_tip" + text_t((rand()%tipmax) + 1) + "_");
  }
}

#endif //GSDL_USE_TIP_ACTION
