/********************************************************************
 *
 * browseactiontools.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef BROWSEACTIONTOOLS_H
#define BROWSEACTIONTOOLS_H

#include "cgiargs.h"
#include "recptproto.h"

//this puts ands or ors into the querystring as necessary
void format_browsestring(const text_t& orig, text_t& formatted, int and_or);

//this thing sets up the search associated with a browse.  It's programmed by 
//witchcraft, so I don't really know how/why it works - I lifted the code from
//somewhere else.
void set_browsefilter_options(FilterRequest_t &request, const text_t &browsestring,
			      cgiargsclass &args);

//this thing filters out all the results of a request to the collection 
//(whether it be for all documents or just the ones with specified terms)
//that don't have the required "metaname" metadata element.
bool remove_no_meta_results(const text_t &metaname, FilterResponse_t &response,
			    outconvertclass &outconvert);

#endif
