###########################################################################
#
# win32 makefile -- src/colservr
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999-2008  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDL_DIR = ..\..\..
COMMON_DIR = $(GSDL_DIR)\common-src
RUNTIME_DIR = $(GSDL_DIR)\runtime-src

INDEXERS_DIR = $(COMMON_DIR)\indexers
COMMON_PACKAGES_DIR = $(COMMON_DIR)\packages
PACKAGES_DIR = $(RUNTIME_DIR)\packages

GSDL_VC4 = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0
USE_GDBM = 1
USE_JDBM = 1
USE_SQLITE = 1
USE_MSSQL = 0
ENABLE_MG = 1
ENABLE_MGPP = 1
ENABLE_LUCENE = 1

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
!ENDIF


!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(DLL)
CXXFLAGS = $(CXXFLAGS) -MD
!ELSE
!IF ($(DLLDEBUG))
CXXFLAGS = $(CXXFLAGS) -MDd
!ENDIF
!ENDIF

!IF $(USE_GDBM)
GDBM_DEFINES = -DUSE_GDBM
GDBM_INCLUDES = -I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3" -I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\windows"
!ELSE
GDBM_DEFINES = 
GDBM_INCLUDES = 
!ENDIF

!IF $(USE_JDBM)
JDBM_DEFINES = -DUSE_JDBM
!ELSE
JDBM_DEFINES = 
!ENDIF

!IF $(USE_SQLITE)
SQLITE_DEFINES = -DUSE_SQLITE
SQLITE_INCLUDES = -I"$(COMMON_PACKAGES_DIR)\sqlite\include"
!ELSE
SQLITE_DEFINES = 
SQLITE_INCLUDES = 
!ENDIF

!IF $(USE_MSSQL)
MSSQL_DEFINES = -DUSE_MSSQL
!ELSE
MSSQL_DEFINES = 
!ENDIF

!IF $(ENABLE_MG)
MG_DEFS = -DENABLE_MG
MG_SOURCES = mgq.c \
	mgqueryfilter.cpp \
	mgsearch.cpp \
	phrasequeryfilter.cpp \
	mgsource.cpp
MG_OBJECTS = mgq.obj \
	mgqueryfilter.obj \
	mgsearch.obj \
	phrasequeryfilter.obj \
	mgsource.obj
MG_INCLUDES = -I"$(INDEXERS_DIR)\mg" -I"$(INDEXERS_DIR)\mg\lib" -I"$(INDEXERS_DIR)\mg\src\text"
!ELSE
MG_DEFS =
MG_SOURCES =
MG_OBJECTS =
MG_INCLUDES =
!ENDIF

!IF $(ENABLE_MGPP)
MGPP_DEFS = -DENABLE_MGPP
MGPP_SOURCES = mgppqueryfilter.cpp \
	mgppsearch.cpp \
	mgppsource.cpp
MGPP_OBJECTS = mgppqueryfilter.obj \
	mgppsearch.obj \
	mgppsource.obj
MGPP_INCLUDES = -I"$(INDEXERS_DIR)\mgpp\lib" -I"$(INDEXERS_DIR)\mgpp\text"
!ELSE
MGPP_DEFS =
MGPP_SOURCES =
MGPP_OBJECTS =
MGPP_INCLUDES =
!ENDIF

!IF $(ENABLE_LUCENE)
LUCENE_DEFS = -DENABLE_LUCENE
!ELSE
LUCENE_DEFS =
!ENDIF


AR = lib
CC = cl
DEFS = -D__WIN32__ -DHAVE_CONFIG_H -DPARADOCNUM -D_LITTLE_ENDIAN -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE \
        -DXML_STATIC $(GDBM_DEFINES) $(JDBM_DEFINES) $(SQLITE_DEFINES) $(MSSQL_DEFINES) \
	$(MG_DEFS) $(MGPP_DEFS) $(LUCENE_DEFS)
# Do NOT add the "recpt" directory here: the colserver should be independent of the receptionist!
INCLUDES = -I"$(GSDL_DIR)" -I"$(COMMON_DIR)\src\lib" \
	$(MG_INCLUDES) \
	$(MGPP_INCLUDES) \
	-I"$(COMMON_PACKAGES_DIR)\expat\include" $(GDBM_INCLUDES) $(SQLITE_INCLUDES)

!IF $(GSDL_VC4)
DEFS=$(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\stlport\stlport"
!ENDIF


COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)


.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 


SOURCES = \
        browsefilter.cpp \
	collectserver.cpp \
	collectset.cpp \
	colservertools.cpp \
        colservrconfig.cpp \
	comtypes.cpp \
	expat_document.cpp \
	expat_resultset.cpp \
	fieldedqueryfilter.cpp \
	filter.cpp \
	lucenequeryfilter.cpp \
	lucenesearch.cpp \
	lucenesource.cpp \
	maptools.cpp \
	$(MG_SOURCES) \
	$(MGPP_SOURCES) \
	phrasesearch.cpp \
	querycache.cpp \
	queryfilter.cpp \
	queryinfo.cpp \
	search.cpp \
	source.cpp \
	sqlbrowsefilter.cpp \
	sqlfilter.cpp \
	sqlqueryfilter.cpp

OBJECTS = \
        browsefilter.obj \
	collectserver.obj \
	collectset.obj \
	colservertools.obj \
        colservrconfig.obj \
	comtypes.obj \
	expat_document.obj \
	expat_resultset.obj \
	fieldedqueryfilter.obj \
	filter.obj \
	lucenequeryfilter.obj \
	lucenesearch.obj \
	lucenesource.obj \
	maptools.obj \
	$(MG_OBJECTS) \
	$(MGPP_OBJECTS) \
	phrasesearch.obj \
	querycache.obj \
	queryfilter.obj \
	queryinfo.obj \
	search.obj \
	source.obj \
	sqlbrowsefilter.obj \
	sqlfilter.obj \
	sqlqueryfilter.obj

LIBRARY = gsdlcolservr.lib	


# Default target: make gsdlcolservr.lib
all: $(LIBRARY)

gsdlcolservr.lib: $(OBJECTS) 
	if EXIST $(LIBRARY) del $(LIBRARY)
	$(AR) -nologo /out:$(LIBRARY) $(OBJECTS)

install:

clean:
	del *.obj
	del $(LIBRARY)
