/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: Katherine Don, New Zealand Digital Library Project, 
 *          University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gems;

import org.greenstone.gatherer.Configuration;

import java.util.ArrayList;


/** this is used as a base class for MetadataSetInfo and MetadataElementModel
 * Both of thesee have some attributes which are language independent, and
 * some which are language dependent
 */ 
public class AttributeContainer {
    
    protected ArrayList attributes;     
    protected ArrayList language_dependent_attributes;    
    
    String [] required_attribute_names = null;
    String [] language_dependent_attribute_names = null;
    
    public AttributeContainer() {}
    public AttributeContainer(String [] required_atts, String []lang_dependent_atts) {       
	
	attributes = new ArrayList();
	language_dependent_attributes =  new ArrayList();               

	if (required_atts != null) {
	    required_attribute_names = required_atts;
	    for(int i=0;i<required_atts.length;i++){
		String reName = required_atts[i];
		Attribute attr = new Attribute(reName,"",true);
		attributes.add(attr);            
	    }
	}

	if (lang_dependent_atts != null) {
	    language_dependent_attribute_names = lang_dependent_atts;
	    for(int i=0;i<lang_dependent_atts.length;i++){
		String reName = lang_dependent_atts[i];
		Attribute attr = new Attribute(reName,"",Configuration.getLanguage(),true);
		language_dependent_attributes.add(attr);            
	    }
	}
	
    }

    public ArrayList getAttributes(){
	return attributes;
    }
    
    public void setAttributes(ArrayList atts) {
	attributes.clear();
	attributes = atts;
    }

    public String [] getLanguageDependentAttributeNames() {
	return language_dependent_attribute_names;
    }
    public ArrayList getLanguageDependentAttributes(){
	return language_dependent_attributes; 
    }
    
    public void setLanguageDependentAttributes(ArrayList lda){
	language_dependent_attributes.clear();
	language_dependent_attributes = lda;
    }


    protected ArrayList getAllLanguages(){
	ArrayList langs = new ArrayList();    

       for(int i=0;i<language_dependent_attributes.size();i++){
	    Attribute attr = (Attribute) language_dependent_attributes.get(i);
            if (!langs.contains(attr.getLanguage()) && !attr.getLanguage().trim().equals("")){
		langs.add(attr.getLanguage());
	    } 
	}   

       return langs;
    }

    public int languageExists(String lang){
	for(int i=0;i<language_dependent_attributes.size();i++){
	    Attribute attr = (Attribute) language_dependent_attributes.get(i);
	    if (attr.getLanguage().trim().equals(lang.trim())){
		return i;
	    } 
	}   
	
	return -1;
    }

    protected Attribute getAttributeByName(String name){
        for(int i=0;i<attributes.size();i++){
	    Attribute attr = (Attribute) attributes.get(i);
            if (attr.getName() != null && attr.getName().trim().equals(name.trim())){
		return attr;
	    } 
	}

	return null;
    }

    protected Attribute getAttributeByNameAndLanguage(String name, String lang){
	for(int i=0;i<language_dependent_attributes.size();i++){
	    Attribute attr = (Attribute) language_dependent_attributes.get(i);
	    if (attr.getName() != null || attr.getLanguage()!=null){
		if (attr.getName().trim().equals(name.trim()) && (attr.getLanguage().trim().equals(lang.trim()))){
		    return attr;
		}
	    } 
	}
	
	return null;
    
    }

    protected ArrayList getAttributesByLanguage(String lang){
	  ArrayList attrs = new ArrayList();    
	  
	  for(int i=0;i<language_dependent_attributes.size();i++){
	      Attribute attr = (Attribute) language_dependent_attributes.get(i);
	      if (!attr.getLanguage().trim().equals("") && attr.getLanguage().trim().equals(lang)){
		  attrs.add(attr);
	      } 
	  }   
	  
	  return attrs;
      }

   protected boolean isAttributeRequired(String name) {
       for(int i=0;i<required_attribute_names.length;i++){
            if (name.equals(required_attribute_names[i])) return true;
	}
	return false;

    }

    protected boolean isLangDependentAttributeRequired(String name) {
	for(int i=0;i<language_dependent_attribute_names.length;i++){
            if (name.equals(language_dependent_attribute_names[i])) return true;
	}
	return false;

    }

}
