/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2022 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.cdm;

import org.greenstone.gatherer.util.StaticStrings;
import org.w3c.dom.*;

/** Handles facets for solr collections */
public class FacetManager extends BaseIndexManager {


    public FacetManager(Element facets, String current_build_type) {
	super(facets, current_build_type, StaticStrings.FACET_ELEMENT, null, new Facet());
	this.controls_title_key = "CDM.FacetManager.Title";
	this.new_button_tooltip_key = "CDM.FacetManager.New_Button_Tooltip";
	this.edit_button_tooltip_key = "CDM.FacetManager.Edit_Button_Tooltip";
	this.remove_button_tooltip_key = "CDM.FacetManager.Remove_Button_Tooltip";
	this.nip_new_index_key = "CDM.FacetManager.New";
	this.nip_edit_index_key = "CDM.FacetManager.Edit";
	this.nip_source_label_key = "CDM.FacetManager.Source";
        this.nip_source_tooltip_key = "CDM.FacetManager.Source_Tooltip";
	this.nip_custom_label_key = "CDM.IndexManager.Custom";
	this.nip_custom_tooltip_key = "CDM.IndexManager.Custom_Tooltip";
      
	this.nip_add_index_button_key = "CDM.FacetManager.Add";
	this.nip_add_index_tooltip_key = "CDM.FacetManager.Add_Tooltip";
	this.nip_replace_index_button_key = "CDM.FacetManager.Replace"; 
	this.nip_replace_index_tooltip_key = "CDM.FacetManager.Replace_Tooltip"; 
	this.nip_add_all_index_button_key = "CDM.IndexManager.AddAll";
	this.nip_add_all_index_tooltip_key = "CDM.FacetManager.AddAll_Tooltip";
 
    }

    public void buildTypeChanged(String new_build_type) {
	if (new_build_type.equals(BuildTypeManager.BUILD_TYPE_SOLR)) {
	    // activate
	    setAssigned(true);
	} else {
	    // deactivate
	    setAssigned(false);
	}
    }

}
