/**********************************************************************
 *
 * sqldbclass.h -- 
 * Copyright (C) 2008  DL Consulting Ltd
 * Copyright (C) 2010  New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef SQLDBCLASS_H
#define SQLDBCLASS_H


#include "dbclass.h"
#include "text_t.h"


class sqldbclass : public dbclass
{
public:
  sqldbclass(const text_t& gsdlhome);
  virtual ~sqldbclass();

  // returns array of document OIDs
  virtual text_tarray get_documents_where (const text_t& sql_initial_cmd,
					   const text_t& sort_by_metadata_element_name);

  // returns array of document OIDs
  virtual text_tarray get_documents_with_metadata_value (const text_tarray &metadata_element_names,
							 const text_t &metadata_value,
							 const text_t &sort_by_metadata_element_name) = 0;

  // returns array of values
  virtual text_tarray get_metadata_values (const text_tarray &metadata_element_names,
					   const text_t &metadata_value_filter,
					   const text_t &metadata_value_grouping_expression) = 0;

protected:
  virtual text_t sql_safe (const text_t &value_arg) = 0;

  virtual bool sqlexec(const text_t &sql_cmd) = 0;
  virtual bool sqlgetarray(const text_t& sql_cmd,
			   vector<text_tmap>& sql_results) = 0;
  virtual bool sqltableexists(const text_t &table_name) = 0;

};


#endif
