package org.greenstone.mgpp;

import java.util.Vector;

/** a java version of QueryResult for mgpp
 *
 * contains get methods for the java side, and simple
 * set methods to be called from c++ side
 *
 */
public class MGPPQueryResult {

    /** the list of MGPPDocInfo */
    protected Vector docs_=null;
    /** the list of MGPPTermInfo */
    protected Vector terms_=null;
    /** the total number of docs found - not likely to be the size of docs_*/
    protected long total_num_docs_=0;
    /** whether a syntax error has occurred */
    protected boolean syntax_error_ = false;
    
    MGPPQueryResult() {
	docs_ = new Vector();
	terms_ = new Vector();
    }
    /** clear the info from the last query - should be called before setting any new docs/terms */
    public void clear() {
	total_num_docs_=0;
	docs_.clear();
	terms_.clear();
	syntax_error_ = false;
    }
    /** returns the result as a String - useful for printing out results */
    public String toString() {
	
	String result = "";
	result += "docs (ranks): ";
	for (int i=0; i<docs_.size(); i++) {
	    result += ((MGPPDocInfo)docs_.elementAt(i)).toString()+", ";
	}
	result += "\nterms: ";
	for (int i=0; i<terms_.size(); i++) {
	    result += ((MGPPTermInfo)terms_.elementAt(i)).toString()+", ";
	}
	result += "\nactual number of docs found = "+total_num_docs_;

	return result;
    }
    /** a shorter representation - just terms and total docs - not the 
	individual docnums and ranks */
    public String toShortString() {
	String result = "";
	result += "\nterms: ";
	for (int i=0; i<terms_.size(); i++) {
	    result += ((MGPPTermInfo)terms_.elementAt(i)).toString()+", ";
	}
	result += "\nactual number of docs found = "+total_num_docs_;
	return result;
    }

    // set methods used by c++ code
    
    public void setTotalDocs(long num) {
	total_num_docs_=num;
    }

    public void addDoc(long doc, float rank) {
	MGPPDocInfo doc_info = new MGPPDocInfo(doc, rank);
	docs_.add(doc_info);
    }

    public void addTerm(String term, String tag, int stem, long match, long freq, String[] equivs) {
	MGPPTermInfo ti = new MGPPTermInfo();
	ti.term_=term;
	ti.tag_=tag;
	ti.stem_method_=stem;
	ti.match_docs_=match;
	ti.term_freq_=freq;
	if (equivs!=null) {
	  for (int i=0; i<equivs.length; i++) {
	    ti.equiv_terms_.add(equivs[i]);
	  }
	}
	terms_.add(ti);
    }

    // get methods for the java side
    public Vector getDocs() {
	return docs_;
    }

    public Vector getTerms() {
	return terms_;
    }

    public long getTotalDocs() {
	return total_num_docs_;
    }
     
    public void setSyntaxError(boolean error) {
	syntax_error_ = error;
    }

    public boolean hasSyntaxError() {
	return syntax_error_;
    }
}

