/**********************************************************************
 *
 * sqlbrowsefilter.cpp -- 
 * Copyright (C) 2008  DL Consulting Ltd
 * Copyright (C) 2010  New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "sqlbrowsefilter.h"

sqlbrowsefilterclass::sqlbrowsefilterclass ()
  : sqlfilterclass()
{}


sqlbrowsefilterclass::~sqlbrowsefilterclass ()
{}

void sqlbrowsefilterclass::filter (const FilterRequest_t &request,
				   FilterResponse_t &response,
				   comerror_t &err, ostream &logout)
{
  outconvertclass text_t2ascii;

  if (!connect_to_sqldb(response,err,logout)) {
    return;
  }

  // Request for the metadata values assigned to an element
  if (request.requestParams == "GetMetadataValues")
  {
    text_tarray metadata_element_names;
    text_t metadata_value_filter = "";
    text_t metadata_value_grouping_expression = "";
    OptionValue_tarray::const_iterator options_iterator = request.filterOptions.begin();
    while (options_iterator != request.filterOptions.end())
    {
      if ((*options_iterator).name == "MetadataElements")
      {
	splitchar ((*options_iterator).value.begin(), (*options_iterator).value.end(), ',', metadata_element_names);
      }
      if ((*options_iterator).name == "MetadataValueFilter")
      {
	metadata_value_filter = (*options_iterator).value;
      }
      if ((*options_iterator).name == "MetadataValueGroupingExpression")
      {
	metadata_value_grouping_expression = (*options_iterator).value;
      }
      options_iterator++;
    }

    text_tarray metadata_values = sql_db_ptr->get_metadata_values (metadata_element_names, metadata_value_filter, metadata_value_grouping_expression);

    // Create a map from metadata value to ResultDocInfo_t, to remove duplicate values and obtain occurrence counts
    map<text_t, ResultDocInfo_t> unique_metadata_values_map;
    text_tarray::iterator metadata_value_iterator = metadata_values.begin();
    while (metadata_value_iterator != metadata_values.end())
    {
      text_t metadata_value = *metadata_value_iterator;

      // If no ResultDocInfo_t has already been created for this metadata value, create one now
      if (unique_metadata_values_map.find(metadata_value) == unique_metadata_values_map.end())
      {
	ResultDocInfo_t metadata_value_result_doc;
	metadata_value_result_doc.OID = metadata_value;
	metadata_value_result_doc.result_num = 1;
	unique_metadata_values_map[metadata_value] = metadata_value_result_doc;
      }
      // Otherwise we've seen this value before, so just update the occurrence count
      else
      {
	unique_metadata_values_map[metadata_value].result_num++;
      }

      metadata_value_iterator++;
    }

    // Fill in response.docInfo with the ResultDocInfo_t objects we've created above
    map<text_t, ResultDocInfo_t>::iterator unique_metadata_values_iterator = unique_metadata_values_map.begin();
    while (unique_metadata_values_iterator != unique_metadata_values_map.end())
    {
      response.docInfo.push_back ((*unique_metadata_values_iterator).second);
      unique_metadata_values_iterator++;
    }
  }

  // Request for the documents with a certain metadata value assigned
  else if (request.requestParams == "GetDocumentsWithMetadataValue")
  {
    text_tarray metadata_element_names;
    text_t metadata_value = "";
    text_t sort_by_metadata_element_name = "";
    OptionValue_tarray::const_iterator options_iterator = request.filterOptions.begin();
    while (options_iterator != request.filterOptions.end())
    {
      if ((*options_iterator).name == "MetadataElements")
      {
	splitchar ((*options_iterator).value.begin(), (*options_iterator).value.end(), ',', metadata_element_names);
      }
      if ((*options_iterator).name == "MetadataValue")
      {
	metadata_value = (*options_iterator).value;
      }
      if ((*options_iterator).name == "SortByMetadataElement")
      {
	sort_by_metadata_element_name = (*options_iterator).value;
      }
      options_iterator++;
    }

    text_tarray document_OIDs = sql_db_ptr->get_documents_with_metadata_value (metadata_element_names, metadata_value, sort_by_metadata_element_name);

    // Fill in response.docInfo with the document OIDs
    text_tarray::iterator document_OID_iterator = document_OIDs.begin();
    while (document_OID_iterator != document_OIDs.end())
    {
      ResultDocInfo_t document_result_doc;
      document_result_doc.OID = *document_OID_iterator;
      response.docInfo.push_back (document_result_doc);
      document_OID_iterator++;
    }
  }

  disconnect_from_sqldb();

}
